rem *******************************************************************
rem * Initial steps for using DRAW.DLL:
rem *
rem * 1. Load the dll:
rem *      EXTERNAL draw.dll
rem *
rem * 2. Init the DLL:
rem *      If the window name has spaces, you must insert NULL as
rem *      the window name, and the class name is required:
rem *            Example:  %m = @draw(INIT NULL 007)
rem *      Class name may be up to eight words, 20 chars each word.
rem *      If the window name is one word, the class name is optional.
rem *            Example1:  %m = @draw(INIT MyProgName)
rem *            Example2:  %m = @draw(INIT MyProgName 007)
rem *******************************************************************
rem * COMMANDS: (require additional parameters, vars may be used)
rem *
rem *    PEN        Sets pen color, style, width if desired.
rem *               Style: SOLID DASH DOT DASHDOT DASHDOTDOT
rem *               Colors: VDS 3 color names (no BACKGRND,FOREGRND),
rem *                       or Hex format 0x00FFFFFF (any color).
rem *               Width starts at 1 (SOLID is only style above 1).
rem *               Retains settings unless changed.
rem *               Example: %m = @draw(PEN RED SOLID 2)
rem *
rem *    FILL       Sets fill (brush) color to fill ellipses, etc.
rem *               Colors: VDS 3 color names (no BACKGRND,FOREGRND),
rem *                       or Hex format 0x00FFFFFF (any color).
rem *               Retains settings unless changed.
rem *               Example: %m = @draw(FILL YELLOW)
rem *
rem *    FONT       Sets font color, style, size, font type (background
rem *               is always transparent).
rem *               Colors: VDS 3 color names (no BACKGRND,FOREGRND),
rem *                       or Hex format 0x00FFFFFF (any color).
rem *               Styles: N = normal, B = bold,
rem *                       NI = normal italics, BI = bold italics. 
rem *               Size: Desired size of font.
rem *               Retains settings unless changed.
rem *               Either use color only, or include ALL parameters.
rem *               Example1: %m = @draw(FONT RED)
rem *               Example2: %m = @draw(FONT RED N 24 Times New Roman)
rem *
rem *    TEXT       Draws text (240 chars max) in current font at x1 y1.
rem *               Parenthesis, commas, etc. must be enclosed in quotes.
rem *               Example: %m = @draw(TEXT 10 40 "This is, (a test!)")
rem *
rem *    FLOOD      Floods the current area starting at x1,y1 with the
rem *               current FILL (brush) color. You may optionally name
rem *               the color that is being replaced, otherwise the
rem *               pixel color at x1, y1 determines replacement. The
rem *               area is flooded in all directions until a different
rem *               colored boundary (line, etc.) is reached.
rem *                 Replace pixel color at x1, y1:
rem *                   Example: %m = @draw(FLOOD 10 30)
rem *                 Name white pixels as ones to be replaced:
rem *                   Example: %m = @draw(FLOOD 10 30 WHITE)
rem *
rem *    LINE       Draws line from x1 y1 to x2 y2.
rem *               Example: %m = @draw(LINE 10 30 280 180)
rem *
rem *    ARC        Draws Arc within rectangle upper left x1 y1
rem *               lower right x2 y2, with first radial endpoint xy
rem *               at r1,r2 and second radial endpoint xy at r3,r4.
rem *               Sum of coordinates should not exceed 32,767.
rem *               Example:
rem *                    %m = @draw(ARC 120 120 200 200 120 120 200 200)
rem *               Tip: To see how ARC works, also draw a rectangle
rem *                    using the first 4 parameters of your arc.
rem *
rem *    RECTANGLE  Draws rectangle from x1 y1 upper left
rem *               to x2 y2 lower right.
rem *               Example: %m = @draw(RECTANGLE 10 30 280 180)
rem *
rem *    ROUNDRECT  Draws rounded rectangle from x1 y1 upper left to
rem *               x2 y2 lower right. Corner ellipse width and height
rem *               are optional (if using height, width is required),
rem *               defaults are 30.
rem *                 Example1: %m = @draw(ROUNDRECT 10 30 280 180)
rem *               Set corner ellipse width only:
rem *                 Example2: %m = @draw(ROUNDRECT 10 30 280 180 30)
rem *               Set corner ellipse width and height:
rem *                 Example3: %m = @draw(ROUNDRECT 10 30 280 180 30 10)
rem *
rem *    ELLIPSE    Draws ellipse from x1 y1 upper left to to x2 y2
rem *               lower right. If x1 y1 x2 y2 is square, draws a
rem *               circle, otherwise draws an ellipse.
rem *               Example: %m = @draw(ELLIPSE 60 80 280 185)
rem *******************************************************************
rem * SETTING THE EVENT:   DRAW sets @event() to "Draw"
rem *
rem * Use DRAW to set @event(), it may either be used to call the
rem * @draw() function, or called alone before the @draw function.
rem * The function @draw normally returns "OK" or an error message.
rem * Example1: DRAW @draw(LINE 280 70 280 180)
rem * Example2: DRAW
rem *           %m = @draw(LINE 280 70 280 180)
rem *           INFO This should be OK.  m = %m
rem *******************************************************************
rem *  !!! IMPORTANT !!!
rem * -> Leave one (1) blank space between all parameters to @draw().
rem * -> Using incorrect info for INIT usually still allows drawing
rem *    somewhere, so make sure window and class names are correct.
rem * -> The DLL does NOT check parameters, your VDS code should check
rem *    vars etc. for proper values before calling @draw() routines.
rem * -> The command and parameters can be put in one var and called.
rem * -> Command parameters are not case-sensitive.
rem * -> You should always use the PAINT style for your program, and
rem *    your draw routines should always be called through the PAINT
rem *    event label. Failure to do this will result in your drawings
rem *    NOT being refreshed after the window is minimized, etc.
rem *******************************************************************
rem * ABOUT THIS DSC FILE:
rem *
rem * This is a demo program designed to showcase some of the features
rem * in the DRAW.DLL and also act as a help file. The buttons that
rem * draw the lines, rectangle, round rectangle and ellipse are good
rem * examples of using the PAINT event so the program will redraw
rem * itself when minimized, moved off screen, etc.
rem *
rem * The Demo button and drawing with the mouse DO NOT use the PAINT
rem * event label (for simplicity here), so they will not redraw. Any
rem * routines you use should be run through the PAINT event label.
rem *
rem * The @draw() functions are reasonably fast, some delays (lights
rem * flashing, etc.) are used in the Demo to allow viewing time.
rem *******************************************************************

OPTION SCALE, 96

rem -- Load the DLL --
EXTERNAL draw.dll

TITLE By Mac
DIALOG CREATE,"DrawTest",-1,0,400,320,PAINT,CLASS 007,CLICK
 DIALOG ADD,BUTTON,Lines,5,15,50,20
 DIALOG ADD,BUTTON,Rect,5,70,50,20
 DIALOG ADD,BUTTON,RRect,5,125,50,20
 DIALOG ADD,BUTTON,Ellipse,5,180,50,20
 DIALOG ADD,BUTTON,Erase,5,235,50,20
 DIALOG ADD,BUTTON,Demo,5,290,100,20,"Run The Demo"

 DIALOG ADD,BUTTON,Test1,250,125,50,20
 DIALOG ADD,BUTTON,Test2,250,180,50,20
 DIALOG ADD,BUTTON,Test3,250,235,50,20
 DIALOG HIDE, Test1
 DIALOG HIDE, Test2
 DIALOG HIDE, Test3

 DIALOG ADD,STATUS,Stat
DIALOG SHOW

rem -- Init the DLL --
%m = @draw(INIT DrawTest 007)

rem -- List for PAINT to work from --
LIST CREATE, 9

rem -- Load a background to draw, since PAINT
rem -- style causes an automatic PAINT event.
LIST ADD, 9, DrawBkgrnd

:Test1BUTTON
:Test2BUTTON
:Test3BUTTON
:EVLOOP
  DIALOG SET, Stat, @sysinfo(FREEMEM)" kb free. Click Area For Mouse Draw..."
  WAIT EVENT
  goto @event()

:CLICK
  rem -- Mousedraw with current pen (this example does not repaint) --
  DIALOG SET, Stat, @sysinfo(FREEMEM)" kb free. Left click draws, Right click releases mouse."%a %b - %c %d
  if @equal(@click(B), RIGHT)
     %a = ""
  else
     PARSE "%a;%b", @click(XY)
  end
  rem -- Returns to CLICK label since we don't use the @event() --
  WAIT EVENT
  if @equal(@click(B), RIGHT)
     %a = ""
  end
  if %a
     PARSE "%c;%d", @click(XY)
     %m = @draw(LINE %a %b %c %d)
  end
  goto EVLOOP

:PAINT
  rem -- This routine is where screen is updated when minimized,
  rem -- maximized, etc. All pictures, etc. should be in a GOSUB
  rem -- routine and added to list 9 so the program can repaint.
  rem -- The demo and mouse draw are not repainted for simplicity.
  if @greater(1, @count(9))
     goto EVLOOP
  end
  if @greater(@count(9), 1)
     %x = 0
     %%entry = @item(9, @pred(@count(9)))
     REPEAT
       rem -- If last item is found, remove previous entry --
       if @greater(@pos(%%entry, @item(9, %x)), 0)
          LIST DELETE, 9
          %x = @diff(@count(9), 2)
       end
       %x = @succ(%x)
     UNTIL @equal(%x, @pred(@count(9)))
  end
  %x = 0
  REPEAT
    GOSUB @item(9, %x)
    %x = @succ(%x)
  UNTIL @equal(%x, @count(9))
  goto EVLOOP

rem -------------------------------------------------------------------
rem -- These buttons add routines to list 9. The GOSUB routines are
rem -- then called from :PAINT to be available for screen update.

:LinesBUTTON
  LIST ADD, 9, DrawLine
  goto PAINT

:EllipseBUTTON
  LIST ADD, 9, DrawEllipse
  goto PAINT

:RectBUTTON
  LIST ADD, 9, DrawRect
  goto PAINT

:RRectBUTTON
  LIST ADD, 9, DrawRoundRect
  goto PAINT

:BkgrndBUTTON
  LIST ADD, 9, DrawBkgrnd
  goto PAINT

:EraseBUTTON
  LIST CLEAR, 9
  LIST ADD, 9, DrawBkgrnd
  goto PAINT

rem -------------------------------------------------------------------

rem -- This showcases features and hopefully will give you some ideas.
rem -- It's not added to list 9, so it does NOT repaint if minimized.

:DemoBUTTON
  if @not(@query("Demo runs less than 2 minutes."@cr()@cr()Continue?))
     goto EVLOOP
  end
  LIST CREATE, 1
  DIALOG SET, Stat, "DEMO in progress, Please Wait..."

  GOSUB DrawBkgrnd
  GOSUB DrawLights

  rem -- Load some fonts and text in List 1 --
  LIST ADD, 1, FONT LTGREEN B 36 Times New Roman|TEXT 30 60 Welcome
  LIST ADD, 1, FONT RED B 36 Times New Roman|TEXT 60 90 to
  LIST ADD, 1, FONT MAGENTA B 36 Times New Roman|TEXT 90 120 the
  LIST ADD, 1, FONT LTBLUE BI 36 Times New Roman|TEXT 120 150 Draw.dll Demo
  LIST ADD, 1, FONT BLACK BI 20 Arial|TEXT 150 190 From McLain Software@chr(169)

  %x = 0
  REPEAT
    rem -- Set the font and draw the text from List 1 --
    PARSE "%f;%t", @item(1,%x)
    %m = @draw(%f)
    %m = @draw(%t)
    GOSUB FlashLights
    %x = @succ(%x)
  UNTIL @equal(%x, @count(1))
  %x = 0
  REPEAT
    GOSUB FlashLights
    %x = @succ(%x)
  UNTIL @greater(%x, 10)

  GOSUB DrawBkgrnd
  GOSUB DrawLights

  %m = @draw(FONT LTBLUE BI 24 Times New Roman)
  %m = @draw(TEXT 40 60 You can draw things...)
  GOSUB FlashLights
  GOSUB FlashLights

  rem -- Load list with car drawing info --
  LIST CLEAR, 1
  LIST ADD, 1, LINE 123 136 202 149|LINE 202 149 265 131
  LIST ADD, 1, LINE 265 131 190 120|LINE 190 120 123 136
  LIST ADD, 1, LINE 123 136 106 158|LINE 202 149 184 177
  LIST ADD, 1, LINE 106 158 185 175|LINE 106 158 61 180
  LIST ADD, 1, LINE 61 180 61 200|LINE 61 200 125 216
  LIST ADD, 1, LINE 125 216 148 208|LINE 148 208 154 195
  LIST ADD, 1, LINE 154 195 175 190|LINE 175 190 184 197
  LIST ADD, 1, LINE 184 197 248 177|LINE 248 177 251 164
  LIST ADD, 1, LINE 251 164 268 157|LINE 268 157 277 163
  LIST ADD, 1, LINE 277 163 289 157|LINE 289 157 265 131
  LIST ADD, 1, ELLIPSE 153 193 180 228|LINE 163 227 143 219
  LIST ADD, 1, LINE 143 219 140 211|ELLIPSE 252 160 276 194
  LIST ADD, 1, LINE 260 193 241 188|LINE 241 188 238 180


  rem -- Draw the car --
  %x = 0
  REPEAT
    PARSE "%a;%b", @item(1,%x)
    %m = @draw(PEN BLACK SOLID 1)
    %m = @draw(FILL WHITE)
    %m = @draw(%a)
    GOSUB FlashLights
    %m = @draw(PEN BLACK SOLID 1)
    %m = @draw(FILL WHITE)
    %m = @draw(%b)
    GOSUB FlashLights
    %x = @succ(%x)
  UNTIL @equal(%x, @count(1))

  %m = @draw(TEXT 40 250 And paint things...)
  GOSUB FlashLights
  GOSUB FlashLights

  rem -- Paint the car body --
  %m = @draw(FILL RED)
  %m = @draw(FLOOD 100 200 WHITE)
  %m = @draw(FLOOD 190 140 WHITE)
  GOSUB FlashLights
  rem -- Windshield --
  %m = @draw(FILL SILVER)
  %m = @draw(FLOOD 150 150 WHITE)
  GOSUB FlashLights
  rem -- Tire sidewall --
  %m = @draw(FILL GRAY)
  %m = @draw(FLOOD 165 200 WHITE)
  %m = @draw(FLOOD 260 180 WHITE)
  GOSUB FlashLights
  rem -- Tire tread --
  %m = @draw(FILL BLACK)
  %m = @draw(FLOOD 150 212 WHITE)
  %m = @draw(FLOOD 245 183 WHITE)

  GOSUB FlashLights
  GOSUB FlashLights
  GOSUB FlashLights

  GOSUB DrawBkgrnd
  GOSUB DrawLights

  %m = @draw(FONT LTBLUE BI 24 Times New Roman)
  %m = @draw(TEXT 40 60 You can create special effects...)
  GOSUB FlashLights
  GOSUB FlashLights

  %x = 10
  %y = 1
  REPEAT
    %m = @draw(PEN YELLOW SOLID 2)
    %m = @draw(FILL LTBLUE)
    %m = @draw(ELLIPSE %x 100 @sum(%x,40) 110)

    %m = @draw(FILL RED)
    %m = @draw(ELLIPSE @prod(%y,35) 40 @sum(@prod(%y,35),20) 48)

    %m = @draw(PEN DKBLUE SOLID 2)
    %m = @draw(FILL DKBLUE)
    %m = @draw(ELLIPSE %x 100 @sum(%x,40) 110)

    %m = @draw(FILL DKRED)
    %m = @draw(ELLIPSE @prod(%y,35) 40 @sum(@prod(%y,35),20) 48)

    if @greater(350,%x)
       %x = @succ(%x)
    else
       %x = 10
       %y = @succ(%y)
       WAIT .1
    end
  UNTIL @greater(%y, 10)

  %m = @draw(FONT DKGREEN BI 24 Times New Roman)
  %m = @draw(TEXT 40 130 Custom progress bars...)
  GOSUB FlashLights
  GOSUB FlashLights

  %m = @draw(PEN BLACK SOLID 1)
  %m = @draw(FILL SILVER)
  %m = @draw(RECTANGLE 127 170 281 185)

  %x = 13
  REPEAT
    %m = @draw(PEN BLACK SOLID 1)
    %m = @draw(FILL LTBLUE)
    %m = @draw(ELLIPSE @prod(%x,10) 171 @sum(@prod(%x,10),8) 184)
    GOSUB FlashLights
    %x = @succ(%x)
  UNTIL @greater(%x, 27)

  %m = @draw(FONT MAGENTA BI 24 Times New Roman)
  %m = @draw(TEXT 40 210 Customize controls...)
  GOSUB FlashLights
  GOSUB FlashLights

  DIALOG SHOW, Test1
  DIALOG SHOW, Test2
  DIALOG SHOW, Test3
  GOSUB FlashLights
  GOSUB FlashLights

  %m = @draw(PEN BLACK SOLID 1)
  %m = @draw(FILL CYAN)
  %m = @draw(RECTANGLE 123 248 176 271)
  GOSUB FlashLights
  GOSUB FlashLights

  %m = @draw(PEN BLACK SOLID 1)
  %m = @draw(FILL YELLOW)
  %m = @draw(RECTANGLE 178 248 231 271)
  GOSUB FlashLights
  GOSUB FlashLights

  %m = @draw(PEN BLACK SOLID 1)
  %m = @draw(FILL LTGREEN)
  %m = @draw(RECTANGLE 233 248 286 271)
  %x = 0
  REPEAT
    GOSUB FlashLights
    %x = @succ(%x)
  UNTIL @greater(%x, 10)
  DIALOG HIDE, Test1
  DIALOG HIDE, Test2
  DIALOG HIDE, Test3

  rem -- Charts and graphs --
  GOSUB DrawBkgrnd
  %m = @draw(FONT LTBLUE BI 24 Times New Roman)
  %m = @draw(TEXT 20 40 You can make charts and graphs...)
  %m = @draw(PEN SILVER SOLID 1)
  %x = 80
  REPEAT
    %m = @draw(LINE 0 %x 400 %x)
    %x = @sum(%x, 10)
  UNTIL @greater(%x, 280)

  %x = 140
  REPEAT
    %m = @draw(LINE %x 80 %x 280)
    %x = @sum(%x, 10)
  UNTIL @greater(%x, 390)

  %m = @draw(PEN BLACK SOLID 2)
  %m = @draw(LINE 0 280 400 280)

  rem -- Bar chart --
  %m = @draw(PEN LTBLUE SOLID 1)
  %m = @draw(FILL LTBLUE)
  %x = 279
  REPEAT
    %m = @draw(RECTANGLE 20 %x 40 279)
    WAIT .01
    %x = @pred(%x)
  UNTIL @greater(195, %x)
  %m = @draw(PEN LTGREEN SOLID 1)
  %m = @draw(FILL LTGREEN)
  %x = 279
  REPEAT
    %m = @draw(RECTANGLE 50 %x 70 279)
    WAIT .01
    %x = @pred(%x)
  UNTIL @greater(255, %x)
  %m = @draw(PEN RED SOLID 1)
  %m = @draw(FILL RED)
  %x = 279
  REPEAT
    %m = @draw(RECTANGLE 80 %x 100 279)
    WAIT .01
    %x = @pred(%x)
  UNTIL @greater(225, %x)

  rem -- Line chart --
  %m = @draw(PEN RED SOLID 3)
  %y = 250
  %x = 160
  REPEAT
    %m = @draw(LINE 160 250 %x %y)
    WAIT .01
    %x = @succ(%x)
    %y = @pred(%y)
  UNTIL @greater(%x, 200)
  %a = %x
  %b = %y
  REPEAT
    %m = @draw(LINE %a %b %x %y)
    WAIT .01
    %x = @succ(%x)
    %y = @sum(%y,2)
  UNTIL @greater(%x, 210)
  %a = %x
  %b = %y
  REPEAT
    %m = @draw(LINE %a %b %x %y)
    WAIT .01
    %x = @succ(%x)
    %y = @diff(%y,2)
  UNTIL @greater(%x, 230)
  %a = %x
  %b = %y
  REPEAT
    %m = @draw(LINE %a %b %x %y)
    WAIT .01
    %x = @succ(%x)
    %y = @succ(%y)
  UNTIL @greater(%x, 250)
  %a = %x
  %b = %y
  REPEAT
    %m = @draw(LINE %a %b %x %y)
    WAIT .01
    %x = @succ(%x)
    %y = @pred(%y)
  UNTIL @greater(%x, 270)
  %a = %x
  %b = %y
  REPEAT
    %m = @draw(LINE %a %b %x %y)
    WAIT .01
    %x = @sum(%x,2)
    %y = @succ(%y)
  UNTIL @greater(%x, 300)
  %a = %x
  %b = %y
  REPEAT
    %m = @draw(LINE %a %b %x %y)
    WAIT .01
    %x = @sum(%x,3)
    %y = @pred(%y)
  UNTIL @greater(%x, 380)
  WAIT 3

  rem -- Fade Colors --
  GOSUB DrawBkgrnd
  %x = 0
  %s = $FF0000
  %p = $FF00
  REPEAT
    if @greater(63, %x)
       %s = @sum(%s, 4)
       %p = @sum(%p, 4)
    else
       %s = @diff(%s, 4)
       %p = @diff(%p, 4)
    end
    REPEAT
      %s = 0%s
    UNTIL @greater(@len(%s), 7)
    %m = @draw(FILL 0x@hex(%s,8))
    %m = @draw(ROUNDRECT 100 100 300 200 20 20)
    %m = @draw(FONT 0x@hex(%p,8) BI 24 Times New Roman)
    %m = @draw(TEXT 40 60 You can fade colors...)
    WAIT .01
    %x = @succ(%x)
  UNTIL @greater(%x, 124)

  rem -- Last screen of demo --
  GOSUB DrawBkgrnd
  %m = @draw(FONT BLACK B 16 ARIAL)
  %m = @draw(TEXT 40 30 "( Demo is over )")
  %m = @draw(FONT LTBLUE BI 24 Times New Roman)
  %m = @draw(TEXT 40 60 The available drawing shapes...)
  %m = @draw(PEN BLACK DASH 1)
  %m = @draw(LINE 20 100 100 100)
  %m = @draw(PEN BLACK DOT 1)
  %m = @draw(LINE 20 110 100 110)
  %m = @draw(PEN BLACK DASHDOT 1)
  %m = @draw(LINE 20 120 100 120)
  %m = @draw(PEN BLACK DASHDOTDOT 1)
  %m = @draw(LINE 20 130 100 130)
  %m = @draw(PEN BLACK SOLID 1)
  %m = @draw(LINE 20 140 100 140)

  %m = @draw(ARC 20 100 100 180 20 155 180 180)
  %m = @draw(FILL WHITE)
  %m = @draw(RECTANGLE 120 100 200 180)
  %m = @draw(ROUNDRECT 220 100 300 180)
  %m = @draw(ELLIPSE 320 100 380 180)

  %m = @draw(FONT RED BI 16 Arial)
  %m = @draw(TEXT 20 200 "You can choose pen color, style, width...")
  %m = @draw(FONT DKGREEN BI 16 Arial)
  %m = @draw(TEXT 20 220 "You can choose fill color for rectangles, etc...")
  %m = @draw(FONT LTBLUE BI 16 Arial)
  %m = @draw(TEXT 20 240 "You can choose fonts, color, style, size...")
  %m = @draw(FONT BLACK BI 16 Arial)
  %m = @draw(TEXT 20 260 "You can also use hex colors (0x00000000, etc.)...")

  LIST CLOSE, 1
  %e = @event()
  goto EVLOOP

:CLOSE
  EXIT

rem ---------------------- GOSUB ROUTINES -----------------------------

:DrawLights
  rem -- Draw some lights --
  %m = @draw(PEN BLACK SOLID 2)
  %m = @draw(FILL DKRED)
  %x = 1
  REPEAT
    %m = @draw(ELLIPSE @prod(%x,35) 40 @sum(@prod(%x,35),20) 48)
    %x = @succ(%x)
  UNTIL @greater(%x, 10)
  exit

:FlashLights
  rem -- Flash the red lights --
  %m = @draw(PEN BLACK SOLID 2)
  %y = 1
  REPEAT
    %m = @draw(FILL RED)
    %m = @draw(ELLIPSE @prod(%y,35) 40 @sum(@prod(%y,35),20) 48)
    WAIT .01
    %m = @draw(FILL DKRED)
    %m = @draw(ELLIPSE @prod(%y,35) 40 @sum(@prod(%y,35),20) 48)
    %y = @succ(%y)
  UNTIL @greater(%y, 10)
  exit

:DrawLine
  %m = @draw(PEN BLACK DOT 1)
  %m = @draw(LINE 10 30 390 270)
  %m = @draw(PEN BLACK SOLID 2)
  %m = @draw(LINE 10 40 390 280)
  %m = @draw(PEN BLACK SOLID 4)
  %m = @draw(LINE 10 50 390 290)
  exit

:DrawRect
  %m = @draw(PEN RED SOLID 2)
  %m = @draw(FILL YELLOW)
  %m = @draw(RECTANGLE 20 40 350 240)
  %m = @draw(FONT RED B 16 Courier New)
  %m = @draw(TEXT 30 45 Rectangle)
  exit

:DrawRoundRect
  %m = @draw(PEN BLACK SOLID 1)
  %m = @draw(FILL LTGREEN)
  %m = @draw(ROUNDRECT 40 60 360 260 20 20)
  %m = @draw(FONT BLACK B 16 Arial)
  %m = @draw(TEXT 50 65 Round Rectangle)
  exit

:DrawEllipse
  %m = @draw(PEN BLACK SOLID 3)
  %m = @draw(FILL LTBLUE)
  %m = @draw(ELLIPSE 60 80 380 285)
  %m = @draw(FONT YELLOW BI 24 Times New Roman)
  %m = @draw(TEXT 180 90 Ellipse)
  exit

:DrawBkgrnd
  %m = @draw(PEN BLACK SOLID 1)
  %m = @draw(FILL WHITE)
  %m = @draw(RECTANGLE 0 0 400 300)
  exit



