unit Memodll;

interface

uses
  WinTypes, WinProcs, SysUtils, Messages,
  Menus,Classes,Vdsmemo,Dialogs,stdctrls;

Type
  exteventproc = procedure(eventtype: PChar);
  MemoEvent = Class(TObject)
    Procedure EventRaised(Event:PChar);
  end;
  {$IFNDEF VER80}
  cdecl;
  {$ENDIF}

const
  max_par = 3;        { maximum number of params/args (user-definable) }
  buf_size = 256;     { parameter buffer size (user-definable) }

var
  AHandle: THandle;   { application handle }
  eventproc: exteventproc;
  memoeventproc: MemoEvent;
  p, errorcode: Integer;
  parambuf: Array[0..buf_size-1] of Char; { use GetMem/FreeMem for large buffers }
  MenuExists: Boolean;


  { start user-defined variables }
  rstat: Boolean;
  GedMemo:TVDSMemo;
  { end user-defined variables }

function Init(Handle: THandle; Addr: exteventproc; KeyString: PChar; var maxpar,bufsize: Integer): PChar; export;
{$IFNDEF VER80}
cdecl;
{$ENDIF}

function CommandProc(Params: PChar): Integer; export;
{$IFNDEF VER80}
cdecl;
{$ENDIF}

function FuncProc(Args: PChar): PChar; export;
{$IFNDEF VER80}
cdecl;
{$ENDIF}

function StatProc: Integer; export;
{$IFNDEF VER80}
cdecl;
{$ENDIF}

implementation

{ begin utility functions (not exported) }
function NextParam: PChar; {get next command parameter}
begin
  Result := Addr(parambuf[p]);
  while parambuf[p]<>#0 do
  begin
    inc(p);
  end;
  inc(p);
end;

{ end utility functions }

{ begin exported functions }

function Init(Handle: THandle; addr: exteventproc; KeyString: PChar; var maxpar,bufsize: Integer): PChar;
var
  Text: array[0..255] of Char;
Begin
  AHandle := Handle;
  eventproc := addr;
  maxpar := max_par;
  bufsize := buf_size;
  { start user-defined code }
  GedMemo:=TVDSMemo.Create(GedMemo);
  GedMemo.Caption:=strpas(keystring);
  MemoEventProc:=MemoEvent.Create;
  GedMemo.Initialise(MemoEventProc.EventRaised);
  Result:='Memo'
  { end user-defined code (remember to set Result) }
end;

function CommandProc(Params: PChar): Integer;
var
  cmdtype: String;
  menuparams: String;
  ok: boolean;
begin
  errorcode := 0;                         {initialise errorcode}
  for p := 0 to pred(buf_size) do
    parambuf[p] := Params[p];             {copy parameter string into buffer}
  p := 0;                                 {set pointer for NextParam}

  { start user-defined code }
  cmdtype:=strpas(StrUpper(NextParam));
  errorcode := 1;
  if cmdtype = 'SHOW' Then
  Begin
     GedMemo.Visible := True;
     errorcode := 0
  end;
  if cmdtype = 'HIDE' Then
  Begin
     GedMemo.Visible := False;
     errorcode := 0
  end;
  if cmdtype = 'MENU' Then
  Begin
     Gedmemo.AddMenu(StrPas(NextParam),GedMemo.MainMenu1.Items);
     errorcode := 0
  end;
  if cmdtype = 'TEXT' Then
  Begin
     Gedmemo.Memo.Text:=StrPas(NextParam);
     errorcode := 0
  end;
  if cmdtype = 'SELTEXT' Then
  Begin
     Gedmemo.Memo.SelText:=StrPas(NextParam);
     errorcode := 0
  end;
  if cmdtype = 'ENABLE' Then
  Begin
       Gedmemo.Memo.Enabled:=True;
       errorcode:=0
  end;
  if cmdtype = 'DISABLE' Then
  Begin
       Gedmemo.Memo.Enabled:=False;
       errorcode:=0
  end;
  if cmdtype = 'ITEMENABLED' Then
  Begin
       Gedmemo.ItemEnabled(StrPas(NextParam),StrPas(StrUpper(NextParam)));
       errorcode:=0
  end;
  if cmdtype = 'ITEMVISABLE' Then
  Begin
       Gedmemo.ItemEnabled(StrPas(NextParam),StrPas(StrUpper(NextParam)));
       errorcode:=0
  end;
  if cmdtype = 'ITEMREDEFINE' Then
  Begin
       Gedmemo.ItemRedefine(StrPas(NextParam),StrPas(NextParam));
       errorcode:=0
  end;
  if cmdtype = 'SCROLLBARS' Then
  Begin
    menuparams:=strpas(StrUpper(NextParam));
    errorcode:=0;
    if menuparams = 'HORIZONTAL' then
       Gedmemo.Memo.ScrollBars := ssHorizontal;
    if menuparams = 'VERTICAL' Then
       Gedmemo.Memo.ScrollBars := ssVertical;
    if menuparams = 'BOTH' Then
       Gedmemo.Memo.ScrollBars := ssBoth;
  end;
  if cmdtype = 'WORDWRAP' Then
  Begin
     errorcode:=0;
     Gedmemo.Memo.WordWrap := (strpas(StrUpper(NextParam)) = 'ON');
  end;
  if cmdtype = 'LOADFILE' Then
  Begin
     menuparams := strpas(NextParam);
     errorcode:=0;
     if fileexists(menuparams) then
     Gedmemo.Memo.Lines.Loadfromfile(menuparams);
  end;
  if cmdtype = 'SAVEFILE' Then
  Begin
     errorcode:=0;
     Gedmemo.Memo.Lines.SaveToFile(strpas(NextParam));
  end;

  { end user-defined code }

  Result := errorcode;
end;

function FuncProc(Args: PChar): PChar;
var
  arg,
  resbuf: Array[0..255] of Char;
  functype:String;
  p1,p2: Integer;
begin
  { don't zeroise errorcode in case it is set by previous function }
  for p := 0 to pred(buf_size) do
    parambuf[p] := Args[p];             {copy parameter string into buffer}
  p := 0;                                 {set pointer for NextParam}
  { start user-defined code }
  Functype:=StrPas(StrUpper(NextParam));
  If functype='TEXT' then
     StrPCopy(ResBuf,GedMemo.Memo.Text);
  If functype='SELTEXT' then
     StrPCopy(ResBuf,GedMemo.Memo.SelText);
  If functype='CHANGE' then
  begin
     If GedMemo.memo.modified=True then
        StrPCopy(ResBuf,'1')
     else
        StrPCopy(ResBuf,'');
     GedMemo.memo.modified:=False;
  end;
  { end user-defined code }
  Result := resbuf;
end;

function StatProc: Integer;
{ this function requires no modification }
begin
  Result := errorcode;
end;

procedure MemoEvent.eventraised(event:PChar);
Begin
    exteventproc(eventproc)(event)
End;

end.
