unit VDSCONSOLEDLL;

interface

uses
  Windows, Classes, SysUtils, ConsoleIO;

type
  exteventproc = procedure(eventtype: PChar);
  cdecl;
  
  type TConsoleEvent = class(TGui2Console)
  private
  procedure OnDone(Sender: TObject);
  procedure OnLine(Sender: TObject; const Line: String);
  procedure OnPrompt(Sender: TObject; const Line: String);
  procedure OnStatus(Sender: TObject; const Status: String);
  procedure OnTimeOut(Sender: TObject; var Kill: Boolean);
  end;

const
  max_par = 4;        { maximum number of params/args (user-definable) }
  buf_size = 256;     { parameter buffer size (user-definable) }

var
  AHandle: THandle;   { application handle }
  eventproc: exteventproc;
  p, errorcode: Integer;
  parambuf: Array[0..buf_size-1] of Char; { use GetMem/FreeMem for large buffers }
  { start user-defined variables }
  Console: TGui2Console;
  ConsoleEvent: TConsoleEvent;
  LineText: string;
  StatusText: string;
  TimeOut: boolean;
  { end user-defined variables }

function Init(Handle: THandle; Addr: exteventproc; KeyString: PChar; var maxpar,bufsize: Integer): PChar; export;
cdecl;
function CommandProc(Params: PChar): Integer; export;
cdecl;
function FuncProc(Args: PChar): PChar; export;
cdecl;
function StatProc: Integer; export;
cdecl;


implementation

function NextParam: PChar; {get next command parameter}
begin
  Result := Addr(parambuf[p]);
  while parambuf[p]<>#0 do
  begin
    inc(p);
  end;
  inc(p);
end;



{ begin exported functions }

function Init(Handle: THandle; addr: exteventproc; KeyString: PChar; var maxpar,bufsize: Integer): PChar;
 begin
 AHandle := Handle;
 eventproc := addr;
 maxpar := max_par;
 bufsize := buf_size;
 Result := 'CONSOLEIO';
 end;


function CommandProc(Params: PChar): Integer;
var
Buffer1: string;
Buffer2: string;
Buffer3: string;
Buffer4: string;
begin
  errorcode := 0;                         {initialise errorcode}
  for p := 0 to pred(buf_size) do
    parambuf[p] := Params[p];             {copy parameter string into buffer}
  p := 0;                                 {set pointer for NextParam}
  { start user-defined code }
  Buffer1 := UpperCase(NextParam);
  Buffer2 := NextParam;
  Buffer3 := NextParam;
  Buffer4 := NextParam;

  if Buffer1 = 'OPEN' then
  begin
  try
     Console := TGui2Console.Create(nil);
     Console.OnDone := ConsoleEvent.OnDone;
     Console.OnLine := ConsoleEvent.OnLine;
     Console.OnPrompt := ConsoleEvent.OnPrompt;
     Console.OnStatus := ConsoleEvent.OnStatus;
     Console.OnTimeOut := ConsoleEvent.OnTimeOut;
     Console.BufferSize := bs8k;
     Console.PipeSize := ps256k;
     TimeOut := False;
  except
  end;
  end
  else
  if Buffer1 = 'CLOSE' then
  begin
  try
    Console.Free;
  except
  end;
  end
  else
  if Buffer1 = 'START' then
  begin
  try
    if FileExists(Buffer2) then
    begin
     Console.Application := Buffer2;
     Console.Command := Buffer3;
     Console.LogFile := Buffer4;
     Console.Start;
    end;
  except
  end;
  end
  else
  if Buffer1 = 'STOP' then
  begin
  try
    Console.Stop;
  except
  end;
  end
  else
  if Buffer1 = 'REFRESH' then
  begin
  try
     Console.BufferSize := bs8k;
     Console.PipeSize := ps256k;
     TimeOut := False;
     LineText := '';
     StatusText := '';
  except
  end;
  end
  else
  if Buffer1 = 'PRIORITY' then
  begin
  try
    Buffer2 := UpperCase(Buffer2);
    if not(Buffer2 = '') then
    begin
     if Buffer2 = 'NORMAL' then
     Console.Priority := tpNormal
     else if Buffer2 = 'IDLE' then
     Console.Priority := tpIdle
     else if Buffer2 = 'TIMECRITICAL' then
     Console.Priority := tpTimeCritical
     else if Buffer2 = 'LOWER' then
     Console.Priority := tpLower
     else if Buffer2 = 'LOWEST' then
     Console.Priority := tpLowest
     else if Buffer2 = 'HIGHER' then
     Console.Priority := tpHigher
     else if Buffer2 = 'HIGHEST' then
     Console.Priority := tpHighest
     else
     Console.Priority := tpNormal;
    end;
  except
  end;
  end
  else
  if Buffer1 = 'PROMPT' then
  begin
  try
    Console.Prompt := Buffer2;
  except
  end;
  end
  else
  if Buffer1 = 'TIMEOUT' then
  begin
  try
    if not(Buffer2 = '') AND (StrToInt(Buffer2) >= 0) then
    begin
    Console.TimeOutDelay := StrToInt(Buffer2);
    end
    else
    begin
    Console.TimeOutDelay := 60;
    end;
    if (Buffer3 = '') OR (Buffer3 = '0') then
    begin
    TimeOut := False;
    end
    else
    if Buffer3 = '1' then
    begin
    TimeOut := True;
    end;
  except
  end
  end
  else
  if Buffer1 = 'WRITE' then
  begin
  try
    Console.Write(Buffer2);
  except
  end;
  end
  else
  if Buffer1 = 'WRITELINE' then
  begin
  try
    Console.WriteLN(Buffer2);
  except
  end;
  end;
  { end user-defined code }
  Result := errorcode;

end;

function FuncProc(Args: PChar): PChar;
var
  Buffer1: string;
  resbuf: Array[0..255] of Char;
  resultbuf: string;
begin
  { don't zeroise errorcode in case it is set by previous function }
  for p := 0 to pred(buf_size) do
    parambuf[p] := Args[p];             {copy parameter string into buffer}
  p := 0;                                 {set pointer for NextParam}
  { start user-defined code }
  Buffer1 := UpperCase(NextParam);
  if Buffer1 = 'STATUS' then
  begin
    try
    resultbuf := StatusText;
    StatusText := '';
    except
    Errorcode := 13;
    end;
  end
  else
  if Buffer1 = 'READ' then
  begin
    try
    resultbuf := LineText;
    LineText := '';
    except
    Errorcode := 13;
    end;
  end;
  { end user-defined code }
  StrCopy(resbuf,PChar(resultbuf));
  Result := resbuf;
end;

function StatProc: Integer;
{ this function requires no modification }
begin
  Result := errorcode;
end;

procedure TConsoleEvent.OnDone(Sender: TObject);
begin
exteventproc(eventproc) ('ONDONE');
end;

procedure TConsoleEvent.OnLine(Sender: TObject; const Line: String);
begin
LineText := Line;
exteventproc(eventproc) ('ONLINE');
end;

procedure TConsoleEvent.OnPrompt(Sender: TObject; const Line: String);
begin
LineText := Line;
exteventproc(eventproc) ('ONPROMPT');
end;

procedure TConsoleEvent.OnStatus(Sender: TObject; const Status: String);
begin
StatusText := Status;
exteventproc(eventproc) ('ONSTATUS');
end;

procedure TConsoleEvent.OnTimeOut(Sender: TObject; var Kill: Boolean);
begin
Kill := TimeOut;
exteventproc(eventproc) ('ONTIMEOUT');
end;

initialization
finalization

end.
