//PBShareMap.
//
//Author:	Poul Bak
{Copyright  1999-2000 : BakSoft-Denmark (Poul Bak). All rights reserved.}
{http://home11.inet.tele.dk/BakSoft/}
{Mailto: baksoft-denmark@dk2net.dk}
//
{Component Version: 2.00.00.00}
//
{PBShareMap is an easy-to-use component that uses file-mapping to let 2 or more applications share a TStringList and thereby all variables that can be converted to text (use the Name=Value approach). The applications can be instances of the same application or different applications (each with PBShareMap component).}
{Set AutoSynchronize to true and changing the list in one application automatically updates the other(s).}
{ExistsAlready can be used to limit your application to one instance.}
{Multiple PBShareMaps can be on one Form.}
{Default property: Values. Use it to easyly store variables - like an INI-file.}

{Context-sensitive help is included.}
unit PBShareMap;

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
	StdCtrls, Dialogs;

type
{Author:	Poul Bak}
{Copyright  1999-2000 : BakSoft-Denmark (Poul Bak). All rights reserved.}
{http://home11.inet.tele.dk/BakSoft/}
{Mailto: baksoft-denmark@dk2net.dk}
//
{Component Version: 2.00.00.00}
//
{PBShareMap is an easy-to-use component that uses file-mapping to let 2 or more applications share a TStringList and thereby all variables that can be converted to text (use the Name=Value approach). The applications can be instances of the same application or different applications (each with PBShareMap component).}
{Set 'AutoSynchronize' to true and changing the list in one application automatically updates the other(s).}
{ExistsAlready can be used to limit your application to one instance.}
{Multiple PBShareMaps can be on one Form.}
{Default property: Values. Use it to easyly store variables - like an INI-file.}
{Applist automatically holds the handles of all Owner-forms using the same map.}
{Importent: The MapName is the property that holds the common name that different applications use to share a file-mapping object.}
{It must be unique in the system at any time.}
	TPBShareMap = class(TComponent)
	private
		{ Private declarations }
		FMapHandle, FMutexHandle, FAppListHandle : THandle;
		FMapName, FSynchMessage, FApplistMessage, FVersion : string;
		FMapStrings, FAppListStrings : TStringList;
		FSize, FMessageID, FApplistMessageID : DWord;
		FMapPointer, FAppListPointer : PChar;
		FAutoOpen, FLocked, FIsMapOpen, FExistsAlready : Boolean;
		FReading, FAppListReading, FAutoSynch : Boolean;
		FOnChange, FOnAppListChange : TNotifyEvent;
		FFormHandle: Hwnd;
		FPNewWndHandler, FPOldWndHandler: Pointer;
		FMapsOpen : integer;
		function OpenMap0(Name0, Message0 : string; var Handle0 : THandle;
			var Pointer0 : PChar; Size0 : DWord; var MessageID0 : DWord) : Boolean;
		function GetValues(Name : string) : string;
		procedure SetValues(Name : string; const Value : string);
		procedure CloseMap0(var Handle0 : THandle;var Pointer0 : PChar);
		procedure WriteMap0(Pointer0 : PChar; Strings0 : TStringList; MessageID0, Size0 : DWord);
		procedure WriteAppListMap;
		procedure ReadAppListMap;
		procedure SetMapName(Value : String);
		procedure SetMapStrings(Value : TStringList);
		procedure SetSize(Value : DWord);
		procedure SetAutoSynch(Value : Boolean);
		procedure EnterCriticalSection;
		procedure LeaveCriticalSection;
		procedure MapStringsChange(Sender : TObject);
		procedure AppListStringsChange(Sender : TObject);
		procedure NewWndProc(var FMessage : TMessage);
		procedure Dummy(Value : string);
	protected
		{ Protected declarations }
	public
		{ Public declarations }
		constructor Create(AOwner: TComponent); override;
		destructor Destroy; override;
		procedure Loaded; override;
{OpenMap is the procedure to manually open the map. If AutoOpen is true the map is automatically opened at start-up.}
{Use OpenMap and CloseMap if only a part of your program needs to have the map open.}
		procedure OpenMap;
{CloseMap is the procedure to manually close the map. The map automatically closes when the application closes.}
{Use OpenMap and CloseMap if only a part of your program needs to have the map open.}
		procedure CloseMap;
{ReadMap reads the map manually and calls OnChange event.}
{It is normally not necessary to call ReadMap - it is done automaticcally when another application calls WriteMap.}
		procedure ReadMap;
{WriteMap writes the map manually and sends message to all open PBShareMaps that they must update.}
{If AutoSynchronize is True, it is not necessary to call WriteMap. In that case every change in MapStrings will cause the other applications to update.}
{For small maps - or if you change the whole list at one time, that is the preferred method.}
{If you make a lot of changes 'simultaniously' it is more effective to set AutoSynchronize to False and, when you have finished changing call WriteMap;}
		procedure WriteMap;
{The property can be used to determine that another application (or another instance of the same application) has already a map open - with the same MapName.}
{If you want to limit your program to one instance, simply close the application if ExistsAlready is True (set AutoOpen to True). You can pass a filename to open or what you like before closing the second application.}
{Notice that if the first application closes the map and reopens it, ExistsAlready will become True.}
		property ExistsAlready : Boolean read FExistsAlready;
{When the map is open this property becomes True.}
		property IsMapOpen : Boolean read FIsMapOpen;
{A TStringList that dynamically contains the handles of all the forms that contain an open PBShareMap with the same MapName as the current map.}
{Updates when an application opens or closes a map.}
{Note: It will not update when the map is closed - in this application.}
		property AppList : TStringList read FAppListStrings;
{The number of open PBShareMaps (with the same MapName as the current map).}
{Updates when an application (this one or another) opens or closes a map.}
{Note: It will not update when the map is closed - in this application.}
		property MapsOpen : integer read FMapsOpen;
{The default property.}
{It is actually the same as MapStrings.Values. See TStringList.Values in Delphi help.}
//
{Use it like this:}
{Store a variable called MyVar: PBShareMap1['MyVar'] := Myvar;}
{Get the variable: MyVar := PBShareMap1['MyVar'];}
//
{if MyVar is not a string, you have to convert it to (and from) a string, for instance an integer: PBShareMap1['MyInteger'] := IntToStr(MyInteger);}
		property Values[Name : string] : string read GetValues write SetValues; default;
	published
		{ Published declarations }
{The maximum size in Bytes that can be used to store strings.}
{Default value is 4096 Bytes - min. 32 Bytes.}
{There are no max. value to this property (well... 2 GigaBytes, I guess) but MaxSize is the amount of memory allocated for the map so you shouldn't use a value too big.}
{If the size is too large to hold in physical memory, Windows will swap the map to disk which will slow updating down.}
{When changing the MapStrings only the actual size of MapStrings will be sent - not MaxSize bytes.}
{Using very large strings might be slow - I have measured the speed to about 4 MBytes pr. second when using large strings (MBytes).}
{Note: You can't change the MaxSize when the map is open (in any application). So set the MaxSize before opening it (equal MaxSize in all applications).}
{If you change the size and another application has the map open, opening the map will not change the size.}
		property MaxSize : DWord read FSize write SetSize;
{Determines if the map should open when the application starts running.}
{If you only want to use the map in a particular section of your program, set AutoOpen to False and then call OpenMap when you need it.}
		property AutoOpen : Boolean read FAutoOpen write FAutoOpen;
{Determines if the map should update fully automatically - if True then every small change to MapStrings will result in an automatic update of the other application's maps (WriteMap auto-call).}
{If AutoSynchronize is True, it is not necessary to call 'WriteMap'. In that case every change in MapStrings will cause the other applications to update.}
{For small maps - or if you change the whole list at one time, that is the preferred method.}
{If you make a lot of changes 'simultaniously' it is more effective to set AutoSynchronize to False and, when you have finished changing call WriteMap;}
		property AutoSynchronize : Boolean read FAutoSynch write SetAutoSynch;
{MapName is the name of the map. The name must be unique and common: Common to the applications that ought to share the same map and unique throughout the system.}
{The map share the name-space with other file-mapping objects, mailslots and other kinds of shared memory objects.}
{MapName is the only property you must change before running.}
		property MapName : string read FMapName write SetMapName;
{The MAP - a TStringList that is 'shared' along all the maps (with the same name) that are open on the computer.}
{You can use it to share any kind of list that contains strings.}
{When a map is opened, ReadMap is automatically called, if the map already existed, otherwise WriteMap is called so the value of MapStrings is assigned to the map. If you haven't changed it at runtime, that will be the value you gave it at designtime (via Object Inspector).}
{If you want to share more than one variable you can use the 'Name=Value' approach to the TStringList - like an INI-file.}
{See the default property: Values.}
		property MapStrings : TStringList read FMapStrings write SetMapStrings;
{Triggers when the component has updated the MapStrings. Use it to put variable-values back to the variables - synchronize the variables.}
		property OnChange : TNotifyEvent read FOnChange write FOnChange;
{Triggers when this or another application opens or closes a map - see Applist.}
		property OnAppListChange : TNotifyEvent read FOnAppListChange	write FOnAppListChange;
{The version number - read only.}
		property Version : string read FVersion write Dummy;
	end;

const
	FAppListSize = 2000;

procedure Register;

implementation

constructor TPBShareMap.Create(AOwner: TComponent);
begin
	inherited Create(AOwner);
	FVersion := '2.00.00.00';
	FAutoOpen := True;
	FAutoSynch := True;
	FSize := 4096;
	FReading := False;
	FAppListReading := False;
	FMapStrings := TStringList.Create;
	FMapStrings.OnChange := MapStringsChange;
	FAppListStrings := TStringList.Create;
	with FAppListStrings do
	begin
		Sorted := True;
		Duplicates := dupIgnore;
		OnChange := AppListStringsChange;
	end;
	FMapName := 'Unique & Common name';
	FSynchMessage := FMapName + 'Synch-Now';
	FAppListMessage := FMapName + 'Handles';
	if AOwner is TForm then
	begin
		FFormHandle := (AOwner as TForm).Handle;
		FPOldWndHandler := Ptr(GetWindowLong(FFormHandle, GWL_WNDPROC));
		FPNewWndHandler :=	MakeObjectInstance(NewWndProc);
		if FPNewWndHandler = nil then Raise Exception.Create('Out of resources');
		SetWindowLong(FFormHandle, GWL_WNDPROC, Longint(FPNewWndHandler));
	end
	else Raise Exception.Create('Owner must be TForm');
end;

procedure TPBShareMap.Loaded;
begin
	inherited Loaded;
	if not (csDesigning in ComponentState) then
	begin
		if FMapName = 'Unique & Common name'
			then Application.MessageBox('You must change the ''MapName'' property '
			+'to ensure the name is unique for this map.'+#10
			+'The name has to be the same in all applications that will share the map.'
			+#10+'You can use any characters except backslash ''\'' (max. 245 characters).',
			'PBShareMap name error!', MB_OK+MB_ICONEXCLAMATION+MB_DEFBUTTON1+MB_APPLMODAL);
		if FAutoOpen then OpenMap;
	end;
end;

destructor TPBShareMap.Destroy;
begin
	CloseMap;
	SetWindowLong(FFormHandle, GWL_WNDPROC, Longint(FPOldWndHandler));
	if FPNewWndHandler <> nil then FreeObjectInstance(FPNewWndHandler);
	FAppListStrings.Free;
	FAppListStrings := nil;
	FMapStrings.Free;
	FMapStrings := nil;
	inherited destroy;
end;

function TPBShareMap.OpenMap0(Name0, Message0 : string; var Handle0 : THandle;
		var Pointer0 : PChar; Size0 : DWord; var MessageID0 : DWord) : Boolean;
var
	TempMessage : array[0..255] of Char;
begin
	Handle0 := CreateFileMapping($FFFFFFFF, nil, PAGE_READWRITE,
		0, Size0, PChar(Name0));
	if (Handle0 = INVALID_HANDLE_VALUE) or (Handle0 = 0)
		then Raise Exception.Create('Unable to create file mapping!')
	else
	begin
		if (Handle0 <> 0) and (GetLastError = ERROR_ALREADY_EXISTS)
			then FExistsAlready := True;
		Pointer0 := MapViewOfFile(Handle0, FILE_MAP_ALL_ACCESS, 0, 0, 0);
		if Pointer0 = nil then Raise Exception.Create('Unable to map view of buffer!')
		else
		begin
			StrPCopy(TempMessage, Message0);
			MessageID0 := RegisterWindowMessage(TempMessage);
			if MessageID0 = 0 then Raise Exception.Create('Could not create message!')
			else Result := True;
		end
	end;
end;

procedure TPBShareMap.OpenMap;
begin
	if (FMapHandle = 0) and (FMapPointer = nil) then
	begin
		FExistsAlready := False;
		if OpenMap0(FMapName, FSynchMessage, FMapHandle, FMapPointer, FSize, FMessageID) then
		begin
			FMutexHandle := Windows.CreateMutex(nil, False, PChar(FMapName + '.Mtx'));
			if FMutexHandle = 0 then Raise Exception.Create('Unable to create Mutex!');
			if OpenMap0(FMapName + '-AppList', FApplistMessage, FAppListHandle,
				FAppListPointer, FAppListSize, FApplistMessageID) then
			begin
				FIsMapOpen := True;
				if FExistsAlready then ReadAppListMap;
				FAppListStrings.Add(IntToStr(FFormHandle));
				if FExistsAlready then ReadMap
				else WriteMap;
			end;
		end;
	end;
end;

procedure TPBShareMap.CloseMap0(var Handle0 : THandle;var Pointer0 : PChar);
begin
	if Pointer0 <> nil then
	begin
		UnMapViewOfFile(Pointer0);
		Pointer0 := nil;
	end;
	if Handle0 <> 0 then
	begin
		CloseHandle(Handle0);
		Handle0 := 0;
	end;
end;

procedure TPBShareMap.CloseMap;
begin
	if FIsMapOpen then
	begin
		if FMutexHandle <> 0 then
		begin
			FAppListStrings.Delete(FAppListStrings.IndexOf(IntToStr(FFormHandle)));
			CloseHandle(FMutexHandle);
			FMutexHandle := 0;
		end;
		CloseMap0(FAppListHandle, FAppListPointer);
		CloseMap0(FMapHandle, FMapPointer);
		FIsMapOpen := False;
	end;
end;

procedure TPBShareMap.SetMapName(Value : string);
begin
	if (FMapName <> Value) and (FMapHandle = 0) and (Length(Value) < 246) then
	begin
		FMapName := Value;
		FSynchMessage := FMapName + 'Synch-Now';
		FAppListMessage := FMapName + 'Handles';
	end;
end;

procedure TPBShareMap.SetMapStrings(Value : TStringList);
begin
	if Value.Text <> FMapStrings.Text then
	begin
		if Length(Value.Text) <= FSize then FMapStrings.Assign(Value)
		else Raise Exception.Create('Can''t write Strings. Strings are too large!');
	end;
end;

procedure TPBShareMap.MapStringsChange(Sender : TObject);
begin
	if not (csDestroying in ComponentState) then
	begin
		if FReading and Assigned(FOnChange) then FOnChange(Self)
		else if (not FReading) and FIsMapOpen and FAutoSynch then WriteMap;
	end;
end;

procedure TPBShareMap.AppListStringsChange(Sender : TObject);
begin
	FMapsOpen := FAppListStrings.Count;
	if (not FAppListReading) and FIsMapOpen then WriteAppListMap;
	if (not (csDestroying in ComponentState)) and Assigned(FOnAppListChange)
		then FOnAppListChange(Self);
end;

procedure TPBShareMap.SetSize(Value : DWord);
var
	StringsPointer : PChar;
begin
	if (FSize <> Value) and (FMapHandle = 0) then
	begin
		StringsPointer := FMapStrings.GetText;
		if (Value < StrLen(StringsPointer) + 1) then FSize := StrLen(StringsPointer) + 1
		else FSize := Value;
		if FSize < 32 then FSize := 32;
		StrDispose(StringsPointer);
	end;
end;

procedure TPBShareMap.SetAutoSynch(Value : Boolean);
begin
	if FAutoSynch <> Value then
	begin
		FAutoSynch := Value;
		if FAutoSynch and FIsMapOpen then WriteMap;
	end;
end;

procedure TPBShareMap.ReadMap;
begin
	FReading := True;
	if (FMapPointer <> nil) then FMapStrings.SetText(FMapPointer);
	FReading := False;
end;

procedure TPBShareMap.ReadAppListMap;
begin
	FAppListReading := True;
	if (FApplistPointer <> nil) then FAppListStrings.SetText(FApplistPointer);
	FAppListReading := False;
end;

procedure TPBShareMap.WriteMap0(Pointer0 : PChar; Strings0 : TStringList; MessageID0, Size0 : DWord);
var
	StringsPointer : PChar;
	HandleCounter : integer;
	SendToHandle : HWnd;
begin
	if Pointer0 <> nil then
	begin
		StringsPointer := Strings0.GetText;
		EnterCriticalSection;
		if StrLen(StringsPointer) + 1 <= Size0
			then System.Move(StringsPointer^, Pointer0^, StrLen(StringsPointer) + 1)
		else Raise Exception.Create('Can''t write Strings. Strings are too large!');
		LeaveCriticalSection;
		StrDispose(StringsPointer);
		for HandleCounter := 0 to FAppListStrings.Count - 1 do
		begin
			SendToHandle := StrToInt(FAppListStrings[HandleCounter]);
			if SendToHandle <> FFormHandle then PostMessage(SendToHandle,
				MessageID0,	FFormHandle, 0);
		end;
	end;
end;

procedure TPBShareMap.WriteMap;
begin
	WriteMap0(FMapPointer, FMapStrings, FMessageID, FSize);
end;

procedure TPBShareMap.WriteAppListMap;
begin
	WriteMap0(FAppListPointer, FAppListStrings, FAppListMessageID, FAppListSize);
end;

procedure TPBShareMap.EnterCriticalSection;
begin
	if (FMutexHandle <> 0) and not FLocked then
	begin
		FLocked := (WaitForSingleObject(FMutexHandle, INFINITE) = WAIT_OBJECT_0);
	end;
end;

procedure TPBShareMap.LeaveCriticalSection;
begin
	if (FMutexHandle <> 0) and FLocked then
	begin
		ReleaseMutex(FMutexHandle);
		FLocked := False;
	end;
end;

function TPBShareMap.GetValues(Name : string) : string;
begin
	Result := FMapStrings.Values[Name];
end;

procedure TPBShareMap.SetValues(Name : string; const Value : string);
begin
	if Value <> FMapStrings.Values[Name] then FMapStrings.Values[Name] := Value;
end;

procedure	TPBShareMap.NewWndProc(var FMessage : TMessage);
begin
	with FMessage do
	begin
		if FIsMapOpen then
		begin
			if Msg = FMessageID then ReadMap
			else if Msg = FAppListMessageID then ReadAppListMap;
		end;
		Result := CallWindowProc(FPOldWndHandler,	FFormHandle, Msg, wParam, lParam);
	end;
end;

procedure TPBShareMap.Dummy(Value : string);
begin
		//read only
end;

procedure Register;
begin
	RegisterComponents('PB', [TPBShareMap]);
end;

end.

