//---------------------------------------------------------------------------
#include <vcl.h>
// #pragma hdrstop

//  This example of a Visual DialogScript extension DLL implements a
//  command and function called REVERSE.
//
//  REVERSE ON turns the function on.
//  REVERSE OFF turns the function off.
//
//  When the function is on, @REVERSE() returns the string given as its
//  argument with all the characters reversed. When the function is off
//  it returns the string unchanged.
//
//  To demonstrate an event, a REVERSE event is triggered if REVERSE is
//  given with any parameter other than ON or OFF.

//
//  IMPORTANT: When compiling DLL "Generate underscores" in C++Builder
//  Advanced Compiler Options must be turned off.
//
//  Use Dynamic RTL must be disabled.
//

typedef void __cdecl (*exteventproc)(char * eventtype);

#define MAX_PAR 4;    // maximum number of parameters of a command or function
#define BUF_LEN 256;  // length of transfer buffer

int AHandle;              // window handle passed by VDS
exteventproc eventproc;   // address of event notification procedure
int p;                    // pointer to command line
int errorcode;            // error code

extern "C" __declspec(dllexport) char * __cdecl Init(int Handle, exteventproc Addr,
  char * KeyString, int &maxpar, int &bufsize);
extern "C" __declspec(dllexport) int __cdecl CommandProc(char * Params);
extern "C" __declspec(dllexport) char * __cdecl FuncProc(char * Args);
extern "C" __declspec(dllexport) int __cdecl StatProc(void);

//---------------------------------------------------------------------------
int WINAPI DllEntryPoint(HINSTANCE hinst, unsigned long reason, void*)
{
  if (reason == DLL_PROCESS_ATTACH)   // insert code that is run when DLL is loaded
  {
    MessageBeep(0);
  };
  if (reason == DLL_PROCESS_DETACH)   // insert code that is run when calling program terminates
  {
    MessageBeep(0);
  };
  return 1;
}

char * __cdecl Init(int Handle, exteventproc Addr, char * KeyString, int &maxpar,
  int &bufsize)
{
  AHandle = Handle;
  eventproc = Addr;
  maxpar = MAX_PAR;
  bufsize = BUF_LEN;
  if (StrComp(KeyString,"DEMO") == 0)
    return "REVERSE";
  else
    return "";
}

int __cdecl CommandProc(char * Params)
{
  eventproc("REVERSE");
  return 0;
}

char * __cdecl FuncProc(char * Args)
{
  return Args;
}

int __cdecl StatProc(void)
{
  return errorcode;
}
//---------------------------------------------------------------------------
