:Syntax $IF expression comparison expression THEN <action/DO> <ELSE action/DO>  
:Syntax Examples
:Syntax $IF %a+1 > %b-1/3 THEN %j = 1 
:Syntax $IF %a=0 THEN %j = 1 ELSE I = 0 
:HELP The $IF statement allows to write the if directive in a more
:HELP conventional way. It will be translated in VDS syntax.
:HELP   comparison := >,<,>=,<=,=,NE
:HELP   expression := <value/vds-variable><+,-,*,/><value/vds-variable><<+,-,*,/> expression>>     
:HELP Example $IF %a+1 > %b-1/3 THEN %j = 1  
: %1 if condition 
: %2 then clause 
: %3 else clause
gosub comparison
gosub operand
gosub breakup
exit

REM * ---------------------------------------------------------------------------------------------------------
REM * Seperate comparison operator
REM * ---------------------------------------------------------------------------------------------------------
:comparison
%c = "."
%s = ""
%z = @len(%1)
:$DO FOR %i FROM 1 TO %z
rem +<<MACRO124>>........... Expanded Macro $DO ........ do not change anything here .....
%i = @pred(1)
:do1
%i = @succ(%i)
if @greater(%i,%z)
   goto end1
end
rem +<<MACRO124>>........... End of Macro Expansion .....................................
    %l = @substr(%1,%i,@succ(%i))
    %v = @substr(%1,%i,%i)
    %x = @substr(%1,@succ(%i),@succ(%i))
    :$SELECT %l
rem +<<MACRO236>>........... Expanded Macro $SELECT ........ do not change anything here .....
:do2
rem +<<MACRO236>>........... End of Macro Expansion .....................................
      :$WHEN >= $DO
rem +<<MACRO340>>........... Expanded Macro $WHEN ........ do not change anything here .....
if @equal(%l,">=")
rem +<<MACRO340>>........... End of Macro Expansion .....................................
         %s = %s%c>=%c
         %i = @succ(%i)
         goto next
      :$END
rem +<<MACRO446>>........... Expanded Macro $END ........ do not change anything here .....
end
rem +<<MACRO446>>........... End of Macro Expansion .....................................
       :$WHEN <= $DO
rem +<<MACRO550>>........... Expanded Macro $WHEN ........ do not change anything here .....
if @equal(%l,"<=")
rem +<<MACRO550>>........... End of Macro Expansion .....................................
         %s = %s%c<=%c
         %i = @succ(%i)
         goto next
      :$END
rem +<<MACRO656>>........... Expanded Macro $END ........ do not change anything here .....
end
rem +<<MACRO656>>........... End of Macro Expansion .....................................
      :$WHEN NE $DO
rem +<<MACRO760>>........... Expanded Macro $WHEN ........ do not change anything here .....
if @equal(%l,"NE")
rem +<<MACRO760>>........... End of Macro Expansion .....................................
         %s = %s%cNE%c
         %i = @succ(%i)
         goto next
      :$END
rem +<<MACRO866>>........... Expanded Macro $END ........ do not change anything here .....
end
rem +<<MACRO866>>........... End of Macro Expansion .....................................
      if @equal(%v,">")
        %s = %s%c%v%c
         goto next
      end  
      if @equal(%v,"<")
        %s = %s%c%v%c
        goto next
      end  
       if @equal(%v,"=")
        %s = %s%c%v%c
        goto next
      end  
     %s = %s%v
:next      
    :$END   end of select statment
rem +<<MACRO984>>........... Expanded Macro $END ........ do not change anything here .....
:end2
rem +<<MACRO984>>........... End of Macro Expansion .....................................
:$END   end of do loop
rem +<<MACRO1088>>........... Expanded Macro $END ........ do not change anything here .....
   goto do1
:end1
rem +<<MACRO1088>>........... End of Macro Expansion .....................................
exit
REM * ---------------------------------------------------------------------------------------------------------
REM * Seperate operands and operators by one blank, create new string
REM * ---------------------------------------------------------------------------------------------------------
:operand
%1 = %s
%l = ""
%s = "" 
%b = ";"
:$DO FOR %i FROM 1 TO @len(%1)
rem +<<MACRO11102>>........... Expanded Macro $DO ........ do not change anything here .....
%i = @pred(1)
:do11
%i = @succ(%i)
if @greater(%i,@len(%1))
   goto end11
end
rem +<<MACRO11102>>........... End of Macro Expansion .....................................
    %l = @substr(%1,%i,%i)
    :$SELECT %l
rem +<<MACRO12112>>........... Expanded Macro $SELECT ........ do not change anything here .....
:do12
rem +<<MACRO12112>>........... End of Macro Expansion .....................................
      :$WHEN "+" "%s = %s%b+%b"
rem +<<MACRO13116>>........... Expanded Macro $WHEN ........ do not change anything here .....
if @equal(%l,"+")
   %s = %s%b+%b
   goto end12
end
rem +<<MACRO13116>>........... End of Macro Expansion .....................................
      :$WHEN "-" "%s = %s%b-%b"
rem +<<MACRO14123>>........... Expanded Macro $WHEN ........ do not change anything here .....
if @equal(%l,"-")
   %s = %s%b-%b
   goto end12
end
rem +<<MACRO14123>>........... End of Macro Expansion .....................................
      :$WHEN "*" "%s = %s%b*%b"
rem +<<MACRO15130>>........... Expanded Macro $WHEN ........ do not change anything here .....
if @equal(%l,"*")
   %s = %s%b*%b
   goto end12
end
rem +<<MACRO15130>>........... End of Macro Expansion .....................................
      :$WHEN "/" "%s = %s%b/%b"
rem +<<MACRO16137>>........... Expanded Macro $WHEN ........ do not change anything here .....
if @equal(%l,"/")
   %s = %s%b/%b
   goto end12
end
rem +<<MACRO16137>>........... End of Macro Expansion .....................................
      %s = %s%l
    :$END   end of select statment
rem +<<MACRO17145>>........... Expanded Macro $END ........ do not change anything here .....
:end12
rem +<<MACRO17145>>........... End of Macro Expansion .....................................
:$END   end of do loop
rem +<<MACRO18149>>........... Expanded Macro $END ........ do not change anything here .....
   goto do11
:end11
rem +<<MACRO18149>>........... End of Macro Expansion .....................................
exit
REM * ---------------------------------------------------------------------------------------------------------
REM * Break up: left operand  operator right operand
REM * ---------------------------------------------------------------------------------------------------------
:breakup 
%i = 0
option fieldsep,"."
%s = @trim(%s)
parse "%l;%h;%r",%s
%l = @trim(%l)
%h = @trim(%h)
%r = @trim(%r)
%s = %l 
gosub analyse
%q = %a
%s = %r 
gosub analyse
if @equal(%h,>)
   %q = "@greater("%q","%a")"
end     
if @equal(%h,>=)
   %q = "@not(@greater("%a","%q"))"
end     
if @equal(%h,<=)
   %q = "@not(@greater("%q","%a"))"
end     
if @equal(%h,<)
   %q = "@greater("%a","%q")"
end     
if @equal(%h,=)
   %q = "@equal("%q","%a")"
end     
if @equal(%h,ne)
   %q = "@not(@equal("%q","%a"))"
end     
clipboard append,"if "%q
if @equal(%2,$DO)
   %2 = "DO"
end
if @not(@equal(%2,))
   if @equal(%2,DO)
   else
      clipboard append,"   "%2
      if @not(@equal(%3,))
         clipboard append,"else"
         clipboard append,"   "%3
      end
      clipboard append,"end"
      end
end   
exit 


REM * ---------------------------------------------------------------------------------------------------------
REM * Analyse string, and replace operands funtions, nest functions
REM * ---------------------------------------------------------------------------------------------------------
:analyse
%i = 0

option fieldsep,";"
if @equal(@pos(";",%s),0)
   %a = @trim(%s)
   exit
end   
%s = @trim(%s)
parse "%a;%o;%b",%s
%u = %a";"%o";"%b
%a = @trim(%a)
:nest1
%o = @trim(%o)
%b = @trim(%b)

:$SELECT %o
rem +<<MACRO19226>>........... Expanded Macro $SELECT ........ do not change anything here .....
:do19
rem +<<MACRO19226>>........... End of Macro Expansion .....................................
      :$WHEN "+"   %l = '@fadd("%a","%b")'
rem +<<MACRO20230>>........... Expanded Macro $WHEN ........ do not change anything here .....
if @equal(%o,"+")
   %l = "@fadd("%a","%b")"
   goto end19
end
rem +<<MACRO20230>>........... End of Macro Expansion .....................................
      :$WHEN "-"   %l = '@fsub("%a","%b")'
rem +<<MACRO21237>>........... Expanded Macro $WHEN ........ do not change anything here .....
if @equal(%o,"-")
   %l = "@fsub("%a","%b")"
   goto end19
end
rem +<<MACRO21237>>........... End of Macro Expansion .....................................
      :$WHEN "*"   %l = '@fmul("%a","%b")'
rem +<<MACRO22244>>........... Expanded Macro $WHEN ........ do not change anything here .....
if @equal(%o,"*")
   %l = "@fmul("%a","%b")"
   goto end19
end
rem +<<MACRO22244>>........... End of Macro Expansion .....................................
      :$WHEN "/"   %l = '@fdiv("%a","%b")'
rem +<<MACRO23251>>........... Expanded Macro $WHEN ........ do not change anything here .....
if @equal(%o,"/")
   %l = "@fdiv("%a","%b")"
   goto end19
end
rem +<<MACRO23251>>........... End of Macro Expansion .....................................
:$END   end of select statment
rem +<<MACRO24258>>........... Expanded Macro $END ........ do not change anything here .....
   goto do19
:end19
rem +<<MACRO24258>>........... End of Macro Expansion .....................................
%m = @succ(@len(%u";"))
%s = @trim(@substr(%s,%m,255))
if @not(@equal(%s,))
parse "%o;%b",%s
   %u = %o";"%b
   %a = %l 
   goto nest1
end
%a = %l
exit
