unit Vdsmemo;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Menus;

type
  exteventproc = procedure(eventtype: PChar) of object;
  TVDSMemo = class(TForm)
    MainMenu1: TMainMenu;
    Memo: TMemo;
  Private
    { Private declarations }
    Function AddMenuItem(Params:String;ParentMenu:TMenuItem):boolean;
    Function RemoveMenuItem(Menu: TMenuItem):Boolean;
    Function NextParamaterItem(Params:String;Separator:Char):String;
    Procedure eventraised(Sender: TObject);
    Procedure FormClose(Sender: TObject; var Action: TCloseAction);
  public
    { Public declarations }
    Function AddMenu(Params:String;ParentMenu:TMenuItem):boolean;
    Function RemoveMainMenu(MainMenu:TMenuItem):Boolean;
    Procedure initialise(EventCall:exteventproc);
    Procedure itemvisible(ItemName:String;ItemState:String);
    Procedure itemenabled(ItemName:String;ItemState:String);
    Procedure itemredefine(ItemName:String;Params:String);

  end;
Var
   OnEvent:exteventproc;
   MenuItemList:TStringList;

implementation

{$R *.DFM}

procedure TVDSMemo.Initialise(EventCall:exteventproc);
Begin
     OnEvent := EventCall;
     OnClose := FormClose;
     MenuItemList := TStringList.Create
End;

function TVDSMemo.AddMenu(Params:String;ParentMenu:TMenuItem):boolean;
Var
  NextParam:String;
  ok:Boolean;
Begin
     ok:=RemoveMainMenu(Parentmenu);
     While Params <> '' do
     Begin
          NextParam:=NextParamaterItem(Params,'|');
          Delete(Params, 1, Succ(length(NextParam)));
          AddMenuItem(NextParam,ParentMenu);
     end;
end;

function TVDSMemo.AddMenuItem(Params:String;ParentMenu:TMenuItem):boolean;
Var
   NewMenuItem:TMenuItem;
   Name:String;
   Caption:String;
   KeyString:String;
   ShortCutKey:TShortCut;
   SubMenu:String;
   ok:Boolean;
Begin
     Name:=NextParamaterItem(Params,';');
     Delete(Params,1,succ(length(Name)));
     SubMenu:=NextParamaterItem(Params,';');
     Delete(Params,1,succ(length(SubMenu)));
     Caption:=NextParamaterItem(Params,';');
     Delete(Params,1,succ(length(Caption)));
     KeyString:=NextParamaterItem(Params,';');
     Delete(Params,1,succ(length(KeyString)));

     NewMenuItem:=TmenuItem.Create(Self);

     if MenuItemList.indexof(Name) < 0 then
     begin
       if Name <>'' then NewMenuItem.Name:=Name;
       if Caption <>'' then NewMenuItem.Caption:=Caption
              Else if Name <>'' then NewMenuItem.Caption:=Name;
       if KeyString <> '' then shortcutkey:=shortcut(Word(Keystring[1]),[ssCtrl])
              Else shortcutkey:=0;
       NewMenuItem.Shortcut:=ShortCutKey;
       if SubMenu <> '' then
       Begin
          Delete(SubMenu,1,1);
          Delete(SubMenu,length(Submenu),1);
          ok:=AddMenu(SubMenu,NewMenuItem);
          NewMenuitem.OnClick:=Nil;
       End
       else
          NewMenuitem.OnClick:=EventRaised;
       ParentMenu.Add(NewMenuItem);
       MenuItemList.AddObject(NewMenuItem.Name,TObject(NewMenuItem));
     end
     else
         result := false;
end;

Function TVDSMemo.RemoveMainMenu(MainMenu:TMenuItem) : Boolean;
Var
   ok:Boolean;
Begin;
      While Mainmenu.Count > 0 do
         ok:=RemoveMenuItem(MainMenu.Items[0]);
End;

Function TVDSMemo.RemoveMenuItem(Menu:TMenuItem):Boolean;
Var
   I:Integer;
   ok:Boolean;
Begin
      While Menu.Count > 0 do
         ok:=RemoveMenuItem(Menu.Items[0]);
      MenuItemList.Delete(MenuItemList.IndexOf(Menu.Name));
      Menu.Free;

End;

function TVDSMemo.NextParamaterItem(Params:String;Separator:Char):String;
Var
   ParanthesLevel:Integer;
   NextParam:String;
   Paramlength:Integer;
   CurrentPosition:Integer;
   CurrentChar:Char;
   ErrorFound:Boolean;
   Begin
     NextParam:='';
     Params:=Params+Separator;
     ErrorFound:=False;
     Paramlength:=length(Params);
     CurrentPosition:=1;
     ParanthesLevel:=0;
     Repeat
       CurrentChar:=Params[CurrentPosition];
       Case CurrentChar of
         '<' : ParanthesLevel:=Succ(ParanthesLevel);
         '>' : ParanthesLevel:=Pred(ParanthesLevel);
       End;
       NextParam:=NextParam+CurrentChar;
       CurrentPosition:=Succ(CurrentPosition);
       if (ParanthesLevel < 0) or (CurrentPosition > Paramlength)
          Then ErrorFound := True;
     Until ((CurrentChar=separator) and (ParanthesLevel = 0)) or ErrorFound=True;
   Delete(NextParam,Pred(CurrentPosition),2);
   Result:=NextParam;
   Delete(Params,1,CurrentPosition)
end;

Procedure TVDSMemo.EventRaised(Sender: TObject);
Var
   EventIn:String[63];
   EventOut:Array[0..63] of char;
Begin
     if Sender is TMenuItem then
        EventIn:=TMenuItem(Sender).Name + 'Memo';

     StrPcopy(Addr(EventOut), EventIn);
     OnEvent(Addr(EventOut))
End;

Procedure TVDSMemo.FormClose(Sender: TObject; var Action: TCloseAction);
Begin
     OnEvent('CloseMemo')
End;

Procedure TVDSMemo.itemvisible(ItemName:String;ItemState:String);
Var
   ItemIndex:Integer;
   LogicalState:Boolean;
Begin
     ItemIndex:=MenuItemList.IndexOf(ItemName);
     LogicalState:=ItemState = 'YES';

     if itemindex>=0 then
        TMenuItem(MenuitemList.objects[itemindex]).Enabled := LogicalState;
end;

Procedure TVDSMemo.itemenabled(ItemName:String;ItemState:String);
Var
   ItemIndex:Integer;
   LogicalState:Boolean;
Begin
     ItemIndex:=MenuItemList.IndexOf(ItemName);
     LogicalState:=ItemState = 'YES';

     if itemindex>=0 then
        TMenuItem(MenuitemList.objects[itemindex]).Enabled := LogicalState;
end;

Procedure TVDSMemo.itemredefine(ItemName:String;Params:String);
Var
   ItemIndex:Integer;
   ParentMenu:TMenuItem;
   ItemRedefined:TMenuItem;
   ok:boolean;
Begin
     ItemIndex:=MenuItemList.IndexOf(ItemName);

     if itemindex>0 then
     begin
        ItemRedefined:= TMenuItem(MenuitemList.objects[itemindex]);
        ParentMenu:= ItemRedefined.Parent;
        ok := RemoveMenuItem(ItemRedefined);
        ok := AddMenuItem(Params, ParentMenu);
     end;
end;





end.


