unit VDSBACKDLL;

interface

uses
  WinTypes, WinProcs, SysUtils, Registry;

type
  exteventproc = procedure(eventtype: PChar);
  {$IFNDEF VER80}
  cdecl;
  {$ENDIF}

const
  max_par = 3;        { maximum number of params/args (user-definable) }
  buf_size = 256;     { parameter buffer size (user-definable) }

var
  AHandle: THandle;   { application handle }
  eventproc: exteventproc;
  p, errorcode: Integer;
  parambuf: Array[0..buf_size-1] of Char; { use GetMem/FreeMem for large buffers }
  RegKey: TRegistry;

  { start user-defined variables }
  rstat: Boolean;
  { end user-defined variables }

function Init(Handle: THandle; Addr: exteventproc; KeyString: PChar; var maxpar,bufsize: Integer): PChar; export;
{$IFNDEF VER80}
cdecl;
{$ENDIF}

function CommandProc(Params: PChar): Integer; export;
{$IFNDEF VER80}
cdecl;
{$ENDIF}

function StatProc: Integer; export;
{$IFNDEF VER80}
cdecl;
{$ENDIF}

implementation

{ begin utility functions (not exported) }
function NextParam: PChar; {get next command parameter}
begin
  Result := Addr(parambuf[p]);
  while parambuf[p]<>#0 do
  begin
    inc(p);
  end;
  inc(p);
end;

{ end utility functions }

{ begin exported functions }

function Init(Handle: THandle; addr: exteventproc; KeyString: PChar; var maxpar,bufsize: Integer): PChar;
begin
  AHandle := Handle;
  eventproc := addr;
  maxpar := max_par;
  bufsize := buf_size;
  { start user-defined code }
  Result := 'BACKGROUND';                    {return the command/function name  }
  rstat := true;
  try
  RegKey := TRegistry.Create;
  RegKey.RootKey := HKEY_CURRENT_USER;
  RegKey.OpenKey('Control Panel\Desktop',True);
  except
  end;
  { end user-defined code }
end;

function CommandProc(Params: PChar): Integer;
var
  Buffer1, Buffer2, Buffer3: string;
begin
  errorcode := 0;                         {initialise errorcode}
  for p := 0 to pred(buf_size) do
    parambuf[p] := Params[p];             {copy parameter string into buffer}
  p := 0;                                 {set pointer for NextParam}
  { start user-defined code }
  Buffer1 := NextParam;
  Buffer2 := NextParam;
  Buffer3 := NextParam;

  if UpperCase(Buffer1) = 'BITMAP' then
  begin
    if FileExists(Buffer2) then
    begin
      try
      if UpperCase(Buffer3) = 'CENTER' then
      RegKey.WriteString('WallpaperStyle','0')
      else
      if UpperCase(Buffer3) = 'TILE' then
      RegKey.WriteString('WallpaperStyle','1')
      else
      if UpperCase(Buffer3) = 'STRETCH' then
      RegKey.WriteString('WallpaperStyle','2');

      SystemParametersInfo(SPI_SETDESKWALLPAPER,0,PChar(Buffer2),SPIF_UPDATEINIFILE or SPIF_SENDCHANGE);
      except
      end;
    end;
  end
  else
  if UpperCase(Buffer1) = 'REFRESHPATTERN' then
  begin
    try
    SystemParametersInfo(SPI_SETDESKPATTERN,0,nil,SPIF_UPDATEINIFILE or SPIF_SENDCHANGE);
    except
    end;
  end;
  { end user-defined code }
  Result := errorcode;
end;

function StatProc: Integer;
{ this function requires no modification }
begin
  Result := errorcode;
end;

initialization
finalization
begin
  try
  RegKey.CloseKey;
  RegKey.Free;
  except
  end;
end;


end.
