unit VDSCONVDLL;

interface

uses
  Windows, Classes, SysUtils, Graphics, Jpeg, GifImage,
  Controls, StdCtrls, ExtCtrls;

type
  exteventproc = procedure(eventtype: PChar);
  cdecl;

const
  max_par = 7;        { maximum number of params/args (user-definable) }
  buf_size = 256;     { parameter buffer size (user-definable) }

var
  AHandle: THandle;   { application handle }
  eventproc: exteventproc;
  p, errorcode: Integer;
  GifGraphic: TGifImage;
  JpgGraphic: TJpegImage;
  AllImage: TImage;
  BmpGraphic1, BmpGraphic2: TBitmap;
  OriginalImage: TImage;
  GraphicType: String;
  RectControl: TRect;
  TempRectControl: TRect;
  parambuf: Array[0..buf_size-1] of Char; { use GetMem/FreeMem for large buffers }

  { start user-defined variables }
  rstat: Boolean;
  { end user-defined variables }

function Init(Handle: THandle; Addr: exteventproc; KeyString: String; var maxpar,bufsize: Integer): PChar; export;
cdecl;
function CommandProc(Params: PChar): Integer; export;
cdecl;
function FuncProc(Args: PChar): PChar; export;
cdecl;
function StatProc: Integer; export;
cdecl;

implementation

function NextParam: PChar; {get next command parameter}
begin
  Result := Addr(parambuf[p]);
  while parambuf[p]<>#0 do
  begin
    inc(p);
  end;
  inc(p);
end;



function Init(Handle: THandle; addr: exteventproc; KeyString: String; var maxpar,bufsize: Integer): PChar;
begin
  AHandle := Handle;
  eventproc := addr;
  maxpar := max_par;
  bufsize := buf_size;
  { start user-defined code }
    AllImage := TImage.Create(nil);
    OriginalImage := TImage.Create(nil);
    Result := 'CONVERT';                    {return the command/function name  }
    rstat := true;                    {initialisation}
end;

function CommandProc(Params: PChar): Integer;
var
Buffer1, Buffer2, Buffer3, Buffer4, Buffer5, Buffer6, Buffer7: String;
DeskTopDC: HDc;
DeskTopCanvas: TCanvas;
DeskTopRect: TRect;
Bitmap, bmp: TBitmap;

begin
  errorcode := 0;                         {initialise errorcode}
  for p := 0 to pred(buf_size) do
    parambuf[p] := Params[p];             {copy parameter string into buffer}
  p := 0;                                 {set pointer for NextParam}
  { start user-defined code }
   Buffer1 := UpperCase(NextParam);

   if Buffer1 = 'BMP2JPG' then
   begin
     Buffer2 := Nextparam;
     Buffer3 := Nextparam;
     if FileExists(Buffer2) AND not(Buffer3 = '') then
     begin
       with TJpegImage.Create do
       try
       bmp := TBitmap.Create;
       try
       bmp.LoadFromFile(Buffer2);
       Assign(bmp);
       finally
       bmp.Free;
       end;
       SaveToFile(Buffer3);
       finally
       free;
       end;
     end;
   end
   else
   if Buffer1 = 'BMP2GIF' then
   begin
     Buffer2 := Nextparam;
     Buffer3 := Nextparam;
     if FileExists(Buffer2) AND not(Buffer3 = '') then
     begin
       with TGifImage.Create do
       try
       Bmp := TBitmap.Create;
       try
       Bmp.LoadFromFile(Buffer2);
       Assign(Bmp);
       finally
       Bmp.Free;
       end;
       SaveToFile(Buffer3);
       finally
       free;
       end;
     end;
   end
   else
   if Buffer1 = 'JPG2BMP' then
   begin
     Buffer2 := Nextparam;
     Buffer3 := Nextparam;
     if FileExists(Buffer2) AND not(Buffer3 = '') then
     begin
       with TJpegImage.Create do
       try
       JpgGraphic := TJpegImage.Create;
       Bmp := TBitmap.Create;
       try
       JpgGraphic.LoadFromFile(Buffer2);
       Bmp.Assign(JpgGraphic);
       Bmp.SaveToFile(Buffer3);
       finally
       Bmp.Free;
       JpgGraphic.Free;
       end;
       finally
       free;
       end;
     end;
   end
   else
   if Buffer1 = 'JPG2GIF' then
   begin
     Buffer2 := Nextparam;
     Buffer3 := Nextparam;
     if FileExists(Buffer2) AND not(Buffer3 = '') then
     begin
       with TJpegImage.Create do
       try
       JpgGraphic := TJpegImage.Create;
       Bmp := TBitmap.Create;
       try
       JpgGraphic.LoadFromFile(Buffer2);
       Bmp.Assign(JpgGraphic);
       with TGifImage.Create do
       try
       Assign(Bmp);
       SaveToFile(Buffer3);
       finally
       free;
       end;
       finally
       Bmp.Free;
       JpgGraphic.Free;
       end;
       finally
       free;
       end;
     end;
   end
   else
   if Buffer1 = 'GIF2BMP' then
   begin
     Buffer2 := Nextparam;
     Buffer3 := Nextparam;
     if FileExists(Buffer2) AND not(Buffer3 = '') then
     begin
       with TGifImage.Create do
       try
       GifGraphic := TGifImage.Create;
       Bmp := TBitmap.Create;
       try
       GifGraphic.LoadFromFile(Buffer2);
       Bmp.Assign(GifGraphic);
       Bmp.SaveToFile(Buffer3);
       finally
       Bmp.Free;
       GifGraphic.Free;
       end;
       finally
       free;
       end;
     end;
   end
   else
   if Buffer1 = 'GIF2JPG' then
   begin
     Buffer2 := Nextparam;
     Buffer3 := Nextparam;
     if FileExists(Buffer2) AND not(Buffer3 = '') then
     begin
       with TGifImage.Create do
       try
       GifGraphic := TGifImage.Create;
       Bmp := TBitmap.Create;
       try
       GifGraphic.LoadFromFile(Buffer2);
       Bmp.Assign(GifGraphic);
       with TJpegImage.Create do
       try
       Assign(Bmp);
       SaveToFile(Buffer3);
       finally
       free;
       end;
       finally
       Bmp.Free;
       GifGraphic.Free;
       end;
       finally
       free;
       end;
     end;
   end
  else
  if Buffer1 = 'CAPTURE' then
  begin
    DeskTopDC := GetWindowDC(GetDeskTopWindow);
    DeskTopCanvas := TCanvas.Create;
    DeskTopCanvas.Handle := DeskTopDC;
    DeskTopRect := Rect(0,0,GetSystemMetrics(SM_CXSCREEN),GetSystemMetrics(SM_CYSCREEN));
    Bitmap := TBitmap.Create;
    Bitmap.Width := GetSystemMetrics(SM_CXSCREEN);
    Bitmap.Height := GetSystemMetrics(SM_CYSCREEN);
    Bitmap.PixelFormat := pfDevice;
    Bitmap.Canvas.CopyRect(DeskTopRect,DeskTopCanvas,DeskTopRect);
    Buffer2 := NextParam;
    if not(Buffer2 = '') then
    begin
    Bitmap.SaveToFile(Buffer2);
    end;
    Bitmap.Free;
    DesktopCanvas.Free;
    ReleaseDC(GetDeskTopWindow,DeskTopDC);
  end
  else
  if Buffer1 = 'RESIZE' then
  begin
    Buffer2 := Nextparam;
    Buffer3 := Nextparam;
    Buffer4 := Nextparam;
    Buffer5 := Nextparam;
    if FileExists(Buffer2) AND not(Buffer3 = '') then
    begin
      try
        try
        OriginalImage.Picture.Bitmap.LoadFromFile(Buffer2);
        GraphicType := 'BMP';
        except
        try
        JpgGraphic := TJpegImage.Create;
        OriginalImage.Picture.Graphic := JpgGraphic;
        GraphicType := 'JPG';
        JpgGraphic.Free;
        OriginalImage.Picture.Graphic.LoadFromFile(Buffer2);
        except
        try
        GifGraphic := TGifImage.Create;
        OriginalImage.Picture.Graphic := GifGraphic;
        GraphicType := 'GIF';
        GifGraphic.Free;
        OriginalImage.Picture.Graphic.LoadFromFile(Buffer2);
        except
        end;
        end;
        end;
        OriginalImage.AutoSize := True;
        RectControl.Top := 0;
        RectControl.Left := 0;
        if StrToInt(Buffer4) >= 0 then
        begin
          try
          RectControl.Right := StrToInt(Buffer4);
          except
          end;
        end
        else
        RectControl.Right := OriginalImage.Width;
        if StrToInt(Buffer5) >= 0 then
        begin
          try
          RectControl.Bottom := StrToInt(Buffer5);
          except
          end;
        end
        else
        RectControl.Bottom := OriginalImage.Height;

        try
        BmpGraphic1 := TBitmap.Create;
        BmpGraphic1.Height := OriginalImage.Height;
        BmpGraphic1.Width := OriginalImage.Width;
        BmpGraphic1.PixelFormat := pf24bit;
        BmpGraphic1.Canvas.Draw(0,0, OriginalImage.Picture.Graphic);

        BmpGraphic2 := TBitmap.Create;
        BmpGraphic2.Width := RectControl.Right;
        BmpGraphic2.Height := RectControl.Bottom;
        BmpGraphic2.Canvas.CopyMode := cmSrcCopy;
        BmpGraphic2.Canvas.Draw(0,0,BmpGraphic1);

        BmpGraphic1.Free;
        except
        end;

        if GraphicType = 'BMP' then
        begin
          try
          BmpGraphic1 := TBitmap.Create;
          BmpGraphic1.Assign(BmpGraphic2);
          BmpGraphic1.SaveToFile(Buffer3);
          BmpGraphic1.Free;
          except
          end;
        end
        else
        if GraphicType = 'JPG' then
        begin
          try
          JpgGraphic := TJpegImage.Create;
          JpgGraphic.Assign(BmpGraphic2);
          JpgGraphic.SaveToFile(Buffer3);
          JpgGraphic.Free;
          except
          end;
        end
        else
        if GraphicType = 'GIF' then
        begin
          try
          GifGraphic := TGifImage.Create;
          GifGraphic.Assign(BmpGraphic2);
          GifGraphic.SaveToFile(Buffer3);
          GifGraphic.Free;
          except
          end;
        end;

        try
        BmpGraphic2.Free;
        OriginalImage.Picture := nil;
        except
        end;
        except
        end;
      end;
    end
  else
  if Buffer1 = 'SCALE' then
  begin
    Buffer2 := Nextparam;
    Buffer3 := Nextparam;
    Buffer4 := Nextparam;
    Buffer5 := Nextparam;
    if FileExists(Buffer2) AND not(Buffer3 = '') then
    begin
      try
        try
        OriginalImage.Picture.Bitmap.LoadFromFile(Buffer2);
        GraphicType := 'BMP';
        except
        try
        JpgGraphic := TJpegImage.Create;
        OriginalImage.Picture.Graphic := JpgGraphic;
        GraphicType := 'JPG';
        JpgGraphic.Free;
        OriginalImage.Picture.Graphic.LoadFromFile(Buffer2);
        except
        try
        GifGraphic := TGifImage.Create;
        OriginalImage.Picture.Graphic := GifGraphic;
        GraphicType := 'GIF';
        GifGraphic.Free;
        OriginalImage.Picture.Graphic.LoadFromFile(Buffer2);
        except
        end;
        end;
        end;
        OriginalImage.AutoSize := True;
        RectControl.Top := 0;
        RectControl.Left := 0;
        if StrToInt(Buffer4) >= 0 then
        begin
          try
          RectControl.Right := StrToInt(Buffer4);
          except
          end;
        end
        else
        RectControl.Right := OriginalImage.Width;
        if StrToInt(Buffer5) >= 0 then
        begin
          try
          RectControl.Bottom := StrToInt(Buffer5);
          except
          end;
        end
        else
        RectControl.Bottom := OriginalImage.Height;

        try
        BmpGraphic1 := TBitmap.Create;
        BmpGraphic1.Height := OriginalImage.Height;
        BmpGraphic1.Width := OriginalImage.Width;
        BmpGraphic1.PixelFormat := pf24bit;
        BmpGraphic1.Canvas.Draw(0,0, OriginalImage.Picture.Graphic);

        BmpGraphic2 := TBitmap.Create;
        BmpGraphic2.Width := RectControl.Right;
        BmpGraphic2.Height := RectControl.Bottom;
        BmpGraphic2.Canvas.CopyMode := cmSrcCopy;
        BmpGraphic2.Canvas.StretchDraw(RectControl,BmpGraphic1);

        BmpGraphic1.Free;
        except
        end;

        if GraphicType = 'BMP' then
        begin
          try
          BmpGraphic1 := TBitmap.Create;
          BmpGraphic1.Assign(BmpGraphic2);
          BmpGraphic1.SaveToFile(Buffer3);
          BmpGraphic1.Free;
          except
          end;
        end
        else
        if GraphicType = 'JPG' then
        begin
          try
          JpgGraphic := TJpegImage.Create;
          JpgGraphic.Assign(BmpGraphic2);
          JpgGraphic.SaveToFile(Buffer3);
          JpgGraphic.Free;
          except
          end;
        end
        else
        if GraphicType = 'GIF' then
        begin
          try
          GifGraphic := TGifImage.Create;
          GifGraphic.Assign(BmpGraphic2);
          GifGraphic.SaveToFile(Buffer3);
          GifGraphic.Free;
          except
          end;
        end;

        try
        BmpGraphic2.Free;
        OriginalImage.Picture := nil;
        except
        end;
        except
        end;
      end;
    end
  else

  if Buffer1 = 'CROP' then
  begin
    Buffer2 := Nextparam;
    Buffer3 := Nextparam;
    Buffer4 := Nextparam;
    Buffer5 := Nextparam;
    Buffer6 := Nextparam;
    Buffer7 := Nextparam;
    if FileExists(Buffer2) AND not(Buffer3 = '') then
    begin
      try
        try
        OriginalImage.Picture.Bitmap.LoadFromFile(Buffer2);
        GraphicType := 'BMP';
        except
        try
        JpgGraphic := TJpegImage.Create;
        OriginalImage.Picture.Graphic := JpgGraphic;
        GraphicType := 'JPG';
        JpgGraphic.Free;
        OriginalImage.Picture.Graphic.LoadFromFile(Buffer2);
        except
        try
        GifGraphic := TGifImage.Create;
        OriginalImage.Picture.Graphic := GifGraphic;
        GraphicType := 'GIF';
        GifGraphic.Free;
        OriginalImage.Picture.Graphic.LoadFromFile(Buffer2);
        except
        end;
        end;
        end;
        OriginalImage.AutoSize := True;
        if StrToInt(Buffer4) >= 0 then
        begin
          try
          RectControl.Top := StrToInt(Buffer4);
          except
          end
        end
        else
        RectControl.Top := 0;
        if StrToInt(Buffer5) >= 0 then
        begin
          try
          RectControl.Left := StrToInt(Buffer5);
          except
          end;
        end
        else
        RectControl.Left := 0;
        if StrToInt(Buffer6) >= 0 then
        begin
          try
          RectControl.Right := StrToInt(Buffer6);
          except
          end;
        end
        else
        RectControl.Right := OriginalImage.Width;
        if StrToInt(Buffer7) >= 0 then
        begin
          try
          RectControl.Bottom := StrToInt(Buffer7);
          except
          end;
        end
        else
        RectControl.Bottom := OriginalImage.Height;

        try
        BmpGraphic1 := TBitmap.Create;
        BmpGraphic1.Height := OriginalImage.Height;
        BmpGraphic1.Width := OriginalImage.Width;
        BmpGraphic1.PixelFormat := pf24bit;
        BmpGraphic1.Canvas.Draw(0,0, OriginalImage.Picture.Graphic);

        BmpGraphic2 := TBitmap.Create;
        BmpGraphic2.Width := RectControl.Right;
        BmpGraphic2.Height := RectControl.Bottom;
        BmpGraphic2.Canvas.CopyMode := cmSrcCopy;
        TempRectControl.Top := 0;
        TempRectControl.Left := 0;
        TempRectControl.Right := RectControl.Right;
        TempRectControl.Bottom := RectControl.Bottom;
        BmpGraphic2.Canvas.CopyRect(TempRectControl, BmpGraphic1.Canvas, RectControl);

        BmpGraphic1.Free;
        except
        end;

        if GraphicType = 'BMP' then
        begin
          try
          BmpGraphic1 := TBitmap.Create;
          BmpGraphic1.Assign(BmpGraphic2);
          BmpGraphic1.SaveToFile(Buffer3);
          BmpGraphic1.Free;
          except
          end;
        end
        else
        if GraphicType = 'JPG' then
        begin
          try
          JpgGraphic := TJpegImage.Create;
          JpgGraphic.Assign(BmpGraphic2);
          JpgGraphic.SaveToFile(Buffer3);
          JpgGraphic.Free;
          except
          end;
        end
        else
        if GraphicType = 'GIF' then
        begin
          try
          GifGraphic := TGifImage.Create;
          GifGraphic.Assign(BmpGraphic2);
          GifGraphic.SaveToFile(Buffer3);
          GifGraphic.Free;
          except
          end;
        end;

        try
        BmpGraphic2.Free;
        OriginalImage.Picture := nil;
        except
        end;
        except
        end;
      end;
    end
  else

      Errorcode := 1;
  { end user-defined code }
  Result := errorcode;
end;

function FuncProc(Args: PChar): PChar;
var

  Buffer1, Buffer2, resultbuf: string;
  resbuf: Array[0..255] of Char;

begin
  { don't zeroise errorcode in case it is set by previous function }
  for p := 0 to pred(buf_size) do
    parambuf[p] := Args[p];             {copy parameter string into buffer}
  p := 0;                                 {set pointer for NextParam}
  { start user-defined code }
   Buffer1 := UpperCase(NextParam);
   Buffer2 := NextParam;
   if (Buffer1 = 'IMGWIDTH') AND (FileExists(Buffer2)) then
   begin
     try
     AllImage.Picture.LoadFromFile(Buffer2);
     AllImage.AutoSize := True;
     resultbuf := IntToStr(AllImage.Width);
     AllImage.Picture := nil;
     except
     end;
   end
   else
   if (Buffer1 = 'IMGHEIGHT') AND (FileExists(Buffer2)) then
   begin
     try
     AllImage.Picture.LoadFromFile(Buffer2);
     AllImage.AutoSize := True;
     resultbuf := IntToStr(AllImage.Height);
     AllImage.Picture := nil;
     except
     end;
   end
   else
   errorcode := 7;
  { end user-defined code }
  StrCopy(resbuf,PChar(resultbuf));
  Result := resbuf;
end;

function StatProc: Integer;
{ this function requires no modification }
begin
  Result := errorcode;
end;

initialization
finalization
  try
  except on Exception do
  end;

end.
 