unit VDSDDEDLL;

interface
uses
  WinTypes, SysUtils, Classes, Forms, DdeMan;

type
  exteventproc = procedure(eventtype: PChar);
  cdecl;
  type TDdeEventConv = class(TDdeServerConv)
  private
  procedure OnOpen(Sender: TObject);
  procedure OnExecuteMacro(Sender: TObject; Msg: TStrings);
  procedure OnClose(Sender: TObject);
  end;
  type TDdeEventServ = class(TDdeServerItem)
  private
  procedure OnPokeData(Sender: TObject);
  end;
    TForm2 = class(TForm)
    TopicName: TDdeServerConv;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

const
  max_par = 25;        { maximum number of params/args (user-definable) }
  buf_size = 256;     { parameter buffer size (user-definable) }

var
  Form2: TForm2;
  AHandle: THandle;   { application handle }
  eventproc: exteventproc;
  p, errorcode: Integer;
  DdeEventConv: TDdeEventConv;
  DdeEventServ: TDdeEventServ;
  MacroVariable: String;
  AllowPokeVar: Boolean;
  TopicName: TDdeServerConv;
  ItemName: Array[0..9999] of TDdeServerItem;
  parambuf: Array[0..buf_size-1] of Char; { use GetMem/FreeMem for large buffers }
  { start user-defined variables }
  rstat: Boolean;
  { end user-defined variables }

function Init(Handle: THandle; Addr: exteventproc; KeyString: PChar; var maxpar,bufsize: Integer): PChar; export;
cdecl;
function CommandProc(Params: PChar): Integer; export;
cdecl;
function FuncProc(Args: PChar): PChar; export;
cdecl;
function StatProc: Integer; export;
cdecl;

implementation

{$R *.DFM}

function NextParam: PChar; {get next command parameter}
begin
  Result := Addr(parambuf[p]);
  while parambuf[p]<>#0 do
  begin
    inc(p);
  end;
  inc(p);
end;


{ begin exported functions }

function Init(Handle: THandle; addr: exteventproc; KeyString: PChar; var maxpar,bufsize: Integer): PChar;
 begin
 AHandle := Handle;
 eventproc := addr;
 maxpar := max_par;
 bufsize := buf_size;
 Form2 := TForm2.Create(nil);
 TopicName := TDdeServerConv.Create(Form2);
 Result := 'DDESERVER';
 TopicName.OnOpen := DdeEventConv.OnOpen;
 TopicName.OnExecuteMacro := DdeEventConv.OnExecuteMacro;
 TopicName.OnClose := DdeEventConv.OnClose;
 {return the command/function name }
 end;

function CommandProc(Params: PChar): Integer;
var
  Buffer1: String;
  Buffer2: String;
  Buffer3: String;

begin
  errorcode := 0;                         {initialise errorcode}
  for p := 0 to pred(buf_size) do
    parambuf[p] := Params[p];             {copy parameter string into buffer}
  p := 0;                                 {set pointer for NextParam}
  { start user-defined code }
  Buffer1 := UpperCase(NextParam);

  if (Buffer1 = 'ESTABLISH') then
    begin
    try
    Buffer2 := NextParam;
    if not(Buffer2 = '') then
    begin
    TopicName.Name := Buffer2;
    AllowPokeVar := True;
    end
    except
    end;
    end
  else
  if (Buffer1 = 'ALLOWPOKE') then
    begin
    Buffer2 := UpperCase(NextParam);
    if not(Buffer2 = '') then
    begin
      if (Buffer2 = 'NO') then
      begin
      AllowPokeVar := False;
      end
      else
      begin
      AllowPokeVar := True;
      end;
    end;
    end
  else
  if (Buffer1 = 'ITEM') then
  begin
     Buffer2 := Copy(NextParam, 5, 4);
     Buffer3 := NextParam;
     if (not(Buffer2 = '')) AND (StrToInt(Buffer2) > 0) AND (not(Buffer3 = '')) then
     begin
     try
     ItemName[StrToInt(Buffer2)] := TDdeServerItem.Create(Form2);
     ItemName[StrToInt(Buffer2)].Name := Buffer3;
     ItemName[StrToInt(Buffer2)].ServerConv := TopicName;
     ItemName[StrToInt(Buffer2)].OnPokeData := DdeEventServ.OnPokeData;
     if not(AllowPokeVar = True) then
     begin
     ItemName[StrToInt(Buffer2)].OnPokeData := nil;
     end
     except
     end;
     end
     else
     begin
     end;
  end
  else
  if (Buffer1 = 'POKE') then
  begin
     Buffer2 := Copy(NextParam, 5, 4);
     Buffer3 := NextParam;
     if (not(Buffer2 = '')) AND (StrToInt(Buffer2) > 0) AND (not(Buffer3 = '')) then
     begin
     try
     ItemName[StrToInt(Buffer2)].Lines.Text := Buffer3;
     except
     end;
     end
     else
     begin
     end;
  end;
  { end user-defined code }
  Result := errorcode;
end;

function FuncProc(Args: PChar): PChar;
var
  buffer1: string;
  buffer2: string;
  resultbuf: string;
  resbuf: Array[0..255] of Char;
begin
  { don't zeroise errorcode in case it is set by previous function }
  for p := 0 to pred(buf_size) do
    parambuf[p] := Args[p];             {copy parameter string into buffer}
  p := 0;                                 {set pointer for NextParam}
  { start user-defined code }

  Buffer1 := UpperCase(NextParam);

  if (Buffer1 = 'GETMACRO') then
  begin
  resultbuf := MacroVariable;
  end
  else
  Buffer2 := Copy(NextParam, 5, 4) ;
  if (Buffer1 = 'GETITEM') and (StrToInt(Buffer2) > 0) then
  begin
  resultbuf := ItemName[StrToInt(Buffer2)].Lines.Text;
  end;


  { end user-defined code }
  StrCopy(resbuf,PChar(resultbuf));
  Result := resbuf;
end;

function StatProc: Integer;
{ this function requires no modification }
begin
  Result := errorcode;
end;

procedure TDdeEventConv.OnOpen(Sender: TObject);
begin
exteventproc(eventproc) ('DDELINKED');
end;

procedure TDdeEventConv.OnExecuteMacro(Sender: TObject;
  Msg: TStrings);
begin
MacroVariable := Pchar(Msg.Text);
exteventproc(eventproc) ('DDEMACRO');
end;

procedure TDdeEventConv.OnClose(Sender: TObject);
begin
exteventproc(eventproc) ('DDETERMINATED');
end;

procedure TDdeEventServ.OnPokeData(Sender: TObject);
begin
exteventproc(eventproc) ('DDEPOKED');
end;

initialization
finalization
  try
  Form2.FreeNotification(TopicName);
  TopicName.Free;
  Form2.Free;
  except
  end;

end.


