unit VDSFLASHDLL;

interface

uses
  WinTypes, WinProcs, SysUtils;

type
  exteventproc = procedure(eventtype: PChar);
  {$IFNDEF VER80}
  cdecl;
  {$ENDIF}

const
  max_par = 1;        { maximum number of params/args (user-definable) }
  buf_size = 256;     { parameter buffer size (user-definable) }

var
  AHandle: THandle;   { application handle }
  eventproc: exteventproc;
  p, errorcode: Integer;
  parambuf: Array[0..buf_size-1] of Char; { use GetMem/FreeMem for large buffers }

  { start user-defined variables }
  rstat: Boolean;
  { end user-defined variables }

function Init(Handle: THandle; Addr: exteventproc; KeyString: PChar; var maxpar,bufsize: Integer): PChar; export;
{$IFNDEF VER80}
cdecl;
{$ENDIF}

function CommandProc(Params: PChar): Integer; export;
{$IFNDEF VER80}
cdecl;
{$ENDIF}

function StatProc: Integer; export;
{$IFNDEF VER80}
cdecl;
{$ENDIF}

function WindowFinder(Input: string): THandle;

implementation

{ begin utility functions (not exported) }
function NextParam: PChar; {get next command parameter}
begin
  Result := Addr(parambuf[p]);
  while parambuf[p]<>#0 do
  begin
    inc(p);
  end;
  inc(p);
end;

{ end utility functions }

{ begin exported functions }

function Init(Handle: THandle; addr: exteventproc; KeyString: PChar; var maxpar,bufsize: Integer): PChar;
begin
  AHandle := Handle;
  eventproc := addr;
  maxpar := max_par;
  bufsize := buf_size;
  { start user-defined code }
  Result := 'FLASHWINDOW';                    {return the command/function name  }
  rstat := true;
  { end user-defined code }
end;

function CommandProc(Params: PChar): Integer;
var
  Buffer1: string;
begin
  errorcode := 0;                         {initialise errorcode}
  for p := 0 to pred(buf_size) do
    parambuf[p] := Params[p];             {copy parameter string into buffer}
  p := 0;                                 {set pointer for NextParam}
  { start user-defined code }
  Buffer1 := NextParam;

  if not(Buffer1 = '') then
  begin
    try
    FlashWindow(WindowFinder(Buffer1),True);
    except
    end;
  end;
  { end user-defined code }
  Result := errorcode;
end;

function StatProc: Integer;
{ this function requires no modification }
begin
  Result := errorcode;
end;

function WindowFinder(Input: string): THandle;
begin
  if Copy(Input,1,1) = '#' then
  Result := FindWindow(PChar(Copy(Input,2,Length(Input))),nil)
  else
  if Copy(Input,1,1) = '%' then
  Result := StrToInt(Trim(Copy(Input,2,Length(Input))))
  else
  Result := FindWindow(nil,PChar(Input));
end;

end.
