unit VDSICODLL;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExeIcon;

type
  exteventproc = procedure(eventtype: PChar);

  TForm1 = class(TForm)
    ExeIconComp: TExeIcon;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

const
  max_par = 25;        { maximum number of params/args (user-definable) }
  buf_size = 256;     { parameter buffer size (user-definable) }
  
var
  Form1: TForm1;
  AHandle: THandle;   { application handle }
  eventproc: exteventproc;
  p, errorcode: Integer;
  ExeIconComp: TExeIcon;
  parambuf: Array[0..buf_size-1] of Char; { use GetMem/FreeMem for large buffers }

  { start user-defined variables }
  rstat: Boolean;
  { end user-defined variables }

function Init(Handle: THandle; Addr: exteventproc; KeyString: PChar; var maxpar,bufsize: Integer): PChar; export;
cdecl;
function CommandProc(Params: PChar): Integer; export;
cdecl;
function FuncProc(Args: PChar): PChar; export;
cdecl;
function StatProc: Integer; export;
cdecl;

implementation

{$R *.DFM}

function NextParam: PChar; {get next command parameter}
begin
  Result := Addr(parambuf[p]);
  while parambuf[p]<>#0 do
  begin
    inc(p);
  end;
  inc(p);
end;



function Init(Handle: THandle; addr: exteventproc; KeyString: PChar; var maxpar,bufsize: Integer): PChar;
begin
  AHandle := Handle;
  eventproc := addr;
  maxpar := max_par;
  bufsize := buf_size;
  { start user-defined code }
    Form1 := TForm1.Create(nil);
   ExeIconComp := TEXEIcon.Create(Form1);
    Result := 'ICON';                    {return the command/function name  }
    rstat := true;                          {initialisation}
end;

function CommandProc(Params: PChar): Integer;
var
  buffer1 : string;
  buffer2 : string;
  buffer3 : string;
  buffer4 : string;
begin
  errorcode := 0;                         {initialise errorcode}
  for p := 0 to pred(buf_size) do
    parambuf[p] := Params[p];             {copy parameter string into buffer}
  p := 0;                                 {set pointer for NextParam}
  { start user-defined code }

   buffer1 := uppercase(nextparam);

if buffer1 = 'CHANGE' then
   begin
   buffer2 := nextparam;
   ExeIconComp.Icon.LoadFromFile(buffer2);
     if not ExeIconComp.IsSupported then
     begin
     Errorcode := 32;
     end;
   Buffer3 := nextparam;
     if (buffer3 = '') or (not(FileExists(buffer3))) then
     Errorcode := 20;
   buffer4 := nextparam;
     if buffer4 = '' then
     Errorcode := 20
     else
     ExeIconComp.SetEXEIcon(buffer3, buffer4);
     end
else
      Errorcode := 1;
  { end user-defined code }
  Result := errorcode;
end;

function FuncProc(Args: PChar): PChar;
var

  buffer1: string;
  buffer2: string;
  resultbuf: string;
  resbuf: Array[0..255] of Char;

begin
  { don't zeroise errorcode in case it is set by previous function }
  for p := 0 to pred(buf_size) do
    parambuf[p] := Args[p];             {copy parameter string into buffer}
  p := 0;                                 {set pointer for NextParam}
  { start user-defined code }
   buffer1 := uppercase(nextparam);
if buffer1 = 'SUPPORTED' then
     begin
     buffer2 := uppercase(nextparam);
     if (buffer2 = '') or (not(FileExists(buffer2))) then
     errorcode := 20
     else
     begin
     ExeIconComp.Icon.LoadFromFile(buffer2);
     if not ExeIconComp.IsSupported then
     begin
     resultbuf := '0';
     end
     else
     begin
     resultbuf := '1'
     end;
     end;
     end
else
    errorcode := 7;

  { end user-defined code }
  StrCopy(resbuf,PChar(resultbuf));
  Result := resbuf;
end;

function StatProc: Integer;
{ this function requires no modification }
begin
  Result := errorcode;
end;

initialization
finalization
  try
  ExeIconComp.Free;
  Form1.Free;
  except on Exception do
  end;

end.
