unit Test;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExeIcon;

type
  TfrmTest = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Edit1: TEdit;
    Label3: TLabel;
    Edit2: TEdit;
    Label4: TLabel;
    Edit3: TEdit;
    Start: TButton;
    ExeIconComp: TExeIcon;
    Button1: TButton;
    procedure FormCreate(Sender: TObject);
    procedure StartClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmTest: TfrmTest;

implementation

{$R *.DFM}


procedure TfrmTest.FormCreate(Sender: TObject);
begin
     Edit1.Text := Application.EXEName;
     Edit2.Text := ExtractFilePath(Application.EXEName) + 'Test.exe';
     Edit3.Text := ExtractFilePath(Application.EXEName) + 'Test.ico';
end;

procedure TfrmTest.StartClick(Sender: TObject);
begin
     if not FileExists(Edit3.Text) then
     begin
          ShowMessage ('Icon not found!');
          Exit;
     end;

     ExeIconComp.Icon.LoadFromFile(Edit3.Text);

     if not ExeIconComp.IsSupported then
     begin
          ShowMessage ('Icon not supported!' + #10#13 +
                       'Supported Icon: 32X32 16 colors, without other resolution.');
          Exit;
     end;

     if ExeIconComp.SetEXEIcon(Edit1.Text, Edit2.Text) = 0 then
         ShowMessage ('Sucessfull modification!')
     else
         ShowMessage('ERROR!!!');
end;

procedure TfrmTest.Button1Click(Sender: TObject);
begin
     Application.Terminate;
end;

end.
