unit VDSIPPDLL;

interface

uses
  WinTypes, WinProcs, SysUtils, Classes, ExtCtrls, IdComponent,
  IdTCPConnection, IdTCPClient, IdTCPServer, IdBaseComponent,
  IdSSLOpenSSL, IdIntercept, IdSSLIntercept, IdAntiFreezeBase,
  IdAntiFreeze, IdLogDebug, IdMessage, IdMessageClient,
  IdThreadMgr, IdThreadMgrDefault, IdPOP3, IDSmtp, IDNntp,
  IdHTTP, IdFTP, IdStack, IdSocks, IdSocketHandle, IdIcmpClient,
  IdTime, IdTimeServer, IdWhois, IdWhoisServer, IdEcho,
  IdEchoServer, IdUdpClient, IdUdpServer, Forms, Dialogs;

type
  exteventproc = procedure(eventtype: PChar);
  {$IFNDEF VER80}
  cdecl;
  {$ENDIF}

type TVDSHttpClient = class(TIDHttp)
    procedure HttpWorkBegin(Sender: TObject; AWorkMode: TWorkMode; const AWorkCountMax: Integer);
    procedure HttpWork(Sender: TObject; AWorkMode: TWorkMode; const AWorkCount: Integer);
end;

type TVDSHttpGetThread = class(TThread)
    procedure Execute; override;
end;

type TVDSHttpGetHeaderThread = class(TThread)
    procedure Execute; override;
end;

type TVDSHttpPostThread = class(TThread)
    procedure Execute; override;
end;

type TVDSHttpDownloadThread = class(TThread)
    procedure Execute; override;
end;

type TVDSFtpClient = class(TIDFtp)
    procedure FtpDisconnected(Sender: TObject);
    procedure FtpWorkBegin(Sender: TObject; AWorkMode: TWorkMode; const AWorkCountMax: Integer);
    procedure FtpWork(Sender: TObject; AWorkMode: TWorkMode; const AWorkCount: Integer);
end;

type TVDSFTPLog = class(TIDLogDebug)
    procedure FtpLogDebugLogItem(ASender: TComponent; var AText: String);
end;

type TVDSFtpConnectThread = class(TThread)
    procedure Execute; override;
end;

type TVDSFtpDisconnectThread = class(TThread)
    procedure Execute; override;
end;

type TVDSFtpRefreshThread = class(TThread)
    procedure Execute; override;
end;

type TVDSFtpGetFileThread = class(TThread)
    procedure Execute; override;
end;

type TVDSFtpPutFileThread = class(TThread)
    procedure Execute; override;
end;

type TVDSPop3Client = class(TIDPop3)
    procedure Pop3Disconnected(Sender: TObject);
    procedure Pop3WorkBegin(Sender: TObject; AWorkMode: TWorkMode; const AWorkCountMax: Integer);
    procedure Pop3Work(Sender: TObject; AWorkMode: TWorkMode; const AWorkCount: Integer);
end;

type TVDSPop3ConnectThread = class(TThread)
    procedure Execute; override;
end;

type TVDSPop3DisconnectThread = class(TThread)
    procedure Execute; override;
end;

type TVDSPop3GetHeaderThread = class(TThread)
    procedure Execute; override;
end;

type TVDSPop3GetMailThread = class(TThread)
    procedure Execute; override;
end;

type TVDSSmtpClient = class(TIDSmtp)
    procedure SmtpDisconnected(Sender: TObject);
    procedure SmtpWorkBegin(Sender: TObject; AWorkMode: TWorkMode; const AWorkCountMax: Integer);
    procedure SmtpWork(Sender: TObject; AWorkMode: TWorkMode; const AWorkCount: Integer);
end;

type TVDSSmtpConnectThread = class(TThread)
    procedure Execute; override;
end;

type TVDSSmtpDisconnectThread = class(TThread)
    procedure Execute; override;
end;

type TVDSSmtpSendThread = class(TThread)
    procedure Execute; override;
end;

type TVDSTCPServer = class(TIDTcpServer)
    procedure TcpServerConnect(AThread: TIdPeerThread);
    procedure TcpServerDisconnect(AThread: TIdPeerThread);
    procedure TcpServerExecute(AThread: TIdPeerThread);
end;

type TVDSTCPClient = class(TIDTcpClient)
    procedure TcpClientDisconnect(Sender: TObject);
    procedure TcpWorkBegin(Sender: TObject; AWorkMode: TWorkMode; const AWorkCountMax: Integer);
    procedure TcpWork(Sender: TObject; AWorkMode: TWorkMode; const AWorkCount: Integer);
end;

type TVDSTcpClientTimer = class(TTimer)
    procedure TimerEvent(Sender: TObject);
end;

type TSimpleClient = class(TObject)
  Index: Integer;
  IP: String;
  Thread: Pointer;
end;

type TVDSTcpConnectThread = class(TThread)
    procedure Execute; override;
end;

type TVDSTcpDisconnectThread = class(TThread)
    procedure Execute; override;
end;

type TVDSTcpSendThread = class(TThread)
    procedure Execute; override;
end;


type TVDSIcmpClient = class(TIDIcmpClient)
    procedure ReplyMessage(ASender: TComponent; const ReplyStatus: TReplyStatus);
    procedure IcmpWorkBegin(Sender: TObject; AWorkMode: TWorkMode; const AWorkCountMax: Integer);
    procedure IcmpWork(Sender: TObject; AWorkMode: TWorkMode; const AWorkCount: Integer);
end;

type TVDSIcmpPingThread = class(TThread)
    procedure Execute; override;
end;

type TVDSNtpClient = class(TIDtime)
    procedure NtpWorkBegin(Sender: TObject; AWorkMode: TWorkMode; const AWorkCountMax: Integer);
    procedure NtpWork(Sender: TObject; AWorkMode: TWorkMode; const AWorkCount: Integer);
end;

type TVDSNtpGettimeThread = class(TThread)
    procedure Execute; override;
end;

type TVDSNtpServer = class(TIDTimeServer)
    procedure NtpServerRequest(AThread: TIdPeerThread);
end;

type TVDSWhoisClient = class(TIdWhois)
    procedure WhoisWorkBegin(Sender: TObject; AWorkMode: TWorkMode; const AWorkCountMax: Integer);
    procedure WhoisWork(Sender: TObject; AWorkMode: TWorkMode; const AWorkCount: Integer);
end;

type TVDSWhoisQueryThread = class(TThread)
    procedure Execute; override;
end;

type TVDSWhoisServer = class(TIDWhoisServer)
  procedure WhoisServerCommandLookup(AThread: TIdPeerThread; ALookup: String);
end;

type TVDSEchoClient = class(TIdEcho)
    procedure EchoDisconnected(Sender: TObject);
    procedure EchoWorkBegin(Sender: TObject; AWorkMode: TWorkMode; const AWorkCountMax: Integer);
    procedure EchoWork(Sender: TObject; AWorkMode: TWorkMode; const AWorkCount: Integer);
end;

type TVDSEchoConnectThread = class(TThread)
    procedure Execute; override;
end;

type TVDSEchoDisconnectThread = class(TThread)
    procedure Execute; override;
end;

type TVDSEchoRequestThread = class(TThread)
    procedure Execute; override;
end;

type TVDSEchoServer = class(TIDEchoServer)
  procedure EchoServerConnect(AThread: TIdPeerThread);
  procedure EchoServerDisconnect(AThread: TIdPeerThread);
end;

type TVDSUdpClient = class(TIdUdpClient)
    procedure UdpWorkBegin(Sender: TObject; AWorkMode: TWorkMode; const AWorkCountMax: Integer);
    procedure UdpWork(Sender: TObject; AWorkMode: TWorkMode; const AWorkCount: Integer);
end;

type TVDSUdpSendThread = class(TThread)
    procedure Execute; override;
end;

type TVDSUdpClientTimer = class(TTimer)
  procedure TimerEvent(Sender: TObject);
end;

type TVDSUdpServer = class(TIDUdpServer)
  procedure UDPServerMessage(Sender: TObject; AData: TStream; ABinding: TIdSocketHandle);
end;

procedure BroadCastMessage(Name: String; Input: String);

const
  max_par = 9;        { maximum number of params/args (user-definable) }
  buf_size = 999999;     { parameter buffer size (user-definable) }

var
  Form1: TForm;
  AHandle: THandle;   { application handle }
  eventproc: exteventproc;
  p, errorcode: Integer;
  parambuf: Array[0..buf_size-1] of Char; { use GetMem/FreeMem for large buffers }
  IsDirectory, IsLink: Boolean;
  AntiFreeze: TIdAntiFreeze;
  HttpClient: array[1..99] of TVDSHttpClient;
  HttpClientSSL: array[1..99] of TIDConnectionInterceptOpenSSL;
  HttpText: array[1..99] of string;
  HttpProtocolVersion: array[1..99] of TIDHttpProtocolVersion;
  HttpGetThread: array[1..99] of TVDSHTTPGetThread;
  HttpGetThreadUrl: array[1..99] of string;
  HttpGetThreadNo: Integer;
  HttpGetHeaderThread: array[1..99] of TVDSHTTPGetHeaderThread;
  HttpGetHeaderThreadUrl: array[1..99] of string;
  HttpGetHeaderThreadNo: Integer;
  HttpPostThread: array[1..99] of TVDSHTTPPostThread;
  HttpPostThreadUrl: array[1..99] of string;
  HttpPostThreadFile: array[1..99] of string;
  HttpPostThreadNo: Integer;
  HttpDownloadThread: array[1..99] of TVDSHTTPDownloadThread;
  HttpDownloadThreadUrl: array[1..99] of string;
  HttpDownloadThreadFile: array[1..99] of string;
  HttpDownloadThreadNo: Integer;
  HttpUseThread: array[1..99] of Boolean;
  HttpTotalBytes: array[1..99] of Integer;
  HttpCurrBytes: array[1..99] of Integer;
  FtpClient: array[1..99] of TVDSFtpClient;
  FtpLog: array[1..99] of TVDSFtpLog;
  FtpLogList: array[1..99] of TStringList;
  FtpFileList: array[1..99] of TStringList;
  FtpCurrentDir: array[1..99] of string;
  FtpConnectThread: array[1..99] of TVDSFTPConnectThread;
  FtpConnectThreadHost: array[1..99] of string;
  FtpConnectThreadPort: array[1..99] of string;
  FtpConnectThreadNo: Integer;
  FtpDisconnectThread: array[1..99] of TVDSFTPDisconnectThread;
  FtpDisconnectThreadNo: Integer;
  FtpRefreshThread: array[1..99] of TVDSFTPRefreshThread;
  FtpRefreshThreadNo: Integer;
  FtpGetFileThread: array[1..99] of TVDSFTPGetFileThread;
  FtpGetFileThreadLocalFile: array[1..99] of string;
  FtpGetFileThreadNetworkFile: array[1..99] of string;
  FtpGetFileThreadNo: Integer;
  FtpPutFileThread: array[1..99] of TVDSFTPPutFileThread;
  FtpPutFileThreadLocalFile: array[1..99] of string;
  FtpPutFileThreadNetworkFile: array[1..99] of string;
  FtpPutFileThreadNo: Integer;
  FtpTotalBytes: array[1..99] of Integer;
  FtpCurrBytes: array[1..99] of Integer;
  FtpUseThread: array[1..99] of Boolean;
  Pop3Client: array[1..99] of TVDSPop3Client;
  Pop3Message: array[1..99] of TIDMessage;
  Pop3Attachment: array[1..99] of TStrings;
  Pop3Body: array[1..99] of TStrings;
  Pop3ConnectThread: array[1..99] of TVDSPOP3ConnectThread;
  Pop3ConnectThreadHost: array[1..99] of string;
  Pop3ConnectThreadPort: array[1..99] of string;
  Pop3ConnectThreadNo: Integer;
  Pop3DisconnectThread: array[1..99] of TVDSPop3DisconnectThread;
  Pop3DisconnectThreadNo: Integer;
  Pop3GetHeaderThread: array[1..99] of TVDSPop3GetHeaderThread;
  Pop3GetHeaderThreadMessage: array[1..99] of string;
  Pop3GetHeaderThreadNo: Integer;
  Pop3GetMailThread: array[1..99] of TVDSPop3GetMailThread;
  Pop3GetMailThreadMessage: array[1..99] of string;
  Pop3GetMailThreadNo: Integer;
  Pop3TotalBytes: array[1..99] of Integer;
  Pop3CurrBytes: array[1..99] of Integer;
  Pop3UseThread: array[1..99] of Boolean;
  SmtpClient: array[1..99] of TVDSSmtpClient;
  SmtpMessage: array[1..99] of TIDMessage;
  SmtpConnectThread: array[1..99] of TVDSSmtpConnectThread;
  SmtpConnectThreadHost: array[1..99] of string;
  SmtpConnectThreadPort: array[1..99] of string;
  SmtpConnectThreadNo: Integer;
  SmtpDisconnectThread: array[1..99] of TVDSSmtpDisconnectThread;
  SmtpDisconnectThreadNo: Integer;
  SmtpSendThread: array[1..99] of TVDSSmtpSendThread;
  SmtpSendThreadNo: Integer;
  SmtpTotalBytes: array[1..99] of Integer;
  SmtpCurrBytes: array[1..99] of Integer;
  SmtpUseThread: array[1..99] of Boolean;
  TcpClient: array[1..99] of TVDSTcpClient;
  TcpClientStr: array[1..99] of string;
  TcpClientTimer: TVDSTcpClientTimer;
  TcpClientConnectThread: array[1..99] of TVDSTcpConnectThread;
  TcpClientConnectThreadHost: array[1..99] of string;
  TcpClientConnectThreadPort: array[1..99] of string;
  TcpClientConnectThreadNo: Integer;
  TcpClientDisconnectThread: array[1..99] of TVDSTcpDisconnectThread;
  TcpClientDisconnectThreadNo: Integer;
  TcpClientSendThread: array[1..99] of TVDSTcpSendThread;
  TcpClientSendThreadMsg: array[1..99] of string;
  TcpClientSendThreadNo: Integer;
  TcpClientTotalBytes: array[1..99] of Integer;
  TcpClientCurrBytes: array[1..99] of Integer;
  TcpClientUseThread: array[1..99] of Boolean;
  TcpServer: array[1..99] of TVDSTcpServer;
  TcpServerThread: array[1..99] of TIdThreadMgrDefault;
  TcpServerClientList: array[1..99] of TList;
  TcpServerClients: array[1..99] of TStringList;
  TcpServerClientInc: array[1..99] of Integer;
  TcpServerBinding: array[1..99] of TIdSocketHandle;
  TcpServerCurrUsrId: array[1..99] of Integer;
  TcpServerCurrUsrIp: array[1..99] of string;
  TcpServerCurrUsrMsg: array[1..99] of string;
  IcmpClient: array[1..99] of TVDSIcmpClient;
  IcmpClientReplyStr: array[1..99] of string;
  IcmpClientPingThread: array[1..99] of TVDSIcmpPingThread;
  IcmpClientPingThreadHost: array[1..99] of string;
  IcmpClientPingThreadPort: array[1..99] of string;
  IcmpClientPingThreadNo: Integer;
  IcmpClientTotalBytes: array[1..99] of Integer;
  IcmpClientCurrBytes: array[1..99] of Integer;
  IcmpClientUseThread: array[1..99] of Boolean;
  NtpClient: array[1..99] of TVDSNtpClient;
  NtpClientDateTimeStr: array[1..99] of string;
  NtpClientDateTimeEnc: array[1..99] of string;
  NtpClientGettimeThread: array[1..99] of TVDSNtpGettimeThread;
  NtpClientGettimeThreadHost: array[1..99] of string;
  NtpClientGettimeThreadPort: array[1..99] of string;
  NtpClientGettimeThreadNo: Integer;
  NtpClientTotalBytes: array[1..99] of Integer;
  NtpClientCurrBytes: array[1..99] of Integer;
  NtpClientUseThread: array[1..99] of Boolean;
  NtpServer: array[1..99] of TVDSNtpServer;
  NtpServerThread: array[1..99] of TIdThreadMgrDefault;
  NtpServerBinding: array[1..99] of TIdSocketHandle;
  WhoisClient: array[1..99] of TVDSWhoisClient;
  WhoisClientStr: array[1..99] of string;
  WhoisClientQueryThread: array[1..99] of TVDSWhoisQueryThread;
  WhoisClientQueryThreadStr: array[1..99] of string;
  WhoisClientQueryThreadNo: Integer;
  WhoisClientTotalBytes: array[1..99] of Integer;
  WhoisClientCurrBytes: array[1..99] of Integer;
  WhoisClientUseThread: array[1..99] of Boolean;
  WhoisServer: array[1..99] of TVDSWhoisServer;
  WhoisServerThread: array[1..99] of TIdThreadMgrDefault;
  WhoisServerBinding: array[1..99] of TIdSocketHandle;
  WhoisServerStr: array[1..99] of string;
  WhoisServerSimpleClient: array[1..99] of TIdPeerThread;
  EchoClient: array[1..99] of TVDSEchoClient;
  EchoClientStr: array[1..99] of string;
  EchoClientTime: array[1..99] of string;
  EchoClientConnectThread: array[1..99] of TVDSEchoConnectThread;
  EchoClientConnectThreadHost: array[1..99] of string;
  EchoClientConnectThreadPort: array[1..99] of string;
  EchoClientConnectThreadNo: Integer;
  EchoClientDisconnectThread: array[1..99] of TVDSEchoDisconnectThread;
  EchoClientDisconnectThreadNo: Integer;
  EchoClientRequestThread: array[1..99] of TVDSEchoRequestThread;
  EchoClientRequestThreadStr: array[1..99] of string;
  EchoClientRequestThreadNo: Integer;
  EchoClientTotalBytes: array[1..99] of Integer;
  EchoClientCurrBytes: array[1..99] of Integer;
  EchoClientUseThread: array[1..99] of Boolean;
  EchoServer: array[1..99] of TVDSEchoServer;
  EchoServerThread: array[1..99] of TIdThreadMgrDefault;
  EchoServerBinding: array[1..99] of TIdSocketHandle;
  UdpClient: array[1..99] of TVDSUdpClient;
  UdpClientTimer: TVDSUdpClientTimer;
  UdpClientStr: array[1..99] of string;
  UdpClientSendThread: array[1..99] of TVDSUdpSendThread;
  UdpClientSendThreadStr: array[1..99] of string;
  UdpClientSendThreadNo: Integer;
  UdpClientTotalBytes: array[1..99] of Integer;
  UdpClientCurrBytes: array[1..99] of Integer;
  UdpClientUseThread: array[1..99] of Boolean;
  UdpServer: array[1..99] of TVDSUdpServer;
  UdpServerBinding: array[1..99] of TIdSocketHandle;
  UdpServerCurrUsr: array[1..99] of TIdSocketHandle;
  UdpServerCurrUsrIp: array[1..99] of string;
  UdpServerCurrUsrPort: array[1..99] of string;
  UdpServerCurrUserMsg: array[1..99] of string;

  { start user-defined variables }
  rstat: Boolean;
  { end user-defined variables }

function Init(Handle: THandle; Addr: exteventproc; KeyString: String; var maxpar,bufsize: Integer): PChar; export;
{$IFNDEF VER80}
cdecl;
{$ENDIF}

function CommandProc(Params: PChar): Integer; export;
{$IFNDEF VER80}
cdecl;
{$ENDIF}

function FuncProc(Args: PChar): PChar; export;
{$IFNDEF VER80}
cdecl;
{$ENDIF}

function StatProc: Integer; export;
{$IFNDEF VER80}
cdecl;
{$ENDIF}

implementation

{ begin utility functions (not exported) }
function NextParam: PChar; {get next command parameter}
begin
  Result := Addr(parambuf[p]);
  while parambuf[p]<>#0 do
  begin
    inc(p);
  end;
  inc(p);
end;

function GetNameFromDirLine(Line: String; Var IsDirectory: Boolean; Var IsLink: Boolean): String;
Var
  i: Integer;
  DosListing: Boolean;
begin
  IsDirectory := Line[1] = 'd';
  IsLink := Line[1] = 'l';
  DosListing := false;
  for i := 0 to 7 do begin
    if (i = 2) and not IsDirectory then begin
      IsDirectory := Copy(Line, 1, Pos(' ', Line) - 1) = '<DIR>';
      if not IsDirectory then
        DosListing := Line[1] in ['0'..'9']
      else DosListing := true;
    end;
    Delete(Line, 1, Pos(' ', Line));
    While Line[1] = ' ' do
    Delete(Line, 1, 1);
    if DosListing and (i = 7) then break;
  end;
  Result := Line;
end;

{ end utility functions }

{ begin exported functions }

function Init(Handle: THandle; addr: exteventproc; KeyString: String; var maxpar,bufsize: Integer): PChar;
begin
  AHandle := Handle;
  eventproc := addr;
  maxpar := max_par;
  bufsize := buf_size;
  Result := 'INTERNET';                    {return the command/function name  }
  rstat := true;                            {initialisation}
  Form1 := TForm.Create(nil);
  AntiFreeze := TIdAntiFreeze.Create(Form1);
  AntiFreeze.Active := False;
  AntiFreeze.ApplicationHasPriority := True;
  AntiFreeze.IdleTimeout := 250;
  AntiFreeze.OnlyWhenIdle := False;
  AntiFreeze.Active := True;
  TcpClientTimer := TVDSTcpClientTimer.Create(Form1);
  TcpClientTimer.Name := 'TCPTIMER';
  TcpClientTimer.Enabled := False;
  TcpClientTimer.Interval := 500;
  TcpClientTimer.OnTimer := TcpClientTimer.TimerEvent;
  TcpClientTimer.Enabled := True;
  UdpClientTimer := TVDSUdpClientTimer.Create(Form1);
  UdpClientTimer.Name := 'UDPTIMER';
  UdpClientTimer.Enabled := False;
  UdpClientTimer.Interval := 500;
  UdpClientTimer.OnTimer := UdpClientTimer.TimerEvent;
  UdpClientTimer.Enabled := True;
end;

function CommandProc(Params: PChar): Integer;
var
  Buffer1, Buffer2, Buffer3, Buffer4, Buffer5,
  Buffer6, Buffer7, Buffer8: string;
  IntBuffer1: integer;
  FileStream: array[1..99] of TFileStream;
  StringStream: array[1..99] of TStringStream;
  MemStream: array[1..99] of TMemoryStream;
  StringList: array[1..99] of TStringList;
  SmtpHtmlStrings: array[1..99] of TStrings;
  TcpServerSimpleClient: array[1..99] of TSimpleClient;

begin
  errorcode := 0;                         {initialise errorcode}
  for p := 0 to pred(buf_size) do
    parambuf[p] := Params[p];             {copy parameter string into buffer}
  p := 0;                                 {set pointer for NextParam}
  { start user-defined code }

  Buffer1 := NextParam;
  Buffer2 := NextParam;
  Buffer3 := NextParam;
  Buffer4 := NextParam;
  Buffer5 := NextParam;
  Buffer6 := NextParam;
  Buffer7 := NextParam;
  Buffer8 := NextParam;

  if UpperCase(Buffer1) = 'HTTP' then
  begin
      if UpperCase(Buffer2) = 'CREATE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          HttpClient[StrToInt(Buffer3)] := TVDSHttpClient.Create(Form1);
          HttpClient[StrToInt(Buffer3)].Name := 'HTTP'+Buffer3;
          HttpClientSSL[StrToInt(Buffer3)] := TIDConnectionInterceptOpenSSL.Create(Form1);
          HttpClientSSL[StrToInt(Buffer3)].Name := 'HTTPSSL'+Buffer3;
          HttpClient[StrToInt(Buffer3)].HandleRedirects := True;
          HttpClient[StrToInt(Buffer3)].Intercept := HttpClientSSL[StrToInt(Buffer3)];
          HttpClient[StrToInt(Buffer3)].Request.UserAgent := 'VDSIPP HTTP';
          HttpClient[StrToInt(Buffer3)].Response.UserAgent := HttpClient[StrToInt(Buffer3)].Request.UserAgent;
          HttpClient[StrToInt(Buffer3)].Request.Accept := '*/*';
          HttpProtocolVersion[StrToInt(Buffer3)] := pv1_1;
          HttpClient[StrToInt(Buffer3)].ProtocolVersion := HttpProtocolVersion[StrToInt(Buffer3)];
          HttpClient[StrToInt(Buffer3)].Port := 80;
          HttpTotalBytes[StrToInt(Buffer3)] := 0;
          HttpCurrBytes[StrToInt(Buffer3)] := 0;
          HttpText[StrToInt(Buffer3)] := '';
          HttpUseThread[StrToInt(Buffer3)] := True;
          HttpClient[StrToInt(Buffer3)].OnWorkBegin := HttpClient[StrToInt(Buffer3)].HttpWorkBegin;
          HttpClient[StrToInt(Buffer3)].OnWork := HttpClient[StrToInt(Buffer3)].HttpWork;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'DESTROY' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          HttpClient[StrToInt(Buffer3)].Free;
          HttpClientSSL[StrToInt(Buffer3)].Free;
          HttpTotalBytes[StrToInt(Buffer3)] := 0;
          HttpCurrBytes[StrToInt(Buffer3)] := 0;
          HttpText[StrToInt(Buffer3)] := '';
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'THREADS' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if UpperCase(Buffer4) = 'ON' then
          HttpUseThread[StrToInt(Buffer3)] := True
          else
          if UpperCase(Buffer4) = 'OFF' then
          HttpUseThread[StrToInt(Buffer3)] := False;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'AUTHENTICATE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          HttpClient[StrToInt(Buffer3)].Request.Username := Buffer4;
          HttpClient[StrToInt(Buffer3)].Request.Password := Buffer5;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'PROXY' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          HttpClient[StrToInt(Buffer3)].Request.ProxyServer := Buffer4;
          HttpClient[StrToInt(Buffer3)].SocksInfo.Host := Buffer4;
          HttpClient[StrToInt(Buffer3)].Request.ProxyPort := StrToIntDef(Buffer5, 80);
          HttpClient[StrToInt(Buffer3)].SocksInfo.Port := StrToInt(Buffer5);
          HttpClient[StrToInt(Buffer3)].Request.ProxyUsername := Buffer6;
          HttpClient[StrToInt(Buffer3)].SocksInfo.UserID := Buffer6;
          HttpClient[StrToInt(Buffer3)].Request.ProxyPassword := Buffer7;
          HttpClient[StrToInt(Buffer3)].SocksInfo.Password := Buffer7;
          if not(Buffer6 = '') AND not(Buffer7 = '') then
          HttpClient[StrToInt(Buffer3)].SocksInfo.Authentication := saUsernamePassword
          else
          HttpClient[StrToInt(Buffer3)].SocksInfo.Authentication := saNoAuthentication;    
          if not(Buffer8 = '') then
          begin
            if StrToInt(Buffer8) = 0 then
            HttpClient[StrToInt(Buffer3)].SocksInfo.Version := svSocks4;
            if StrToInt(Buffer8) = 1 then
            HttpClient[StrToInt(Buffer3)].SocksInfo.Version := svSocks4A;
            if StrToInt(Buffer8) = 2 then
            HttpClient[StrToInt(Buffer3)].SocksInfo.Version := svSocks5;
          end;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'PROTOCOL' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if (StrToInt(Buffer4) = 0) then
          HttpProtocolVersion[StrToInt(Buffer3)] := pv1_0
          else
          if (StrToInt(Buffer4) = 1) then
          HttpProtocolVersion[StrToInt(Buffer3)] := pv1_1;
          HttpClient[StrToInt(Buffer3)].ProtocolVersion := HttpProtocolVersion[StrToInt(Buffer3)];
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'STOP' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          HttpClient[StrToInt(Buffer3)].DisconnectSocket;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'USERAGENT' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          HttpClient[StrToInt(Buffer3)].Request.UserAgent := Buffer4;
          HttpClient[StrToInt(Buffer3)].Response.UserAgent := Buffer4;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'GETHEADER' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          HttpText[StrToInt(Buffer3)] := '';
          if HttpUseThread[StrToInt(Buffer3)] = True then
          begin
            HttpGetHeaderThreadUrl[StrToInt(Buffer3)] := Buffer4;
            HttpGetHeaderThreadNo := StrToInt(Buffer3);
            HttpGetHeaderThread[StrToInt(Buffer3)] := TVDSHttpGetHeaderThread.Create(False);
            Sleep(500);
          end
          else
            HttpClient[StrToInt(Buffer3)].Head(Buffer4);
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'GET' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          HttpText[StrToInt(Buffer3)] := '';
          if HttpUseThread[StrToInt(Buffer3)] = True then
          begin
            HttpGetThreadUrl[StrToInt(Buffer3)] := Buffer4;
            HttpGetThreadNo := StrToInt(Buffer3);
            HttpGetThread[StrToInt(Buffer3)] := TVDSHttpGetThread.Create(False);
            Sleep(500);
          end
          else
            HttpText[StrToInt(Buffer3)] := HttpClient[StrToInt(Buffer3)].Get(Buffer4);
          except
          HttpClient[StrToInt(Buffer3)].Request.Clear;
          HttpClient[StrToInt(Buffer3)].Response.Clear;
          HttpText[StrToInt(Buffer3)] := '';
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'POST' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          HttpText[StrToInt(Buffer3)] := '';
          if HttpUseThread[StrToInt(Buffer3)] = True then
          begin
            HttpPostThreadUrl[StrToInt(Buffer3)] := Buffer4;
            HttpPostThreadFile[StrToInt(Buffer3)] := Buffer5;
            HttpPostThreadNo := StrToInt(Buffer3);
            HttpPostThread[StrToInt(Buffer3)] := TVDSHttpPostThread.Create(False);
            Sleep(500);
          end
          else
          begin
            StringStream[StrToInt(Buffer3)] := TStringStream.Create('');
            if FileExists(Buffer5) then
            begin
              MemStream[StrToInt(Buffer3)] := TMemoryStream.Create;
              MemStream[StrToInt(Buffer3)].LoadFromFile(Buffer5);
              HttpClient[StrToInt(Buffer3)].Post(Buffer4, MemStream[StrToInt(Buffer3)], StringStream[StrToInt(Buffer3)]);
              MemStream[StrToInt(Buffer3)].Free;
            end
            else
            begin
              StringList[StrToInt(Buffer3)] := TStringList.Create;
              StringList[StrToInt(Buffer3)].Text := Buffer5;
              HttpClient[StrToInt(Buffer3)].Post(Buffer4, StringList[StrToInt(Buffer3)], StringStream[StrToInt(Buffer3)]);
              StringList[StrToInt(Buffer3)].Free;
            end;
            HttpText[StrToInt(Buffer3)] := StringStream[StrToInt(Buffer3)].DataString;
            StringStream[StrToInt(Buffer3)].Free;
            HttpClient[StrToInt(Buffer3)].ProtocolVersion := HttpProtocolVersion[StrToInt(Buffer3)];
          end;
          except
          HttpClient[StrToInt(Buffer3)].Request.Clear;
          HttpClient[StrToInt(Buffer3)].Response.Clear;
          HttpText[StrToInt(Buffer3)] := '';
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'DOWNLOAD' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          if not(Buffer4 = '') AND not(Buffer5 = '') then
          begin
            try
            HttpText[StrToInt(Buffer3)] := '';
            if HttpUseThread[StrToInt(Buffer3)] = True then
            begin
              HttpDownloadThreadUrl[StrToInt(Buffer3)] := Buffer4;
              HttpDownloadThreadFile[StrToInt(Buffer3)] := Buffer5;
              HttpDownloadThreadNo := StrToInt(Buffer3);
              HttpDownloadThread[StrToInt(Buffer3)] := TVDSHttpDownloadThread.Create(False);
              Sleep(500);
            end
            else
            begin
              FileStream[StrToInt(Buffer3)] := TFileStream.Create(Buffer5, fmCreate or fmOpenWrite and fmShareDenyNone);
              HttpClient[StrToInt(Buffer3)].Get(Buffer4,FileStream[StrToInt(Buffer3)]);
              FileStream[StrToInt(Buffer3)].Free;
            end;
            except
            HttpClient[StrToInt(Buffer3)].Request.Clear;
            HttpClient[StrToInt(Buffer3)].Response.Clear;
            HttpText[StrToInt(Buffer3)] := '';
            end;
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'RANGE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          if not(Buffer4 = '') AND not(Buffer5 = '') then
          begin
            try
            HttpClient[StrToInt(Buffer3)].Request.ContentRangeStart := StrToInt(Buffer4);
            HttpClient[StrToInt(Buffer3)].Request.ContentRangeEnd := StrToInt(Buffer5);
            except
            end;
          end;
        end;
      end
      else
      if UpperCase(Buffer3) = 'NEW' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if HttpClient[StrToInt(Buffer3)].Connected = True then
          HttpClient[StrToInt(Buffer3)].Disconnect;
          HttpClient[StrToInt(Buffer3)].Request.Clear;
          HttpClient[StrToInt(Buffer3)].Response.Clear;
          HttpClient[StrToInt(Buffer3)].Host := '';
          HttpClient[StrToInt(Buffer3)].Port := 80;
          HttpClient[StrToInt(Buffer3)].Request.UserAgent := 'VDSIPP HTTP';
          HttpClient[StrToInt(Buffer3)].Response.UserAgent := HttpClient[StrToInt(Buffer3)].Request.UserAgent;
          HttpProtocolVersion[StrToInt(Buffer3)] := pv1_1;
          HttpClient[StrToInt(Buffer3)].ProtocolVersion := HttpProtocolVersion[StrToInt(Buffer3)];
          HttpClient[StrToInt(Buffer3)].SocksInfo.Authentication := saNoAuthentication;
          HttpClient[StrToInt(Buffer3)].SocksInfo.Host := '';
          HttpClient[StrToInt(Buffer3)].SocksInfo.Password := '';
          HttpClient[StrToInt(Buffer3)].SocksInfo.Port := 0;
          HttpClient[StrToInt(Buffer3)].SocksInfo.UserID := '';
          HttpClient[StrToInt(Buffer3)].SocksInfo.Version := svNoSocks;
          HttpTotalBytes[StrToInt(Buffer3)] := 0;
          HttpCurrBytes[StrToInt(Buffer3)] := 0;
          HttpText[StrToInt(Buffer3)] := '';
          HttpUseThread[StrToInt(Buffer3)] := True;
          except
          end;
        end;
      end;
  end
  else
  if UpperCase(Buffer1) = 'FTP' then
  begin
      if UpperCase(Buffer2) = 'CREATE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          FtpClient[StrToInt(Buffer3)] := TVDSFtpClient.Create(Form1);
          FtpClient[StrToInt(Buffer3)].Name := 'FTP'+Buffer3;
          FtpLog[StrToInt(Buffer3)] := TVDSFtpLog.Create(Form1);
          FtpLog[StrToInt(Buffer3)].Name := 'LOG'+Buffer3;
          FtpLogList[StrToInt(Buffer3)] := TStringList.Create;
          FtpFileList[StrToInt(Buffer3)] := TStringList.Create;
          FtpLog[StrToInt(Buffer3)].OnLogItem := FtpLog[StrToInt(Buffer3)].FtpLogDebugLogItem;
          FtpLog[StrToInt(Buffer3)].LogTime := True;
          FtpLog[StrToInt(Buffer3)].Target := ltDebugOutput;
          FtpClient[StrToInt(Buffer3)].Intercept := FtpLog[StrToInt(Buffer3)];
          FtpClient[StrToInt(Buffer3)].InterceptEnabled := True;
          FtpClient[StrToInt(Buffer3)].Passive := True;
          FtpClient[StrToInt(Buffer3)].TransferType := ftBinary;
          FtpClient[StrToInt(Buffer3)].Port := 21;
          //FtpClient.SocksInfo.Host := 'localhost';
          //FtpClient.SocksInfo.Port := 1080;
          FtpClient[StrToInt(Buffer3)].RecvBufferSize := 8192;
          FtpClient[StrToInt(Buffer3)].SendBufferSize := 1024;
          FtpCurrentDir[StrToInt(Buffer3)] := '/';
          FtpCurrBytes[StrToInt(Buffer3)] := 0;
          FtpTotalBytes[StrToInt(Buffer3)] := 0;
          FtpLog[StrToInt(Buffer3)].Active := True;
          FtpUseThread[StrToInt(Buffer3)] := True;
          FtpClient[StrToInt(Buffer3)].OnDisconnected := FtpClient[StrToInt(Buffer3)].FtpDisconnected;
          FtpClient[StrToInt(Buffer3)].OnWorkBegin := FtpClient[StrToInt(Buffer3)].FtpWorkBegin;
          FtpClient[StrToInt(Buffer3)].OnWork := FtpClient[StrToInt(Buffer3)].FtpWork;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'DESTROY' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          FtpClient[StrToInt(Buffer3)].Free;
          FtpLog[StrToInt(Buffer3)].Free;
          FtpLogList[StrToInt(Buffer3)].Free;
          FtpFileList[StrToInt(Buffer3)].Free;
          FtpCurrentDir[StrToInt(Buffer3)] := '';
          FtpCurrBytes[StrToInt(Buffer3)] := 0;
          FtpTotalBytes[StrToInt(Buffer3)] := 0;
        except
        end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'AUTHENTICATE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          FtpClient[StrToInt(Buffer3)].User := Buffer4;
          FtpClient[StrToInt(Buffer3)].Password := Buffer5;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'THREADS' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if UpperCase(Buffer4) = 'ON' then
          FtpUseThread[StrToInt(Buffer3)] := True
          else
          if UpperCase(Buffer4) = 'OFF' then
          FtpUseThread[StrToInt(Buffer3)] := False;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'CONNECT' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if FtpUseThread[StrToInt(Buffer3)] = True then
          begin
            FtpConnectThreadHost[StrToInt(Buffer3)] := Buffer4;
            FtpConnectThreadPort[StrToInt(Buffer3)] := Buffer5;
            FtpConnectThreadNo := StrToInt(Buffer3);
            FtpConnectThread[StrToInt(Buffer3)] := TVDSFtpConnectThread.Create(False);
            Sleep(500);
          end
          else
          begin
            if FtpClient[StrToInt(Buffer3)].Connected then
            try
            FtpClient[StrToInt(Buffer3)].Abort;
            FtpClient[StrToInt(Buffer3)].Quit;
            except
            end;
            FtpClient[StrToInt(Buffer3)].Host := Buffer4;
            if not(Buffer5 = '') then
            begin
              if StrToInt(Buffer5) >= 0 then
              FtpClient[StrToInt(Buffer3)].Port := StrToInt(Buffer5)
              else
              FtpClient[StrToInt(Buffer3)].Port := 21;
            end
            else
            FtpClient[StrToInt(Buffer3)].Port := 21;

            FtpClient[StrToInt(Buffer3)].Connect;
            //FtpClient[StrToInt(Buffer3)].List(FtpFileList[StrToInt(Buffer3)]);
          end;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'DISCONNECT' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if FtpUseThread[StrToInt(Buffer3)] = True then
          begin
            FtpDisconnectThreadNo := StrToInt(Buffer3);
            FtpDisconnectThread[StrToInt(Buffer3)] := TVDSFtpDisconnectThread.Create(False);
            Sleep(500);
          end
          else
          FtpClient[StrToInt(Buffer3)].Disconnect;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'PROXY' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          FtpClient[StrToInt(Buffer3)].SocksInfo.Host := Buffer4;
          FtpClient[StrToInt(Buffer3)].SocksInfo.Port := StrToInt(Buffer5);
          FtpClient[StrToInt(Buffer3)].SocksInfo.UserID := Buffer6;
          FtpClient[StrToInt(Buffer3)].SocksInfo.Password := Buffer7;
          if not(Buffer6 = '') AND not(Buffer7 = '') then
          FtpClient[StrToInt(Buffer3)].SocksInfo.Authentication := saUsernamePassword
          else
          FtpClient[StrToInt(Buffer3)].SocksInfo.Authentication := saNoAuthentication;
          if not(Buffer8 = '') then
          begin
            if StrToInt(Buffer8) = 0 then
            FtpClient[StrToInt(Buffer3)].SocksInfo.Version := svSocks4;
            if StrToInt(Buffer8) = 1 then
            FtpClient[StrToInt(Buffer3)].SocksInfo.Version := svSocks4A;
            if StrToInt(Buffer8) = 2 then
            FtpClient[StrToInt(Buffer3)].SocksInfo.Version := svSocks5;
          end;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'NOOP' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          FtpClient[StrToInt(Buffer3)].Noop;
          //FtpClient[StrToInt(Buffer3)].List(FtpFileList[StrToInt(Buffer3)]);
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'REFRESH' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if FtpUseThread[StrToInt(Buffer3)] = True then
          begin
            FtpRefreshThreadNo := StrToInt(Buffer3);
            FtpRefreshThread[StrToInt(Buffer3)] := TVDSFtpRefreshThread.Create(False);
            Sleep(500);
          end
          else
          FtpClient[StrToInt(Buffer3)].List(FtpFileList[StrToInt(Buffer3)]);
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'PASSIVEMODE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if not(Buffer4 = '') then
          begin
            if StrToInt(Buffer4) = 0 then
            FtpClient[StrToInt(Buffer3)].Passive := False
            else
            if StrToInt(Buffer4) = 1 then
            FtpClient[StrToInt(Buffer3)].Passive := True;
          end;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'TRANSFERMODE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if not(Buffer4 = '') then
          begin
            if StrToInt(Buffer4) = 0 then
            FtpClient[StrToInt(Buffer3)].TransferType := ftASCII
            else
            if StrToInt(Buffer4) = 1 then
            FtpClient[StrToInt(Buffer3)].TransferType := ftBinary;
          end;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'SITE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if not(Buffer4 = '') then
          begin
            FtpClient[StrToInt(Buffer3)].Site(Buffer4);
            //FtpClient[StrToInt(Buffer3)].List(FtpFileList[StrToInt(Buffer3)]);
          end;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'QUIT' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          FtpClient[StrToInt(Buffer3)].Quit;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'ABORT' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          FtpClient[StrToInt(Buffer3)].Abort;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'CHANGEDIRUP' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          FtpClient[StrToInt(Buffer3)].ChangeDirUp;
          //FtpClient[StrToInt(Buffer3)].List(FtpFileList[StrToInt(Buffer3)]);
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'CHANGEDIR' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if not(Buffer4 = '') then
          begin
            FtpClient[StrToInt(Buffer3)].ChangeDir(Buffer4);
            //FtpClient[StrToInt(Buffer3)].List(FtpFileList[StrToInt(Buffer3)]);
          end;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'MAKEDIR' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if not(Buffer4 = '') then
          begin
            FtpClient[StrToInt(Buffer3)].MakeDir(Buffer4);
            //FtpClient[StrToInt(Buffer3)].List(FtpFileList[StrToInt(Buffer3)]);
          end;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'DELETEDIR' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if not(Buffer4 = '') then
          begin
            FtpClient[StrToInt(Buffer3)].RemoveDir(Buffer4);
            //FtpClient[StrToInt(Buffer3)].List(FtpFileList[StrToInt(Buffer3)]);
          end;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'RENAMEFILE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if not(Buffer4 = '') AND not(Buffer5 = '') then
          begin
            FtpClient[StrToInt(Buffer3)].Rename(Buffer4, Buffer5);
            //FtpClient[StrToInt(Buffer3)].List(FtpFileList[StrToInt(Buffer3)]);
          end;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'DELETEFILE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if not(Buffer4 = '') then
          begin
            FtpClient[StrToInt(Buffer3)].Delete(Buffer4);
            //FtpClient[StrToInt(Buffer3)].List(FtpFileList[StrToInt(Buffer3)]);
          end;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'GETFILE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if FtpUseThread[StrToInt(Buffer3)] = True then
          begin
            FtpGetFileThreadNo := StrToInt(Buffer3);
            FtpGetFileThreadLocalFile[StrToInt(Buffer3)] := Buffer4;
            FtpGetFileThreadNetworkFile[StrToInt(Buffer3)] := Buffer5;
            FtpGetFileThread[StrToInt(Buffer3)] := TVDSFtpGetFileThread.Create(False);
            Sleep(500);
          end
          else
          if not(Buffer4 = '') AND not(Buffer5 = '') then
          FtpClient[StrToInt(Buffer3)].Get(Buffer4, Buffer5, True);
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'PUTFILE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if FtpUseThread[StrToInt(Buffer3)] = True then
          begin
            FtpPutFileThreadNo := StrToInt(Buffer3);
            FtpPutFileThreadLocalFile[StrToInt(Buffer3)] := Buffer4;
            FtpPutFileThreadNetworkFile[StrToInt(Buffer3)] := Buffer5;
            FtpPutFileThread[StrToInt(Buffer3)] := TVDSFtpPutFileThread.Create(False);
            Sleep(500);
          end
          else
          if not(Buffer4 = '') AND FileExists(Buffer4) AND not(Buffer5 = '') then
          begin
            FtpClient[StrToInt(Buffer3)].Put(Buffer4, Buffer5, False);
            //FtpClient[StrToInt(Buffer3)].List(FtpFileList[StrToInt(Buffer3)]);
          end;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'NEW' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if FtpClient[StrToInt(Buffer3)].Connected = True then
          FtpClient[StrToInt(Buffer3)].Disconnect;
          FtpClient[StrToInt(Buffer3)].Host := '';
          FtpClient[StrToInt(Buffer3)].Port := 21;
          FtpClient[StrToInt(Buffer3)].User := '';
          FtpClient[StrToInt(Buffer3)].Password := '';
          FtpLog[StrToInt(Buffer3)].Log('');
          FtpLogList[StrToInt(Buffer3)].Clear;
          FtpFileList[StrToInt(Buffer3)].Clear;
          FtpCurrentDir[StrToInt(Buffer3)] := '/';
          FtpCurrBytes[StrToInt(Buffer3)] := 0;
          FtpTotalBytes[StrToInt(Buffer3)] := 0;
          FtpClient[StrToInt(Buffer3)].SocksInfo.Authentication := saNoAuthentication;
          FtpClient[StrToInt(Buffer3)].SocksInfo.Host := '';
          FtpClient[StrToInt(Buffer3)].SocksInfo.Password := '';
          FtpClient[StrToInt(Buffer3)].SocksInfo.Port := 0;
          FtpClient[StrToInt(Buffer3)].SocksInfo.UserID := '';
          FtpClient[StrToInt(Buffer3)].SocksInfo.Version := svNoSocks;
          FtpUseThread[StrToInt(Buffer3)] := True;
          except
          end;
        end;
      end;
  end
  else
  if UpperCase(Buffer1) = 'POP3' then
  begin
      if UpperCase(Buffer2) = 'CREATE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          Pop3Client[StrToInt(Buffer3)] := TVDSPop3Client.Create(Form1);
          Pop3Client[StrToInt(Buffer3)].Name := 'POP3'+Buffer3;
          Pop3Message[StrToInt(Buffer3)] := TidMessage.Create(Form1);
          Pop3Message[StrToInt(Buffer3)].Name := 'POP3MESSAGE'+Buffer3;
          Pop3Attachment[StrToInt(Buffer3)] := TStringList.Create;
          Pop3Body[StrToInt(Buffer3)] := TStringList.Create;
          Pop3CurrBytes[StrToInt(Buffer3)] := 0;
          Pop3TotalBytes[StrToInt(Buffer3)] := 0;
          Pop3Client[StrToInt(Buffer3)].OnDisconnected := Pop3Client[StrToInt(Buffer3)].Pop3Disconnected;
          Pop3Client[StrToInt(Buffer3)].OnWorkBegin := Pop3Client[StrToInt(Buffer3)].Pop3WorkBegin;
          Pop3Client[StrToInt(Buffer3)].OnWork := Pop3Client[StrToInt(Buffer3)].Pop3Work;
          Pop3UseThread[StrToInt(Buffer3)] := True;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'DESTROY' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          Pop3Client[StrToInt(Buffer3)].Free;
          Pop3Message[StrToInt(Buffer3)].Free;
          Pop3Attachment[StrToInt(Buffer3)].Free;
          Pop3Body[StrToInt(Buffer3)].Free;
          Pop3CurrBytes[StrToInt(Buffer3)] := 0;
          Pop3TotalBytes[StrToInt(Buffer3)] := 0;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'AUTHENTICATE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          Pop3Client[StrToInt(Buffer3)].UserId := Buffer4;
          Pop3Client[StrToInt(Buffer3)].Password := Buffer5;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'THREADS' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if UpperCase(Buffer4) = 'ON' then
          Pop3UseThread[StrToInt(Buffer3)] := True
          else
          if UpperCase(Buffer4) = 'OFF' then
          Pop3UseThread[StrToInt(Buffer3)] := False;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'CONNECT' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if Pop3UseThread[StrToInt(Buffer3)] = True then
          begin
            Pop3ConnectThreadNo := StrToInt(Buffer3);
            Pop3ConnectThreadHost[StrToInt(Buffer3)] := Buffer4;
            Pop3ConnectThreadPort[StrToInt(Buffer3)] := Buffer5;
            Pop3ConnectThread[StrToInt(Buffer3)] := TVDSPop3ConnectThread.Create(False);
            Sleep(500);
          end
          else
          begin
            if Pop3Client[StrToInt(Buffer3)].Connected then
            try
            Pop3Client[StrToInt(Buffer3)].Disconnect;
            except
            end;
            Pop3Client[StrToInt(Buffer3)].Host := Buffer4;
            if not(Buffer5 = '') then
            begin
              if StrToInt(Buffer5) >= 0 then
              Pop3Client[StrToInt(Buffer3)].Port := StrToInt(Buffer5)
              else
              Pop3Client[StrToInt(Buffer3)].Port := 110;
            end
            else
            Pop3Client[StrToInt(Buffer3)].Port := 110;

            Pop3Client[StrToInt(Buffer3)].Connect;
          end;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'DISCONNECT' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if Pop3UseThread[StrToInt(Buffer3)] = True then
          begin
            Pop3DisconnectThreadNo := StrToInt(Buffer3);
            Pop3DisconnectThread[StrToInt(Buffer3)] := TVDSPop3DisconnectThread.Create(False);
            Sleep(500);
          end
          else
          Pop3Client[StrToInt(Buffer3)].Disconnect;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'PROXY' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          Pop3Client[StrToInt(Buffer3)].SocksInfo.Host := Buffer4;
          Pop3Client[StrToInt(Buffer3)].SocksInfo.Port := StrToInt(Buffer5);
          Pop3Client[StrToInt(Buffer3)].SocksInfo.UserID := Buffer6;
          Pop3Client[StrToInt(Buffer3)].SocksInfo.Password := Buffer7;
          if not(Buffer6 = '') AND not(Buffer7 = '') then
          Pop3Client[StrToInt(Buffer3)].SocksInfo.Authentication := saUsernamePassword
          else
          Pop3Client[StrToInt(Buffer3)].SocksInfo.Authentication := saNoAuthentication;
          if not(Buffer8 = '') then
          begin
            if StrToInt(Buffer8) = 0 then
            Pop3Client[StrToInt(Buffer3)].SocksInfo.Version := svSocks4;
            if StrToInt(Buffer8) = 1 then
            Pop3Client[StrToInt(Buffer3)].SocksInfo.Version := svSocks4A;
            if StrToInt(Buffer8) = 2 then
            Pop3Client[StrToInt(Buffer3)].SocksInfo.Version := svSocks5;
          end;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'DELETE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if StrToInt(Buffer4) >= 0 then
          Pop3Client[StrToInt(Buffer3)].Delete(StrToInt(Buffer4));
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'RESET' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          Pop3Client[StrToInt(Buffer3)].Reset;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'NOOP' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          Pop3Client[StrToInt(Buffer3)].KeepAlive;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'GETHEADER' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if Pop3UseThread[StrToInt(Buffer3)] = True then
          begin
            Pop3GetHeaderThreadNo := StrToInt(Buffer3);
            Pop3GetHeaderThreadMessage[StrToInt(Buffer3)] := Buffer4;
            Pop3GetHeaderThread[StrToInt(Buffer3)] := TVDSPop3GetHeaderThread.Create(False);
            Sleep(500);
          end
          else
          begin
            if (not(Buffer4 = '')) AND (StrToInt(Buffer4) >= 0) then
            begin
              Pop3Message[StrToInt(Buffer3)].Clear;
              Pop3Attachment[StrToInt(Buffer3)].Clear;
              Pop3Body[StrToInt(Buffer3)].Clear;
              Pop3Client[StrToInt(Buffer3)].RetrieveHeader(StrToInt(Buffer4),Pop3Message[StrToInt(Buffer3)]);
            end;
          end;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'GETMAIL' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if Pop3UseThread[StrToInt(Buffer3)] = True then
          begin
            Pop3GetMailThreadNo := StrToInt(Buffer3);
            Pop3GetMailThreadMessage[StrToInt(Buffer3)] := Buffer4;
            Pop3GetMailThread[StrToInt(Buffer3)] := TVDSPop3GetMailThread.Create(False);
            Sleep(500);
          end
          else
          begin
            if (not(Buffer4 = '')) AND (StrToInt(Buffer4) >= 0) then
            begin
              Pop3Message[StrToInt(Buffer3)].Clear;
              Pop3Attachment[StrToInt(Buffer3)].Clear;
              Pop3Body[StrToInt(Buffer3)].Clear;
              Pop3Client[StrToInt(Buffer3)].Retrieve(StrToInt(Buffer4),Pop3Message[StrToInt(Buffer3)]);

              for IntBuffer1 := 0 to Pred(Pop3Message[StrToInt(Buffer3)].MessageParts.Count) do
              begin
                if (Pop3Message[StrToInt(Buffer3)].MessageParts.Items[IntBuffer1] is TIdAttachment) then
                begin //general attachment
                  Pop3Attachment[StrToInt(Buffer3)].Add(IntToStr(IntBuffer1)+'|'+TIdAttachment(Pop3Message[StrToInt(Buffer3)].MessageParts.Items[IntBuffer1]).Filename+'|'+Pop3Message[StrToInt(Buffer3)].MessageParts[IntBuffer1].Headers.Values['Content-ID']+'|'+Pop3Message[StrToInt(Buffer3)].MessageParts[IntBuffer1].ContentType);
                end
                else
                begin //body text
                  if Pop3Message[StrToInt(Buffer3)].MessageParts.Items[IntBuffer1] is TIdText then
                  begin
                    Pop3Body[StrToInt(Buffer3)].Clear;
                    Pop3Body[StrToInt(Buffer3)].AddStrings(TIdText(Pop3Message[StrToInt(Buffer3)].MessageParts.Items[IntBuffer1]).Body);
                  end
                end;
              end;
            end;
          end;
          except
          end;
        end;
      end
{      else
      if UpperCase(Buffer2) = 'SAVEMAIL' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if (not(Buffer4 = '')) AND (StrToInt(Buffer4) >= 0) AND not(Buffer5 = '') then
          begin
            Pop3Message.Clear;
            Pop3Attachment.Clear;
            Pop3Body.Clear;

            TempStrings := TStringList.Create;
            Pop3Client.RetrieveRaw(StrToInt(Buffer4), TempStrings);
            TempStrings.SaveToFile(Buffer5);
            TempStrings.Free;
          end;
          except
          end;
        end;
      end}
      else
      if UpperCase(Buffer2) = 'SAVEATTACH' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if not(Buffer4 = '') AND not(StrToInt(Buffer4) > Pop3Message[StrToInt(Buffer3)].MessageParts.Count) AND not(Buffer5 = '') then
          TIdAttachment(Pop3Message[StrToInt(Buffer3)].MessageParts.Items[StrToInt(Buffer4)]).SaveToFile(Buffer5);
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'NEW' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if Pop3Client[StrToInt(Buffer3)].Connected = True then
          Pop3Client[StrToInt(Buffer3)].Disconnect;
          Pop3Client[StrToInt(Buffer3)].Host := '';
          Pop3Client[StrToInt(Buffer3)].Port := 110;
          Pop3Client[StrToInt(Buffer3)].UserId := '';
          Pop3Client[StrToInt(Buffer3)].Password := '';
          Pop3Client[StrToInt(Buffer3)].Port := 110;
          Pop3Body[StrToInt(Buffer3)].Clear;
          Pop3Attachment[StrToInt(Buffer3)].Clear;
          Pop3Message[StrToInt(Buffer3)].Clear;
          Pop3CurrBytes[StrToInt(Buffer3)] := 0;
          Pop3TotalBytes[StrToInt(Buffer3)] := 0;
          Pop3Client[StrToInt(Buffer3)].SocksInfo.Authentication := saNoAuthentication;
          Pop3Client[StrToInt(Buffer3)].SocksInfo.Host := '';
          Pop3Client[StrToInt(Buffer3)].SocksInfo.Password := '';
          Pop3Client[StrToInt(Buffer3)].SocksInfo.Port := 0;
          Pop3Client[StrToInt(Buffer3)].SocksInfo.UserID := '';
          Pop3Client[StrToInt(Buffer3)].SocksInfo.Version := svNoSocks;
          except
          end;
        end;
      end
  end
  else
  if UpperCase(Buffer1) = 'SMTP' then
  begin
      if UpperCase(Buffer2) = 'CREATE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          SmtpClient[StrToInt(Buffer3)] := TVDSSmtpClient.Create(Form1);
          SmtpClient[StrToInt(Buffer3)].Name := 'SMTP'+Buffer3;
          SmtpMessage[StrToInt(Buffer3)] := TIdMessage.Create(Form1);
          SmtpMessage[StrToInt(Buffer3)].Name := 'SMTPMESSAGE'+Buffer3;
          SmtpClient[StrToInt(Buffer3)].MailAgent := 'VDSIPP SMTP';
          SmtpCurrBytes[StrToInt(Buffer3)] := 0;
          SmtpTotalBytes[StrToInt(Buffer3)] := 0;
          SmtpClient[StrToInt(Buffer3)].OnDisconnected := SmtpClient[StrToInt(Buffer3)].SmtpDisconnected;
          SmtpClient[StrToInt(Buffer3)].OnWorkBegin := SmtpClient[StrToInt(Buffer3)].SmtpWorkBegin;
          SmtpClient[StrToInt(Buffer3)].OnWork := SmtpClient[StrToInt(Buffer3)].SmtpWork;
          SmtpUseThread[StrToInt(Buffer3)] := True;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'DESTROY' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          SmtpClient[StrToInt(Buffer3)].Free;
          SmtpMessage[StrToInt(Buffer3)].Free;
          SmtpCurrBytes[StrToInt(Buffer3)] := 0;
          SmtpTotalBytes[StrToInt(Buffer3)] := 0;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'AUTHENTICATE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          SmtpClient[StrToInt(Buffer3)].UserId := Buffer4;
          SmtpClient[StrToInt(Buffer3)].Password := Buffer5;
          if (not(Buffer4 = '')) AND (not(Buffer5 = '')) then
          SmtpClient[StrToInt(Buffer3)].AuthenticationType := atLogin
          else
          SmtpClient[StrToInt(Buffer3)].AuthenticationType := atNone;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'THREADS' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if UpperCase(Buffer4) = 'ON' then
          SmtpUseThread[StrToInt(Buffer3)] := True
          else
          if UpperCase(Buffer4) = 'OFF' then
          SmtpUseThread[StrToInt(Buffer3)] := False;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'CONNECT' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if SmtpUseThread[StrToInt(Buffer3)] = True then
          begin
            SmtpConnectThreadNo := StrToInt(Buffer3);
            SmtpConnectThreadHost[StrToInt(Buffer3)] := Buffer4;
            SmtpConnectThreadPort[StrToInt(Buffer3)] := Buffer5;
            SmtpConnectThread[StrToInt(Buffer3)] := TVDSSmtpConnectThread.Create(False);
            Sleep(500);
          end
          else
          begin
            if SmtpClient[StrToInt(Buffer3)].Connected then
            try
            SmtpClient[StrToInt(Buffer3)].Disconnect;
            except
            end;
            SmtpClient[StrToInt(Buffer3)].Host := Buffer4;
            if not(Buffer5 = '') then
            begin
              if StrToInt(Buffer5) >= 0 then
              SmtpClient[StrToInt(Buffer3)].Port := StrToInt(Buffer5)
              else
              SmtpClient[StrToInt(Buffer3)].Port := 25;
            end
            else
            SmtpClient[StrToInt(Buffer3)].Port := 25;

            SmtpClient[StrToInt(Buffer3)].Connect;
          end;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'DISCONNECT' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if SmtpUseThread[StrToInt(Buffer3)] = True then
          begin
            SmtpDisconnectThreadNo := StrToInt(Buffer3);
            SmtpDisconnectThread[StrToInt(Buffer3)] := TVDSSmtpDisconnectThread.Create(False);
            Sleep(500);
          end
          else
          SmtpClient[StrToInt(Buffer3)].Disconnect;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'PROXY' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          SmtpClient[StrToInt(Buffer3)].SocksInfo.Host := Buffer4;
          SmtpClient[StrToInt(Buffer3)].SocksInfo.Port := StrToInt(Buffer5);
          SmtpClient[StrToInt(Buffer3)].SocksInfo.UserID := Buffer6;
          SmtpClient[StrToInt(Buffer3)].SocksInfo.Password := Buffer7;
          if not(Buffer6 = '') AND not(Buffer7 = '') then
          SmtpClient[StrToInt(Buffer3)].SocksInfo.Authentication := saUsernamePassword
          else
          SmtpClient[StrToInt(Buffer3)].SocksInfo.Authentication := saNoAuthentication;
          if not(Buffer8 = '') then
          begin
            if StrToInt(Buffer8) = 0 then
            SmtpClient[StrToInt(Buffer3)].SocksInfo.Version := svSocks4;
            if StrToInt(Buffer8) = 1 then
            SmtpClient[StrToInt(Buffer3)].SocksInfo.Version := svSocks4A;
            if StrToInt(Buffer8) = 2 then
            SmtpClient[StrToInt(Buffer3)].SocksInfo.Version := svSocks5;
          end;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'USERAGENT' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if not(Buffer4 = '') then
          SmtpClient[StrToInt(Buffer3)].MailAgent := Buffer4;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'ATTACH' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if not(Buffer4 = '') AND FileExists(Buffer4) then
          with TIdAttachment.Create(SmtpMessage[StrToInt(Buffer3)].MessageParts, Buffer4) do
          begin
            if not(Buffer5 = '') then
            begin
              Extraheaders.Add('Content-ID: '+' <'+Buffer5+'>');
              ContentTransfer := 'base64';
            end;
            if not(Buffer6 = '') then
            ContentType := Buffer6;
          end;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'CONTENT-TYPE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if not(Buffer4 = '') then
          SmtpMessage[StrToInt(Buffer3)].ContentType := Buffer4;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'MSGID' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if not(Buffer4 = '') then
          SmtpMessage[StrToInt(Buffer3)].MsgId := Buffer4;
          except
          end;
        end;
      end
      else
      if Uppercase(Buffer2) = 'PRIORITY' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if not(Buffer4 = '') AND (StrToInt(Buffer4) > 0) AND (StrToInt(Buffer4) <= 5) then
          begin
            if StrToInt(Buffer4) = 1 then
            SmtpMessage[StrToInt(Buffer3)].Priority := mpHighest
            else
            if StrToInt(Buffer4) = 2 then
            SmtpMessage[StrToInt(Buffer3)].Priority := mpHigh
            else
            if StrToInt(Buffer4) = 3 then
            SmtpMessage[StrToInt(Buffer3)].Priority := mpNormal
            else
            if StrToInt(Buffer4) = 4 then
            SmtpMessage[StrToInt(Buffer3)].Priority := mpLow
            else
            if StrToInt(Buffer4) = 5 then
            SmtpMessage[StrToInt(Buffer3)].Priority := mpLowest;
          end;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'HEADER' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          SmtpMessage[StrToInt(Buffer3)].ExtraHeaders.Text := Buffer4;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'FROM' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if not(Buffer4 = '') then
          SmtpMessage[StrToInt(Buffer3)].From.Text := Buffer4;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'TO' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if not(Buffer4 = '') then
          SmtpMessage[StrToInt(Buffer3)].Recipients.EMailAddresses := Buffer4;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'SUBJECT' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          SmtpMessage[StrToInt(Buffer3)].Subject := Buffer4;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'BODY' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          SmtpMessage[StrToInt(Buffer3)].Body.Text := Trim(Buffer4);
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'BODYHTML' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          SmtpMessage[StrToInt(Buffer3)].Body.Text := '';
          SmtpHtmlStrings[StrToInt(Buffer3)] := TStringList.Create;
          SmtpHtmlStrings[StrToInt(Buffer3)].Add(Buffer5);
          with TidText.Create(SmtpMessage[StrToInt(Buffer3)].MessageParts, SmtpHtmlStrings[StrToInt(Buffer3)]) do
          Begin
          ContentType := 'text/plain';
          end;
          SmtpHtmlStrings[StrToInt(Buffer3)].Clear;
          SmtpHtmlStrings[StrToInt(Buffer3)].Add(Buffer4);
          with TidText.Create(SmtpMessage[StrToInt(Buffer3)].MessageParts, SmtpHtmlStrings[StrToInt(Buffer3)]) do
          Begin
          ContentType := 'text/html';
          end;
          SmtpHtmlStrings[StrToInt(Buffer3)].Free;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'CC' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          SmtpMessage[StrToInt(Buffer3)].CCList.EMailAddresses := Buffer4;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'BCC' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          SmtpMessage[StrToInt(Buffer3)].BccList.EMailAddresses := Buffer4;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'REPLYTO' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          SmtpMessage[StrToInt(Buffer3)].ReplyTo.EMailAddresses := Buffer4;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'RECEIPT' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          SmtpMessage[StrToInt(Buffer3)].ReceiptRecipient.Text := Buffer4;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'ORGANIZATION' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          SmtpMessage[StrToInt(Buffer3)].Organization := Buffer4;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'SEND' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if SmtpUseThread[StrToInt(Buffer3)] = True then
          begin
            SmtpSendThreadNo := StrToInt(Buffer3);
            SmtpSendThread[StrToInt(Buffer3)] := TVDSSmtpSendThread.Create(False);
            Sleep(500);
          end
          else
          SmtpClient[StrToInt(Buffer3)].Send(SmtpMessage[StrToInt(Buffer3)]);
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'NEW' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if SmtpClient[StrToInt(Buffer3)].Connected = True then
          SmtpClient[StrToInt(Buffer3)].Disconnect;
          SmtpClient[StrToInt(Buffer3)].Host := '';
          SmtpClient[StrToInt(Buffer3)].Port := 25;
          SmtpClient[StrToInt(Buffer3)].UserId := '';
          SmtpClient[StrToInt(Buffer3)].Password := '';
          SmtpClient[StrToInt(Buffer3)].MailAgent := 'VDSIPP SMTP';
          SmtpMessage[StrToInt(Buffer3)].Clear;
          SmtpCurrBytes[StrToInt(Buffer3)] := 0;
          SmtpTotalBytes[StrToInt(Buffer3)] := 0;
          SmtpClient[StrToInt(Buffer3)].SocksInfo.Authentication := saNoAuthentication;
          SmtpClient[StrToInt(Buffer3)].SocksInfo.Host := '';
          SmtpClient[StrToInt(Buffer3)].SocksInfo.Password := '';
          SmtpClient[StrToInt(Buffer3)].SocksInfo.Port := 0;
          SmtpClient[StrToInt(Buffer3)].SocksInfo.UserID := '';
          SmtpClient[StrToInt(Buffer3)].SocksInfo.Version := svNoSocks;
          except
          end;
        end;
      end;
  end
  else
  if UpperCase(Buffer1) = 'TCP' then
  begin
      if UpperCase(Buffer2) = 'CREATE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          //AntiFreeze.Active := False;
          TcpClient[StrToInt(Buffer3)] := TVDSTcpClient.Create(Form1);
          TcpClient[StrToInt(Buffer3)].Name := 'TCP'+Buffer3;
          TcpClient[StrToInt(Buffer3)].Port := 2;
          TcpClientTotalBytes[StrToInt(Buffer3)] := 0;
          TcpClientCurrBytes[StrToInt(Buffer3)] := 0;
          TcpClientStr[StrToInt(Buffer3)] := '';
          TcpClient[StrToInt(Buffer3)].OnDisconnected := TcpClient[StrToInt(Buffer3)].TcpClientDisconnect;
          TcpClient[StrToInt(Buffer3)].OnWorkBegin := TcpClient[StrToInt(Buffer3)].TcpWorkBegin;
          TcpClient[StrToInt(Buffer3)].OnWork := TcpClient[StrToInt(Buffer3)].TcpWork;
          TcpClientUseThread[StrToInt(Buffer3)] := True;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'DESTROY' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          TcpClient[StrToInt(Buffer3)].Free;
          TcpClientStr[StrToInt(Buffer3)] := '';
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'THREADS' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if UpperCase(Buffer4) = 'ON' then
          TcpClientUseThread[StrToInt(Buffer3)] := True
          else
          if UpperCase(Buffer4) = 'OFF' then
          TcpClientUseThread[StrToInt(Buffer3)] := False;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'CONNECT' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if TcpClientUseThread[StrToInt(Buffer3)] = True then
          begin
            TcpClientConnectThreadNo := StrToInt(Buffer3);
            TcpClientConnectThreadHost[StrToInt(Buffer3)] := Buffer4;
            TcpClientConnectThreadPort[StrToInt(Buffer3)] := Buffer5;
            TcpClientConnectThread[StrToInt(Buffer3)] := TVDSTcpConnectThread.Create(False);
            Sleep(500);
          end
          else
          begin
            if TcpClient[StrToInt(Buffer3)].Connected then
            try
            TcpClient[StrToInt(Buffer3)].Disconnect;
            except
            end;
            TcpClient[StrToInt(Buffer3)].Host := Buffer4;
            if not(Buffer5 = '') then
            begin
              if StrToInt(Buffer5) >= 0 then
              TcpClient[StrToInt(Buffer3)].Port := StrToInt(Buffer5)
              else
              TcpClient[StrToInt(Buffer3)].Port := 2;
            end
            else
            TcpClient[StrToInt(Buffer3)].Port := 2;

            TcpClient[StrToInt(Buffer3)].Connect;
          end;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'DISCONNECT' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if TcpClientUseThread[StrToInt(Buffer3)] = True then
          begin
            TcpClientDisconnectThreadNo := StrToInt(Buffer3);
            TcpClientDisconnectThread[StrToInt(Buffer3)] := TVDSTcpDisconnectThread.Create(False);
            Sleep(500);
          end
          else
          TcpClient[StrToInt(Buffer3)].Disconnect;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'PROXY' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          TcpClient[StrToInt(Buffer3)].SocksInfo.Host := Buffer4;
          TcpClient[StrToInt(Buffer3)].SocksInfo.Port := StrToInt(Buffer5);
          TcpClient[StrToInt(Buffer3)].SocksInfo.UserID := Buffer6;
          TcpClient[StrToInt(Buffer3)].SocksInfo.Password := Buffer7;
          if not(Buffer6 = '') AND not(Buffer7 = '') then
          TcpClient[StrToInt(Buffer3)].SocksInfo.Authentication := saUsernamePassword
          else
          TcpClient[StrToInt(Buffer3)].SocksInfo.Authentication := saNoAuthentication;
          if not(Buffer8 = '') then
          begin
            if StrToInt(Buffer8) = 0 then
            TcpClient[StrToInt(Buffer3)].SocksInfo.Version := svSocks4;
            if StrToInt(Buffer8) = 1 then
            TcpClient[StrToInt(Buffer3)].SocksInfo.Version := svSocks4A;
            if StrToInt(Buffer8) = 2 then
            TcpClient[StrToInt(Buffer3)].SocksInfo.Version := svSocks5;
          end;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'SEND' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if TcpClientUseThread[StrToInt(Buffer3)] = True then
          begin
            TcpClientSendThreadNo := StrToInt(Buffer3);
            TcpClientSendThreadMsg[StrToInt(Buffer3)] := Buffer4;
            TcpClientSendThread[StrToInt(Buffer3)] := TVDSTcpSendThread.Create(False);
            Sleep(500);
          end
          else
          begin
            if not(Buffer4 = '') then
            TcpClient[StrToInt(Buffer3)].WriteLn(Buffer4);
          end;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'NEW' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if TcpClient[StrToInt(Buffer3)].Connected = True then
          TcpClient[StrToInt(Buffer3)].Disconnect;
          TcpClient[StrToInt(Buffer3)].Host := '';
          TcpClient[StrToInt(Buffer3)].Port := 2;
          TcpClientTotalBytes[StrToInt(Buffer3)] := 0;
          TcpClientCurrBytes[StrToInt(Buffer3)] := 0;
          TcpClientStr[StrToInt(Buffer3)] := '';
          TcpClient[StrToInt(Buffer3)].SocksInfo.Authentication := saNoAuthentication;
          TcpClient[StrToInt(Buffer3)].SocksInfo.Host := '';
          TcpClient[StrToInt(Buffer3)].SocksInfo.Password := '';
          TcpClient[StrToInt(Buffer3)].SocksInfo.Port := 0;
          TcpClient[StrToInt(Buffer3)].SocksInfo.UserID := '';
          TcpClient[StrToInt(Buffer3)].SocksInfo.Version := svNoSocks;
          except
          end;
        end;
      end;
  end
  else
  if UpperCase(Buffer1) = 'TCP-SERVER' then
  begin
      if UpperCase(Buffer2) = 'CREATE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
        try
          TcpServer[StrToInt(Buffer3)] := TVDSTcpServer.Create(Form1);
          TcpServer[StrToInt(Buffer3)].Name := 'TCP_SERVER'+Buffer3;
          TcpServer[StrToInt(Buffer3)].Active := False;
          TcpServerThread[StrToInt(Buffer3)] := TIdThreadMgrDefault.Create(Form1);
          TcpServerThread[StrToInt(Buffer3)].Name := 'TCP_SERVERTHREAD'+Buffer3;
          TcpServer[StrToInt(Buffer3)].ThreadMgr := TcpServerThread[StrToInt(Buffer3)];
          TcpServerClientList[StrToInt(Buffer3)] := TList.Create;
          TcpServerClients[StrToInt(Buffer3)] := TStringList.Create;
          TcpServerClientInc[StrToInt(Buffer3)] := 0;
          TcpServerCurrUsrId[StrToInt(Buffer3)] := -1;
          TcpServerCurrUsrIp[StrToInt(Buffer3)] := '';
          TcpServerCurrUsrMsg[StrToInt(Buffer3)] := '';
          TcpServer[StrToInt(Buffer3)].DefaultPort := 2;
          TcpServer[StrToInt(Buffer3)].Bindings.Clear;
          TcpServerBinding[StrToInt(Buffer3)] := TcpServer[StrToInt(Buffer3)].Bindings.Add;
          TcpServerBinding[StrToInt(Buffer3)].Port := 2;
          TcpServer[StrToInt(Buffer3)].OnConnect := TcpServer[StrToInt(Buffer3)].TcpServerConnect;
          TcpServer[StrToInt(Buffer3)].OnDisconnect := TcpServer[StrToInt(Buffer3)].TcpServerDisconnect;
          TcpServer[StrToInt(Buffer3)].OnExecute := TcpServer[StrToInt(Buffer3)].TcpServerExecute;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'DESTROY' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          TcpServer[StrToInt(Buffer3)].Free;
          TcpServerThread[StrToInt(Buffer3)].Free;
          TcpServerClientList[StrToInt(Buffer3)].Free;
          TcpServerClients[StrToInt(Buffer3)].Free;
          TcpServerClientInc[StrToInt(Buffer3)] := 0;
          TcpServerCurrUsrId[StrToInt(Buffer3)] := -1;
          TcpServerCurrUsrIp[StrToInt(Buffer3)] := '';
          TcpServerCurrUsrMsg[StrToInt(Buffer3)] := '';
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'ACTIVATE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if TcpServer[StrToInt(Buffer3)].Active = True then
          try
          TcpServer[StrToInt(Buffer3)].Active := False;
          except
          end;
          if (not(Buffer4 = '')) AND (StrToInt(Buffer4) >= 0) then
          TcpServer[StrToInt(Buffer3)].DefaultPort := StrToInt(Buffer4);
          TcpServer[StrToInt(Buffer3)].Bindings.Clear;
          TcpServerBinding[StrToInt(Buffer3)] := TcpServer[StrToInt(Buffer3)].Bindings.Add;
          TcpServerBinding[StrToInt(Buffer3)].Port := StrToInt(Buffer4);
          TcpServerClientList[StrToInt(Buffer3)].Clear;
          TcpServerClients[StrToInt(Buffer3)].Clear;
          TcpServerClientInc[StrToInt(Buffer3)] := 0;
          TcpServerCurrUsrId[StrToInt(Buffer3)] := -1;
          TcpServerCurrUsrIp[StrToInt(Buffer3)] := '';
          TcpServerCurrUsrMsg[StrToInt(Buffer3)] := '';
          TcpServer[StrToInt(Buffer3)].Active := True;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'DEACTIVATE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          TcpServer[StrToInt(Buffer3)].Active := False;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'REMOVEUSER' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if not(Buffer4 = '') AND (StrToInt(Buffer4) >= 0) then
          begin
            TcpServerSimpleClient[StrToInt(Buffer3)] := TcpServerClientList[StrToInt(Buffer3)].Items[TcpServerClients[StrToInt(Buffer3)].IndexOf(Buffer4)];
            TIdPeerThread(TcpServerSimpleClient[StrToInt(Buffer3)].Thread).Connection.Disconnect;
            TcpServerClientList[StrToInt(Buffer3)].Delete(TcpServerClients[StrToInt(Buffer3)].IndexOf(IntToStr(TcpServerSimpleClient[StrToInt(Buffer3)].Index)));
            TcpServerClients[StrToInt(Buffer3)].Delete(TcpServerClients[StrToInt(Buffer3)].IndexOf(IntToStr(TcpServerSimpleClient[StrToInt(Buffer3)].Index)));
          end;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'SENDUSER' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if not(Buffer4 = '') AND (StrToInt(Buffer4) >= 0) AND not(Buffer5 = '') then
          begin
            TcpServerSimpleClient[StrToInt(Buffer3)] := TcpServerClientList[StrToInt(Buffer3)].Items[TcpServerClients[StrToInt(Buffer3)].IndexOf(Buffer4)];
            TIdPeerThread(TcpServerSimpleClient[StrToInt(Buffer3)].Thread).Connection.WriteLn(Buffer5)
          end;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'SENDALL' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          BroadCastMessage(Buffer3, Buffer4);
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'NEW' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          TcpServerClientList[StrToInt(Buffer3)].Clear;
          TcpServerClients[StrToInt(Buffer3)].Clear;
          TcpServerClientInc[StrToInt(Buffer3)] := 0;
          TcpServerCurrUsrId[StrToInt(Buffer3)] := -1;
          TcpServerCurrUsrIp[StrToInt(Buffer3)] := '';
          TcpServerCurrUsrMsg[StrToInt(Buffer3)] := '';
          TcpServer[StrToInt(Buffer3)].DefaultPort := 2;
          TcpServer[StrToInt(Buffer3)].Bindings.Clear;
          TcpServerBinding[StrToInt(Buffer3)] := TcpServer[StrToInt(Buffer3)].Bindings.Add;
          TcpServerBinding[StrToInt(Buffer3)].Port := 2;
          TcpServer[StrToInt(Buffer3)].Active := False;
          except
          end;
        end;
      end;
  end
  else
  if UpperCase(Buffer1) = 'ICMP' then
  begin
      if UpperCase(Buffer2) = 'CREATE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          IcmpClient[StrToInt(Buffer3)] := TVDSIcmpClient.Create(Form1);
          IcmpClient[StrToInt(Buffer3)].Name := 'ICMP'+Buffer3;
          IcmpClient[StrToInt(Buffer3)].ReceiveTimeout := 3000;
          IcmpClient[StrToInt(Buffer3)].TTL := 128;
          IcmpClient[StrToInt(Buffer3)].Port := 0;
          IcmpClientTotalBytes[StrToInt(Buffer3)] := 0;
          IcmpClientCurrBytes[StrToInt(Buffer3)] := 0;
          IcmpClientReplyStr[StrToInt(Buffer3)] := '';
          IcmpClient[StrToInt(Buffer3)].OnReply := IcmpClient[StrToInt(Buffer3)].ReplyMessage;
          IcmpClient[StrToInt(Buffer3)].OnWorkBegin := IcmpClient[StrToInt(Buffer3)].IcmpWorkBegin;
          IcmpClient[StrToInt(Buffer3)].OnWork := IcmpClient[StrToInt(Buffer3)].IcmpWork;
          IcmpClientUseThread[StrToInt(Buffer3)] := True;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'DESTROY' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          IcmpClient[StrToInt(Buffer3)].Free;
          IcmpClientTotalBytes[StrToInt(Buffer3)] := 0;
          IcmpClientCurrBytes[StrToInt(Buffer3)] := 0;
          IcmpClientReplyStr[StrToInt(Buffer3)] := '';
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'THREADS' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if UpperCase(Buffer4) = 'ON' then
          IcmpClientUseThread[StrToInt(Buffer3)] := True
          else
          if UpperCase(Buffer4) = 'OFF' then
          IcmpClientUseThread[StrToInt(Buffer3)] := False;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'PING' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if IcmpClientUseThread[StrToInt(Buffer3)] = True then
          begin
            IcmpClientPingThreadNo := StrToInt(Buffer3);
            IcmpClientPingThreadHost[StrToInt(Buffer3)] := Buffer4;
            IcmpClientPingThreadPort[StrToInt(Buffer3)] := Buffer5;
            IcmpClientPingThread[StrToInt(Buffer3)] := TVDSIcmpPingThread.Create(False);
            Sleep(500);
          end
          else
          begin
            IcmpClient[StrToInt(Buffer3)].Host := Buffer4;
            if not(Buffer5 = '') then
            begin
              if StrToInt(Buffer5) >= 0 then
              IcmpClient[StrToInt(Buffer3)].Port := StrToInt(Buffer5)
              else
              IcmpClient[StrToInt(Buffer3)].Port := 0;
            end
            else
            IcmpClient[StrToInt(Buffer3)].Port := 0;

            IcmpClient[StrToInt(Buffer3)].Ping;
          end;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'TIMEOUT' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if not(Buffer4 = '') AND (StrToInt(Buffer4) >= 0) then
          IcmpClient[StrToInt(Buffer3)].ReceiveTimeout := StrToInt(Buffer4);
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'TTL' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if not(Buffer4 = '') AND (StrToInt(Buffer4) >= 0) then
          IcmpClient[StrToInt(Buffer3)].TTL := StrToInt(Buffer4);
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'NEW' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          IcmpClient[StrToInt(Buffer3)].ReceiveTimeout := 3000;
          IcmpClient[StrToInt(Buffer3)].TTL := 128;
          IcmpClient[StrToInt(Buffer3)].Host := '';
          IcmpClient[StrToInt(Buffer3)].Port := 0;
          IcmpClientTotalBytes[StrToInt(Buffer3)] := 0;
          IcmpClientCurrBytes[StrToInt(Buffer3)] := 0;
          IcmpClientReplyStr[StrToInt(Buffer3)] := '';
          except
          end;
        end;
      end;
  end
  else
  if UpperCase(Buffer1) = 'NTP' then
  begin
      if UpperCase(Buffer2) = 'CREATE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          NtpClient[StrToInt(Buffer3)] := TVDSNtpClient.Create(Form1);
          NtpClient[StrToInt(Buffer3)].Name := 'NTP'+Buffer3;
          NtpClient[StrToInt(Buffer3)].Port := 37;
          NtpClientTotalBytes[StrToInt(Buffer3)] := 0;
          NtpClientCurrBytes[StrToInt(Buffer3)] := 0;
          NtpClientDateTimeStr[StrToInt(Buffer3)] := '';
          NtpClientDateTimeEnc[StrToInt(Buffer3)] := '';
          NtpClient[StrToInt(Buffer3)].OnWorkBegin := NtpClient[StrToInt(Buffer3)].NtpWorkBegin;
          NtpClient[StrToInt(Buffer3)].OnWork := NtpClient[StrToInt(Buffer3)].NtpWork;
          NtpClientUseThread[StrToInt(Buffer3)] := True;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'DESTROY' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          NtpClient[StrToInt(Buffer3)].Free;
          NtpClientTotalBytes[StrToInt(Buffer3)] := 0;
          NtpClientCurrBytes[StrToInt(Buffer3)] := 0;
          NtpClientDateTimeStr[StrToInt(Buffer3)] := '';
          NtpClientDateTimeEnc[StrToInt(Buffer3)] := '';
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'THREADS' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if UpperCase(Buffer4) = 'ON' then
          NtpClientUseThread[StrToInt(Buffer3)] := True
          else
          if UpperCase(Buffer4) = 'OFF' then
          NtpClientUseThread[StrToInt(Buffer3)] := False;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'GETTIME' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          if NtpClientUseThread[StrToInt(Buffer3)] = True then
          begin
            NtpClientGettimeThreadNo := StrToInt(Buffer3);
            NtpClientGettimeThreadHost[StrToInt(Buffer3)] := Buffer4;
            NtpClientGettimeThreadPort[StrToInt(Buffer3)] := Buffer5;
            NtpClientGettimeThread[StrToInt(Buffer3)] := TVDSNtpGettimeThread.Create(False);
            Sleep(500);
          end
          else
          begin
            try
            if not(Buffer5 = '') then
            begin
              if StrToInt(Buffer5) >= 0 then
              NtpClient[StrToInt(Buffer3)].Port := StrToInt(Buffer5)
              else
              NtpClient[StrToInt(Buffer3)].Port := 37;
            end
            else
            NtpClient[StrToInt(Buffer3)].Port := 37;
            NtpClient[StrToInt(Buffer3)].Host := Buffer4;
            NtpClientDateTimeStr[StrToInt(Buffer3)] := DateTimeToStr(NtpClient[StrToInt(Buffer3)].DateTime);
            str(StrToDateTime(NtpClientDateTimeStr[StrToInt(Buffer3)]):1:10,NtpClientDateTimeEnc[StrToInt(Buffer3)]);
            except
            NtpClientDateTimeStr[StrToInt(Buffer3)] := '';
            NtpClientDateTimeEnc[StrToInt(Buffer3)] := '';
            end;
          end;
        end;
      end
      else
        if UpperCase(Buffer2) = 'PROXY' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          NtpClient[StrToInt(Buffer3)].SocksInfo.Host := Buffer4;
          NtpClient[StrToInt(Buffer3)].SocksInfo.Port := StrToInt(Buffer5);
          NtpClient[StrToInt(Buffer3)].SocksInfo.UserID := Buffer6;
          NtpClient[StrToInt(Buffer3)].SocksInfo.Password := Buffer7;
          if not(Buffer6 = '') AND not(Buffer7 = '') then
          NtpClient[StrToInt(Buffer3)].SocksInfo.Authentication := saUsernamePassword
          else
          NtpClient[StrToInt(Buffer3)].SocksInfo.Authentication := saNoAuthentication;
          if not(Buffer8 = '') then
          begin
            if StrToInt(Buffer8) = 0 then
            NtpClient[StrToInt(Buffer3)].SocksInfo.Version := svSocks4;
            if StrToInt(Buffer8) = 1 then
            NtpClient[StrToInt(Buffer3)].SocksInfo.Version := svSocks4A;
            if StrToInt(Buffer8) = 2 then
            NtpClient[StrToInt(Buffer3)].SocksInfo.Version := svSocks5;
          end;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'TIMEOUT' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if not(Buffer4 = '') AND (StrToInt(Buffer4) >= 0) then
          NtpClient[StrToInt(Buffer3)].Timeout := StrToInt(Buffer4);
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'NEW' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          NtpClient[StrToInt(Buffer3)].Host := '';
          NtpClient[StrToInt(Buffer3)].Port := 37;
          NtpClientTotalBytes[StrToInt(Buffer3)] := 0;
          NtpClientCurrBytes[StrToInt(Buffer3)] := 0;
          NtpClientDateTimeStr[StrToInt(Buffer3)] := '';
          NtpClientDateTimeEnc[StrToInt(Buffer3)] := '';
          NtpClient[StrToInt(Buffer3)].SocksInfo.Authentication := saNoAuthentication;
          NtpClient[StrToInt(Buffer3)].SocksInfo.Host := '';
          NtpClient[StrToInt(Buffer3)].SocksInfo.Password := '';
          NtpClient[StrToInt(Buffer3)].SocksInfo.Port := 0;
          NtpClient[StrToInt(Buffer3)].SocksInfo.UserID := '';
          NtpClient[StrToInt(Buffer3)].SocksInfo.Version := svNoSocks;
          except
          end;
        end;
      end;
  end
  else
  if UpperCase(Buffer1) = 'NTP-SERVER' then
  begin
      if UpperCase(Buffer2) = 'CREATE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          NtpServer[StrToInt(Buffer3)] := TVDSNtpServer.Create(Form1);
          NtpServer[StrToInt(Buffer3)].Name := 'NTP_SERVER'+Buffer3;
          NtpServer[StrToInt(Buffer3)].Active := False;
          NtpServerThread[StrToInt(Buffer3)] := TIdThreadMgrDefault.Create(Form1);
          NtpServerThread[StrToInt(Buffer3)].Name := 'NTP_SERVERTHREAD'+Buffer3;
          NtpServer[StrToInt(Buffer3)].ThreadMgr := NtpServerThread[StrToInt(Buffer3)];
          NtpServer[StrToInt(Buffer3)].DefaultPort := 37;
          NtpServer[StrToInt(Buffer3)].Bindings.Clear;
          NtpServerBinding[StrToInt(Buffer3)] := NtpServer[StrToInt(Buffer3)].Bindings.Add;
          NtpServerBinding[StrToInt(Buffer3)].Port := 37;
          NtpServer[StrToInt(Buffer3)].OnDisconnect := NtpServer[StrToInt(Buffer3)].NtpServerRequest;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'DESTROY' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          NtpServer[StrToInt(Buffer3)].Free;
          NtpServerThread[StrToInt(Buffer3)].Free;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'ACTIVATE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if NtpServer[StrToInt(Buffer3)].Active = True then
          try
          NtpServer[StrToInt(Buffer3)].Active := False;
          except
          end;
          if (not(Buffer4 = '')) AND (StrToInt(Buffer4) >= 0) then
          NtpServer[StrToInt(Buffer3)].DefaultPort := StrToInt(Buffer4);
          NtpServer[StrToInt(Buffer3)].Bindings.Clear;
          NtpServerBinding[StrToInt(Buffer3)] := NtpServer[StrToInt(Buffer3)].Bindings.Add;
          NtpServerBinding[StrToInt(Buffer3)].Port := StrToInt(Buffer4);
          NtpServer[StrToInt(Buffer3)].Active := True;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'DEACTIVATE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          NtpServer[StrToInt(Buffer3)].Active := False;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'NEW' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          NtpServer[StrToInt(Buffer3)].DefaultPort := 37;
          NtpServer[StrToInt(Buffer3)].Bindings.Clear;
          NtpServerBinding[StrToInt(Buffer3)] := NtpServer[StrToInt(Buffer3)].Bindings.Add;
          NtpServerBinding[StrToInt(Buffer3)].Port := 37;
          NtpServer[StrToInt(Buffer3)].Active := False;
          except
          end;
        end;
      end;
  end
  else
  if UpperCase(Buffer1) = 'WHOIS' then
  begin
      if UpperCase(Buffer2) = 'CREATE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          WhoisClient[StrToInt(Buffer3)] := TVDSWhoisClient.Create(Form1);
          WhoisClient[StrToInt(Buffer3)].Name := 'WHOIS'+Buffer3;
          WhoisClient[StrToInt(Buffer3)].Host := '';
          WhoisClient[StrToInt(Buffer3)].Port := 43;
          WhoisClientTotalBytes[StrToInt(Buffer3)] := 0;
          WhoisClientCurrBytes[StrToInt(Buffer3)] := 0;
          WhoisClientStr[StrToInt(Buffer3)] := '';
          WhoisClient[StrToInt(Buffer3)].OnWorkBegin := WhoisClient[StrToInt(Buffer3)].WhoisWorkBegin;
          WhoisClient[StrToInt(Buffer3)].OnWork := WhoisClient[StrToInt(Buffer3)].WhoisWork;
          WhoisClientUseThread[StrToInt(Buffer3)] := True;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'DESTROY' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          WhoisClient[StrToInt(Buffer3)].Free;
          WhoisClientTotalBytes[StrToInt(Buffer3)] := 0;
          WhoisClientCurrBytes[StrToInt(Buffer3)] := 0;
          WhoisClientStr[StrToInt(Buffer3)] := '';
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'SERVER' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          WhoisClient[StrToInt(Buffer3)].Host := Buffer4;
          if not(Buffer5 = '') then
          begin
            if StrToInt(Buffer5) >= 0 then
            WhoisClient[StrToInt(Buffer3)].Port := StrToInt(Buffer5)
            else
            WhoisClient[StrToInt(Buffer3)].Port := 43;
          end
          else
          WhoisClient[StrToInt(Buffer3)].Port := 43;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'THREADS' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if UpperCase(Buffer4) = 'ON' then
          WhoisClientUseThread[StrToInt(Buffer3)] := True
          else
          if UpperCase(Buffer4) = 'OFF' then
          WhoisClientUseThread[StrToInt(Buffer3)] := False;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'PROXY' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          WhoisClient[StrToInt(Buffer3)].SocksInfo.Host := Buffer4;
          WhoisClient[StrToInt(Buffer3)].SocksInfo.Port := StrToInt(Buffer5);
          WhoisClient[StrToInt(Buffer3)].SocksInfo.UserID := Buffer6;
          WhoisClient[StrToInt(Buffer3)].SocksInfo.Password := Buffer7;
          if not(Buffer6 = '') AND not(Buffer7 = '') then
          WhoisClient[StrToInt(Buffer3)].SocksInfo.Authentication := saUsernamePassword
          else
          WhoisClient[StrToInt(Buffer3)].SocksInfo.Authentication := saNoAuthentication;
          if not(Buffer8 = '') then
          begin
            if StrToInt(Buffer8) = 0 then
            WhoisClient[StrToInt(Buffer3)].SocksInfo.Version := svSocks4;
            if StrToInt(Buffer8) = 1 then
            WhoisClient[StrToInt(Buffer3)].SocksInfo.Version := svSocks4A;
            if StrToInt(Buffer8) = 2 then
            WhoisClient[StrToInt(Buffer3)].SocksInfo.Version := svSocks5;
          end;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'QUERY' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          if WhoisClientUseThread[StrToInt(Buffer3)] = True then
          begin
            WhoisClientQueryThreadNo := StrToInt(Buffer3);
            WhoisClientQueryThreadStr[StrToInt(Buffer3)] := Buffer4;
            WhoisClientQueryThread[StrToInt(Buffer3)] := TVDSWhoisQueryThread.Create(False);
            Sleep(500);
          end
          else
          begin
            try
            if not(Buffer4 = '') then
            WhoisClientStr[StrToInt(Buffer3)] := WhoisClient[StrToInt(Buffer3)].WhoIs(Buffer4);
            except
            end;
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'NEW' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          WhoisClient[StrToInt(Buffer3)].Host := '';
          WhoisClient[StrToInt(Buffer3)].Port := 43;
          WhoisClientTotalBytes[StrToInt(Buffer3)] := 0;
          WhoisClientCurrBytes[StrToInt(Buffer3)] := 0;
          WhoisClientStr[StrToInt(Buffer3)] := '';
          WhoisClient[StrToInt(Buffer3)].SocksInfo.Authentication := saNoAuthentication;
          WhoisClient[StrToInt(Buffer3)].SocksInfo.Host := '';
          WhoisClient[StrToInt(Buffer3)].SocksInfo.Password := '';
          WhoisClient[StrToInt(Buffer3)].SocksInfo.Port := 0;
          WhoisClient[StrToInt(Buffer3)].SocksInfo.UserID := '';
          WhoisClient[StrToInt(Buffer3)].SocksInfo.Version := svNoSocks;
          except
          end;
        end;
      end;
  end
  else
  if UpperCase(Buffer1) = 'WHOIS-SERVER' then
  begin
      if UpperCase(Buffer2) = 'CREATE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          WhoisServer[StrToInt(Buffer3)] := TVDSWhoisServer.Create(Form1);
          WhoisServer[StrToInt(Buffer3)].Name := 'WHOIS_SERVER'+Buffer3;
          WhoisServer[StrToInt(Buffer3)].Active := False;
          WhoisServerThread[StrToInt(Buffer3)] := TIdThreadMgrDefault.Create(Form1);
          WhoisServerThread[StrToInt(Buffer3)].Name := 'WHOIS_SERVERTHREAD'+Buffer3;
          WhoisServer[StrToInt(Buffer3)].ThreadMgr := WhoisServerThread[StrToInt(Buffer3)];
          WhoisServer[StrToInt(Buffer3)].DefaultPort := 43;
          WhoisServer[StrToInt(Buffer3)].Bindings.Clear;
          WhoisServerBinding[StrToInt(Buffer3)] := WhoisServer[StrToInt(Buffer3)].Bindings.Add;
          WhoisServerBinding[StrToInt(Buffer3)].Port := 43;
          WhoisServer[StrToInt(Buffer3)].OnCommandLookup := WhoisServer[StrToInt(Buffer3)].WhoisServerCommandLookup;
          WhoisServerStr[StrToInt(Buffer3)] := '';
          WhoisServerSimpleClient[StrToInt(Buffer3)] := TIdPeerThread(nil);
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'DESTROY' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          WhoisServer[StrToInt(Buffer3)].Free;
          WhoisServerThread[StrToInt(Buffer3)].Free;
          WhoisServerStr[StrToInt(Buffer3)] := '';
          WhoisServerSimpleClient[StrToInt(Buffer3)] := TIdPeerThread(nil);
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'ACTIVATE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if WhoisServer[StrToInt(Buffer3)].Active = True then
          try
          WhoisServer[StrToInt(Buffer3)].Active := False;
          except
          end;
          if (not(Buffer4 = '')) AND (StrToInt(Buffer4) >= 0) then
          WhoisServer[StrToInt(Buffer3)].DefaultPort := StrToInt(Buffer4);
          WhoisServer[StrToInt(Buffer3)].Bindings.Clear;
          WhoisServerBinding[StrToInt(Buffer3)] := WhoisServer[StrToInt(Buffer3)].Bindings.Add;
          WhoisServerBinding[StrToInt(Buffer3)].Port := StrToInt(Buffer4);
          WhoisServer[StrToInt(Buffer3)].Active := True;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'DEACTIVATE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          WhoisServer[StrToInt(Buffer3)].Active := False;
          WhoisServerStr[StrToInt(Buffer3)] := '';
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'REPLY' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          WhoisServerSimpleClient[StrToInt(Buffer3)].Connection.WriteLn(Buffer4);
          WhoisServerSimpleClient[StrToInt(Buffer3)].Connection.Disconnect;
          WhoisServerSimpleClient[StrToInt(Buffer3)] := TIdPeerThread(nil);
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'NEW' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          WhoisServer[StrToInt(Buffer3)].DefaultPort := 43;
          WhoisServer[StrToInt(Buffer3)].Bindings.Clear;
          WhoisServerBinding[StrToInt(Buffer3)] := WhoisServer[StrToInt(Buffer3)].Bindings.Add;
          WhoisServerBinding[StrToInt(Buffer3)].Port := 43;
          WhoisServerStr[StrToInt(Buffer3)] := '';
          WhoisServerSimpleClient[StrToInt(Buffer3)] := TIdPeerThread(nil);
          WhoisServer[StrToInt(Buffer3)].Active := False;
          except
          end;
        end;
      end;
  end
  else
  if UpperCase(Buffer1) = 'ECHO' then
  begin
      if UpperCase(Buffer2) = 'CREATE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          EchoClient[StrToInt(Buffer3)] := TVDSEchoClient.Create(Form1);
          EchoClient[StrToInt(Buffer3)].Name := 'ECHO'+Buffer3;
          EchoClient[StrToInt(Buffer3)].Host := '';
          EchoClient[StrToInt(Buffer3)].Port := 7;
          EchoClientTotalBytes[StrToInt(Buffer3)] := 0;
          EchoClientCurrBytes[StrToInt(Buffer3)] := 0;
          EchoClientStr[StrToInt(Buffer3)] := '';
          EchoClientTime[StrToInt(Buffer3)] := '';
          EchoClient[StrToInt(Buffer3)].OnDisconnected := EchoClient[StrToInt(Buffer3)].EchoDisconnected;
          EchoClient[StrToInt(Buffer3)].OnWorkBegin := EchoClient[StrToInt(Buffer3)].EchoWorkBegin;
          EchoClient[StrToInt(Buffer3)].OnWork := EchoClient[StrToInt(Buffer3)].EchoWork;
          EchoClientUseThread[StrToInt(Buffer3)] := True;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'DESTROY' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          EchoClient[StrToInt(Buffer3)].Free;
          EchoClientTotalBytes[StrToInt(Buffer3)] := 0;
          EchoClientCurrBytes[StrToInt(Buffer3)] := 0;
          EchoClientStr[StrToInt(Buffer3)] := '';
          EchoClientTime[StrToInt(Buffer3)] := '';
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'THREADS' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if UpperCase(Buffer4) = 'ON' then
          EchoClientUseThread[StrToInt(Buffer3)] := True
          else
          if UpperCase(Buffer4) = 'OFF' then
          EchoClientUseThread[StrToInt(Buffer3)] := False;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'CONNECT' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if EchoClientUseThread[StrToInt(Buffer3)] = True then
          begin
            EchoClientConnectThreadHost[StrToInt(Buffer3)] := Buffer4;
            EchoClientConnectThreadPort[StrToInt(Buffer3)] := Buffer5;
            EchoClientConnectThreadNo := StrToInt(Buffer3);
            EchoClientConnectThread[StrToInt(Buffer3)] := TVDSEchoConnectThread.Create(False);
            Sleep(500);
          end
          else
          begin
            EchoClient[StrToInt(Buffer3)].Host := Buffer4;
            if not(Buffer5 = '') then
            begin
              if StrToInt(Buffer5) >= 0 then
              EchoClient[StrToInt(Buffer3)].Port := StrToInt(Buffer5)
              else
              EchoClient[StrToInt(Buffer3)].Port := 7;
            end
            else
            EchoClient[StrToInt(Buffer3)].Port := 7;
            EchoClient[StrToInt(Buffer3)].Connect;
          end;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'PROXY' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          EchoClient[StrToInt(Buffer3)].SocksInfo.Host := Buffer4;
          EchoClient[StrToInt(Buffer3)].SocksInfo.Port := StrToInt(Buffer5);
          EchoClient[StrToInt(Buffer3)].SocksInfo.UserID := Buffer6;
          EchoClient[StrToInt(Buffer3)].SocksInfo.Password := Buffer7;
          if not(Buffer6 = '') AND not(Buffer7 = '') then
          EchoClient[StrToInt(Buffer3)].SocksInfo.Authentication := saUsernamePassword
          else
          EchoClient[StrToInt(Buffer3)].SocksInfo.Authentication := saNoAuthentication;
          if not(Buffer8 = '') then
          begin
            if StrToInt(Buffer8) = 0 then
            EchoClient[StrToInt(Buffer3)].SocksInfo.Version := svSocks4;
            if StrToInt(Buffer8) = 1 then
            EchoClient[StrToInt(Buffer3)].SocksInfo.Version := svSocks4A;
            if StrToInt(Buffer8) = 2 then
            EchoClient[StrToInt(Buffer3)].SocksInfo.Version := svSocks5;
          end;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'DISCONNECT' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if EchoClientUseThread[StrToInt(Buffer3)] = True then
          begin
            EchoClientDisconnectThreadNo := StrToInt(Buffer3);
            EchoClientDisconnectThread[StrToInt(Buffer3)] := TVDSEchoDisconnectThread.Create(False);
            Sleep(500);
          end
          else
          EchoClient[StrToInt(Buffer3)].Disconnect;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'ECHOREQUEST' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if EchoClientUseThread[StrToInt(Buffer3)] = True then
          begin
            EchoClientRequestThreadNo := StrToInt(Buffer3);
            EchoClientRequestThreadStr[StrToInt(Buffer3)] := Buffer4;
            EchoClientRequestThread[StrToInt(Buffer3)] := TVDSEchoRequestThread.Create(False);
            Sleep(500);
          end
          else
          begin
            if not(Buffer4 = '') then
            EchoClientStr[StrToInt(Buffer3)] := EchoClient[StrToInt(Buffer3)].Echo(Buffer4);
            EchoClientTime[StrToInt(Buffer3)] := IntToStr(EchoClient[StrToInt(Buffer3)].EchoTime);
          end;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'NEW' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          EchoClient[StrToInt(Buffer3)].Host := '';
          EchoClient[StrToInt(Buffer3)].Port := 7;
          EchoClientTotalBytes[StrToInt(Buffer3)] := 0;
          EchoClientCurrBytes[StrToInt(Buffer3)] := 0;
          EchoClientStr[StrToInt(Buffer3)] := '';
          EchoClientTime[StrToInt(Buffer3)] := '';
          EchoClient[StrToInt(Buffer3)].SocksInfo.Authentication := saNoAuthentication;
          EchoClient[StrToInt(Buffer3)].SocksInfo.Host := '';
          EchoClient[StrToInt(Buffer3)].SocksInfo.Password := '';
          EchoClient[StrToInt(Buffer3)].SocksInfo.Port := 0;
          EchoClient[StrToInt(Buffer3)].SocksInfo.UserID := '';
          EchoClient[StrToInt(Buffer3)].SocksInfo.Version := svNoSocks;
          except
          end;
        end;
      end;
  end
  else
  if UpperCase(Buffer1) = 'ECHO-SERVER' then
  begin
      if UpperCase(Buffer2) = 'CREATE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          EchoServer[StrToInt(Buffer3)] := TVDSEchoServer.Create(Form1);
          EchoServer[StrToInt(Buffer3)].Name := 'ECHO_SERVER'+Buffer3;
          EchoServer[StrToInt(Buffer3)].Active := False;
          EchoServerThread[StrToInt(Buffer3)] := TIdThreadMgrDefault.Create(Form1);
          EchoServerThread[StrToInt(Buffer3)].Name := 'ECHO_SERVERTHREAD'+Buffer3;
          EchoServer[StrToInt(Buffer3)].ThreadMgr := EchoServerThread[StrToInt(Buffer3)];
          EchoServer[StrToInt(Buffer3)].DefaultPort := 7;
          EchoServer[StrToInt(Buffer3)].Bindings.Clear;
          EchoServerBinding[StrToInt(Buffer3)] := EchoServer[StrToInt(Buffer3)].Bindings.Add;
          EchoServerBinding[StrToInt(Buffer3)].Port := 7;
          EchoServer[StrToInt(Buffer3)].OnConnect := EchoServer[StrToInt(Buffer3)].EchoServerConnect;
          EchoServer[StrToInt(Buffer3)].OnDisconnect := EchoServer[StrToInt(Buffer3)].EchoServerDisconnect;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'DESTROY' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          EchoServer[StrToInt(Buffer3)].Free;
          EchoServerThread[StrToInt(Buffer3)].Free;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'ACTIVATE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if EchoServer[StrToInt(Buffer3)].Active = True then
          try
          EchoServer[StrToInt(Buffer3)].Active := False;
          except
          end;
          if (not(Buffer4 = '')) AND (StrToInt(Buffer4) >= 0) then
          EchoServer[StrToInt(Buffer3)].DefaultPort := StrToInt(Buffer4);
          EchoServer[StrToInt(Buffer3)].Bindings.Clear;
          EchoServerBinding[StrToInt(Buffer3)] := EchoServer[StrToInt(Buffer3)].Bindings.Add;
          EchoServerBinding[StrToInt(Buffer3)].Port := StrToInt(Buffer4);
          EchoServer[StrToInt(Buffer3)].Active := True;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'DEACTIVATE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          EchoServer[StrToInt(Buffer3)].Active := False;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'NEW' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          EchoServer[StrToInt(Buffer3)].DefaultPort := 7;
          EchoServer[StrToInt(Buffer3)].Bindings.Clear;
          EchoServerBinding[StrToInt(Buffer3)] := EchoServer[StrToInt(Buffer3)].Bindings.Add;
          EchoServerBinding[StrToInt(Buffer3)].Port := 7;
          except
          end;
        end;
      end;
  end
  else
  if UpperCase(Buffer1) = 'UDP' then
  begin
      if UpperCase(Buffer2) = 'CREATE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          UdpClient[StrToInt(Buffer3)] := TVDSUdpClient.Create(Form1);
          UdpClient[StrToInt(Buffer3)].Port := 8090;
          UdpClientTotalBytes[StrToInt(Buffer3)] := 0;
          UdpClientCurrBytes[StrToInt(Buffer3)] := 0;
          UdpClientStr[StrToInt(Buffer3)] := '';
          UdpClient[StrToInt(Buffer3)].Active := True;
          UdpClient[StrToInt(Buffer3)].OnWorkBegin := UdpClient[StrToInt(Buffer3)].UdpWorkBegin;
          UdpClient[StrToInt(Buffer3)].OnWork := UdpClient[StrToInt(Buffer3)].UdpWork;
          UdpClientUseThread[StrToInt(Buffer3)] := True;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'DESTROY' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          UdpClient[StrToInt(Buffer3)].Active := False;
          UdpClient[StrToInt(Buffer3)].Free;
          UdpClientTotalBytes[StrToInt(Buffer3)] := 0;
          UdpClientCurrBytes[StrToInt(Buffer3)] := 0;
          UdpClientStr[StrToInt(Buffer3)] := '';
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'THREADS' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if UpperCase(Buffer4) = 'ON' then
          UdpClientUseThread[StrToInt(Buffer3)] := True
          else
          if UpperCase(Buffer4) = 'OFF' then
          UdpClientUseThread[StrToInt(Buffer3)] := False;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'SERVER' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          UdpClient[StrToInt(Buffer3)].Host := Buffer4;
          if not(Buffer5 = '') then
          begin
            if StrToInt(Buffer5) >= 0 then
            UdpClient[StrToInt(Buffer3)].Port := StrToInt(Buffer5)
            else
            UdpClient[StrToInt(Buffer3)].Port := 8090;
          end
          else
          UdpClient[StrToInt(Buffer3)].Port := 8090;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'SEND' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if UdpClientUseThread[StrToInt(Buffer3)] = True then
          begin
            UdpClientSendThreadNo := StrToInt(Buffer3);
            UdpClientSendThreadStr[StrToInt(Buffer3)] := Buffer4;
            UdpClientSendThread[StrToInt(Buffer3)] := TVDSUdpSendThread.Create(False);
            Sleep(500);
          end
          else
          begin
            if not(Buffer4 = '') then
            UdpClient[StrToInt(Buffer3)].Send(Buffer4);
          end;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'NEW' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          UdpClient[StrToInt(Buffer3)].Host := '';
          UdpClient[StrToInt(Buffer3)].Port := 2;
          UdpClientTotalBytes[StrToInt(Buffer3)] := 0;
          UdpClientCurrBytes[StrToInt(Buffer3)] := 0;
          UdpClientStr[StrToInt(Buffer3)] := '';
          except
          end;
        end;
      end;
  end
  else
  if UpperCase(Buffer1) = 'UDP-SERVER' then
  begin
      if UpperCase(Buffer2) = 'CREATE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          UdpServer[StrToInt(Buffer3)] := TVDSUdpServer.Create(Form1);
          UdpServer[StrToInt(Buffer3)].Name := 'UDP_SERVER'+Buffer3;
          UdpServer[StrToInt(Buffer3)].Active := False;
          UdpServer[StrToInt(Buffer3)].DefaultPort := 8090;
          UdpServer[StrToInt(Buffer3)].Bindings.Clear;
          UdpServerBinding[StrToInt(Buffer3)] := UdpServer[StrToInt(Buffer3)].Bindings.Add;
          UdpServerBinding[StrToInt(Buffer3)].Port := 8090;
          UdpServer[StrToInt(Buffer3)].OnUDPRead := UdpServer[StrToInt(Buffer3)].UDPServerMessage;
          UdpServerCurrUsrIp[StrToInt(Buffer3)] := '';
          UdpServerCurrUsrPort[StrToInt(Buffer3)] := '';
          UdpServerCurrUserMsg[StrToInt(Buffer3)] := '';
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'DESTROY' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          UdpServer[StrToInt(Buffer3)].Free;
          UdpServerCurrUsrIp[StrToInt(Buffer3)] := '';
          UdpServerCurrUsrPort[StrToInt(Buffer3)] := '';
          UdpServerCurrUserMsg[StrToInt(Buffer3)] := '';
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'ACTIVATE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if UdpServer[StrToInt(Buffer3)].Active = True then
          try
          UdpServer[StrToInt(Buffer3)].Active := False;
          except
          end;
          if (not(Buffer4 = '')) AND (StrToInt(Buffer4) >= 0) then
          UdpServer[StrToInt(Buffer3)].DefaultPort := StrToInt(Buffer4);
          UdpServer[StrToInt(Buffer3)].Bindings.Clear;
          UdpServerBinding[StrToInt(Buffer3)] := UdpServer[StrToInt(Buffer3)].Bindings.Add;
          UdpServerBinding[StrToInt(Buffer3)].Port := StrToInt(Buffer4);
          UdpServer[StrToInt(Buffer3)].Active := True;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'DEACTIVATE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          UdpServer[StrToInt(Buffer3)].Active := False;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'SENDUSER' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if not(Buffer4 = '') AND not(Buffer5 = '') then
          begin
            UdpServerCurrUsr[StrToInt(Buffer3)].SendTo(Buffer4, StrToInt(Buffer5), Buffer6[1], Length(Buffer6));
          end;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'NEW' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          UdpServer[StrToInt(Buffer3)].DefaultPort := 8090;
          UdpServer[StrToInt(Buffer3)].Bindings.Clear;
          UdpServerBinding[StrToInt(Buffer3)] := UdpServer[StrToInt(Buffer3)].Bindings.Add;
          UdpServerBinding[StrToInt(Buffer3)].Port := 8090;
          UdpServer[StrToInt(Buffer3)].Active := False;
          UdpServerCurrUsrIp[StrToInt(Buffer3)] := '';
          UdpServerCurrUsrPort[StrToInt(Buffer3)] := '';
          UdpServerCurrUserMsg[StrToInt(Buffer3)]  := '';
          except
          end;
        end;
      end;
  end
  else
  Errorcode := 1;
  { end user-defined code }
  Result := errorcode;
end;

function FuncProc(Args: PChar): PChar;
var
  Buffer1, Buffer2, Buffer3, Buffer4, Buffer5: string;
  TempBuffer1: string;
  TempStrings: TStrings;
  Variable1, Variable2, Variable3: string;
  resultbuf: string;
  resbuf: Array[0..999999] of Char;
begin
  { don't zeroise errorcode in case it is set by previous function }
  for p := 0 to pred(buf_size) do
    parambuf[p] := Args[p];             {copy parameter string into buffer}
  p := 0;                                 {set pointer for NextParam}
  { start user-defined code }

  Buffer1 := NextParam;
  Buffer2 := NextParam;
  Buffer3 := NextParam;
  Buffer4 := NextParam;
  Buffer5 := NextParam;

  if UpperCase(Buffer1) = 'HTTP' then
  begin
      if UpperCase(Buffer2) = 'CONTENT' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          resultbuf := HttpText[StrToInt(Buffer3)];
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'CONTENT-TYPE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          resultbuf := HttpClient[StrToInt(Buffer3)].Response.ContentType;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'CONTENT-LENGTH' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          resultbuf := IntToStr(HttpClient[StrToInt(Buffer3)].Response.ContentLength);
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'RETURNCODE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          resultbuf := IntToStr(HttpClient[StrToInt(Buffer3)].ResponseCode);
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'TRANSFERBYTES' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          resultbuf := IntToStr(HttpCurrBytes[StrToInt(Buffer3)]);
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'TOTAL-BYTES' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          resultbuf := IntToStr(HttpTotalBytes[StrToInt(Buffer3)]);
          except
          end;
        end;
      end;
  end
  else
  if UpperCase(Buffer1) = 'FTP' then
  begin
      if UpperCase(Buffer2) = 'VIEWLOG' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          resultbuf := FtpLogList[StrToInt(Buffer3)].Text;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'CURRENTDIR' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          resultbuf := FtpClient[StrToInt(Buffer3)].RetrieveCurrentDir;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'FILELIST' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          resultbuf := FtpFileList[StrToInt(Buffer3)].GetText;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'FILEINFO' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if not(Buffer4 = '') AND not(Buffer5 = '') then
          begin
            TempBuffer1 := GetNameFromDirLine(Buffer4, IsDirectory, IsLink);

            Variable1 := '';
            Variable2 := '';
            Variable3 := '';
            if (Copy(Buffer5, 1, 1) = 'N') then
            Variable1 := TempBuffer1
            else
            if (Copy(Buffer5, 2, 1) = 'N') then
            Variable2 := TempBuffer1
            else
            if (Copy(Buffer5, 3, 1) = 'N') then
            Variable3 := TempBuffer1;

            if (Copy(Buffer5, 1, 1)  = 'T') then
            begin
              if IsDirectory = True then
              Variable1 := '0'
              else
              if IsLink = True then
              Variable1 := '1'
              else
              Variable1 := '2';
            end
            else
            if (Copy(Buffer5, 2, 1)  = 'T') then
            begin
              if IsDirectory = True then
              Variable1 := '0'
              else
              if IsLink = True then
              Variable1 := '1'
              else
              Variable1 := '2';
            end
            else
            if (Copy(Buffer5, 3, 1)  = 'T') then
            begin
              if IsDirectory = True then
              Variable1 := '0'
              else
              if IsLink = True then
              Variable1 := '1'
              else
              Variable1 := '2';
            end;

            if (Copy(Buffer5, 1, 1) = 'S') then
            begin
              if FtpClient[StrToInt(Buffer3)].Size(TempBuffer1) > -1 then
              Variable1 := IntToStr(FtpClient[StrToInt(Buffer3)].Size(TempBuffer1))
              else
              Variable1 := '0';
            end
            else
            if (Copy(Buffer5, 2, 1) = 'S') then
            begin
              if FtpClient[StrToInt(Buffer3)].Size(TempBuffer1) > -1 then
              Variable2 := IntToStr(FtpClient[StrToInt(Buffer3)].Size(TempBuffer1))
              else
              Variable2 := '0';
            end
            else
            if (Copy(Buffer5, 3, 1) = 'S') then
            begin
              if FtpClient[StrToInt(Buffer3)].Size(TempBuffer1) > -1 then
              Variable3 := IntToStr(FtpClient[StrToInt(Buffer3)].Size(TempBuffer1))
              else
              Variable3 := '0';
            end;

            if Variable1 = '' then
            begin
            end
            else
            if Variable2 = '' then
            begin
              resultbuf := Variable1;
            end
            else
            if Variable3 = '' then
            begin
              resultbuf := Variable1+'|'+Variable2;
            end
            else
            begin
              resultbuf := Variable1+'|'+Variable2+'|'+Variable3;
            end;
          end;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'CONNECTED' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if FtpClient[StrToInt(Buffer3)].Connected = True then
          resultbuf := '1'
          else
          resultbuf := '0';
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'RETURNCODE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          resultbuf := IntToStr(FtpClient[StrToInt(Buffer3)].ResultNo);
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'TRANSFERBYTES' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          resultbuf := IntToStr(FtpCurrBytes[StrToInt(Buffer3)]);
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'TOTAL-BYTES' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          resultbuf := IntToStr(FtpTotalBytes[StrToInt(Buffer3)]);
          except
          end;
        end;
      end;
  end
  else
  if UpperCase(Buffer1) = 'POP3' then
  begin
      if UpperCase(Buffer2) = 'CONNECTED' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if Pop3Client[StrToInt(Buffer3)].Connected = True then
          resultbuf := '1'
          else
          resultbuf := '0';
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'MSGCOUNT' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          resultbuf := IntToStr(Pop3Client[StrToInt(Buffer3)].CheckMessages);
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'FROM' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if (Pop3Message[StrToInt(Buffer3)].From.Name = '') AND (Pop3Message[StrToInt(Buffer3)].From.Address = '') then
          resultbuf := ''
          else
          if (Pop3Message[StrToInt(Buffer3)].From.Name = '') AND not(Pop3Message[StrToInt(Buffer3)].From.Address = '') then
          resultbuf := Pop3Message[StrToInt(Buffer3)].From.Address
          else
          if not(Pop3Message[StrToInt(Buffer3)].From.Name = '') AND not(Pop3Message[StrToInt(Buffer3)].From.Address = '') then
          resultbuf := Pop3Message[StrToInt(Buffer3)].From.Name+' <'+Pop3Message[StrToInt(Buffer3)].From.Address+'>';
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'TO' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          resultbuf := Pop3Message[StrToInt(Buffer3)].Recipients.EMailAddresses;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'BODY' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          resultbuf := Pop3Body[StrToInt(Buffer3)].Text;
          except;
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'ATTACHMENTS' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          resultbuf := Trim(Pop3Attachment[StrToInt(Buffer3)].Text);
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'SUBJECT' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          resultbuf := Pop3Message[StrToInt(Buffer3)].Subject;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'CC' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          resultbuf := Pop3Message[StrToInt(Buffer3)].CCList.EMailAddresses;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'DATE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          resultbuf := DateTimeToStr(Pop3Message[StrToInt(Buffer3)].Date);
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'RECEIPT' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          resultbuf := Pop3Message[StrToInt(Buffer3)].ReceiptRecipient.Text;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'PRIORITY' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          resultbuf := IntToStr(Ord(Pop3Message[StrToInt(Buffer3)].Priority) + 1)
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'REPLYTO' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          resultbuf := Pop3Message[StrToInt(Buffer3)].ReplyTo.EMailAddresses;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'MSGSIZE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if not(Buffer4 = '') AND (StrToInt(Buffer4) >= 0) then
          resultbuf := IntToStr(Pop3Client[StrToInt(Buffer3)].RetrieveMsgSize(StrToInt(Buffer4)))
          else
          resultbuf := '';
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'MAILBOXSIZE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          resultbuf := IntToStr(Pop3Client[StrToInt(Buffer3)].RetrieveMailBoxSize);
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'HEADER' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if not(Buffer4 = '') then
          begin
            TempStrings := TStringList.Create;
            Pop3Message[StrToInt(Buffer3)].Headers.Extract(Buffer4, TempStrings);
            resultbuf := TempStrings.Text;
            TempStrings.Free;
          end
          else
          resultbuf := '';
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'MSGID' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          resultbuf := Pop3Message[StrToInt(Buffer3)].MsgId;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'CONTENT-TYPE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          resultbuf := Pop3Message[StrToInt(Buffer3)].ContentType;
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'RETURNCODE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          resultbuf := IntToStr(Pop3Client[StrToInt(Buffer3)].ResultNo);
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'TRANSFERBYTES' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          resultbuf := IntToStr(Pop3CurrBytes[StrToInt(Buffer3)]);
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'TOTAL-BYTES' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          resultbuf := IntToStr(Pop3TotalBytes[StrToInt(Buffer3)]);
          except
          end;
        end;
      end;
  end
  else
  if UpperCase(Buffer1) = 'SMTP' then
  begin
      if UpperCase(Buffer2) = 'CONNECTED' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if SmtpClient[StrToInt(Buffer3)].Connected = True then
          resultbuf := '1'
          else
          resultbuf := '0';
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'RETURNCODE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          resultbuf := IntToStr(SmtpClient[StrToInt(Buffer3)].ResultNo);
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'TRANSFERBYTES' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          resultbuf := IntToStr(SmtpCurrBytes[StrToInt(Buffer3)]);
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'TOTAL-BYTES' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          resultbuf := IntToStr(SmtpTotalBytes[StrToInt(Buffer3)]);
          except
          end;
        end;
      end;
  end
  else
  if UpperCase(Buffer1) = 'TCP' then
  begin
      if UpperCase(Buffer2) = 'CONNECTED' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if TcpClient[StrToInt(Buffer3)].Connected = True then
          resultbuf := '1'
          else
          resultbuf := '0';
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'MESSAGE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          resultbuf := TcpClientStr[StrToInt(Buffer3)];
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'TRANSFERBYTES' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          resultbuf := IntToStr(TcpClientCurrBytes[StrToInt(Buffer3)]);
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'TOTAL-BYTES' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          resultbuf := IntToStr(TcpClientTotalBytes[StrToInt(Buffer3)]);
          except
          end;
        end;
      end;
  end
  else
  if UpperCase(Buffer1) = 'TCP-SERVER' then
  begin
      if UpperCase(Buffer2) = 'ACTIVE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if TcpServer[StrToInt(Buffer3)].Active = True then
          resultbuf := '1'
          else
          resultbuf := '0';
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'MESSAGE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          resultbuf := TcpServerCurrUsrMsg[StrToInt(Buffer3)];
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'USERID' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          resultbuf := IntToStr(TcpServerCurrUsrId[StrToInt(Buffer3)]);
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'USERIP' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          resultbuf := TcpServerCurrUsrIp[StrToInt(Buffer3)];
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'USERCOUNT' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          resultbuf := IntToStr(TcpServerClients[StrToInt(Buffer3)].Count);
          except
          end;
        end;
      end;
  end
  else
  if UpperCase(Buffer1) = 'ICMP' then
  begin
      if UpperCase(Buffer2) = 'MESSAGE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          if IcmpClientReplyStr[StrToInt(Buffer3)] = '' then
          resultbuf := 'Unknown host'
          else
          resultbuf := IcmpClientReplyStr[StrToInt(Buffer3)];
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'TRANSFERBYTES' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          resultbuf := IntToStr(IcmpClientCurrBytes[StrToInt(Buffer3)]);
          except
          end;
        end;
      end
      else
      if UpperCase(Buffer2) = 'TOTAL-BYTES' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          resultbuf := IntToStr(IcmpClientTotalBytes[StrToInt(Buffer3)]);
          except
          end;
        end;
      end;
  end
  else
  if UpperCase(Buffer1) = 'NTP' then
  begin
       if UpperCase(Buffer2) = 'DATETIME' then
       begin
         if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
         begin
           try
           if NtpClientDateTimeStr[StrToInt(Buffer3)] = '12/30/1899' then
           resultbuf := ''
           else
           resultbuf := NtpClientDateTimeStr[StrToInt(Buffer3)];
           except
           end;
         end;
       end
       else
       if UpperCase(Buffer2) = 'RAWDATETIME' then
       begin
         if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
         begin
           try
           if NtpClientDateTimeEnc[StrToInt(Buffer3)] = '0.0000000000' then
           resultbuf := ''
           else
           resultbuf := NtpClientDateTimeEnc[StrToInt(Buffer3)];
           except
           end;
         end;
       end
       else
       if UpperCase(Buffer2) = 'TRANSFERBYTES' then
       begin
         if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
         begin
           try
           resultbuf := IntToStr(NtpClientCurrBytes[StrToInt(Buffer3)]);
           except
           end;
         end;
       end
       else
       if UpperCase(Buffer2) = 'TOTAL-BYTES' then
       begin
         if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
         begin
           try
           resultbuf := IntToStr(NtpClientTotalBytes[StrToInt(Buffer3)]);
           except
           end;
         end;
       end;
  end
  else
  if UpperCase(Buffer1) = 'NTP-SERVER' then
  begin
       if UpperCase(Buffer2) = 'ACTIVE' then
       begin
         if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
         begin
           try
           if NtpServer[StrToInt(Buffer3)].Active = True then
           resultbuf := '1'
           else
           resultbuf := '0';
           except
           end;
         end;
       end;
  end
  else
  if UpperCase(Buffer1) = 'WHOIS' then
  begin
       if UpperCase(Buffer2) = 'MESSAGE' then
       begin
         if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
         begin
           try
           resultbuf := WhoisClientStr[StrToInt(Buffer3)];
           except
           end;
         end;
       end
       else
       if UpperCase(Buffer2) = 'TRANSFERBYTES' then
       begin
         if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
         begin
           try
           resultbuf := IntToStr(WhoisClientCurrBytes[StrToInt(Buffer3)]);
           except
           end;
         end;
       end
       else
       if UpperCase(Buffer2) = 'TOTAL-BYTES' then
       begin
         if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
         begin
           try
           resultbuf := IntToStr(WhoisClientTotalBytes[StrToInt(Buffer3)]);
           except
           end;
         end;
       end;
  end
  else
  if UpperCase(Buffer1) = 'WHOIS-SERVER' then
  begin
       if UpperCase(Buffer2) = 'ACTIVE' then
       begin
         if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
         begin
           try
           if WhoisServer[StrToInt(Buffer3)].Active = True then
           resultbuf := '1'
           else
           resultbuf := '0';
           except
           end;
         end;
       end
       else
       if UpperCase(Buffer2) = 'MESSAGE' then
       begin
         if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
         begin
           try
           resultbuf := WhoisServerStr[StrToInt(Buffer3)];
           except
           end;
         end;
       end
       else
       if UpperCase(Buffer2) = 'USERIP' then
       begin
         if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
         begin
           try
           resultbuf := WhoisServerSimpleClient[StrToInt(Buffer3)].Connection.Binding.PeerIP;
           except
           end;
         end;
       end;
  end
  else
  if UpperCase(Buffer1) = 'ECHO' then
  begin
       if UpperCase(Buffer2) = 'CONNECTED' then
       begin
         if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
         begin
           try
           if EchoClient[StrToInt(Buffer3)].Connected = True then
           resultbuf := '1'
           else
           resultbuf := '0';
           except
           end;
         end;
       end
       else
       if UpperCase(Buffer2) = 'MESSAGE' then
       begin
         if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
         begin
           try
           resultbuf := EchoClientStr[StrToInt(Buffer3)];
           except
           end;
         end;
       end
       else
       if UpperCase(Buffer2) = 'ECHOTIME' then
       begin
         if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
         begin
           try
           resultbuf := EchoClientTime[StrToInt(Buffer3)];
           except
           end;
         end;
       end
       else
       if UpperCase(Buffer2) = 'TRANSFERBYTES' then
       begin
         if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
         begin
           try
           resultbuf := IntToStr(EchoClientCurrBytes[StrToInt(Buffer3)]);
           except
           end;
         end;
       end
       else
       if UpperCase(Buffer2) = 'TOTAL-BYTES' then
       begin
         if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
         begin
           try
           resultbuf := IntToStr(EchoClientTotalBytes[StrToInt(Buffer3)]);
           except
           end;
         end;
       end;
  end
  else
  if UpperCase(Buffer1) = 'ECHO-SERVER' then
  begin
       if UpperCase(Buffer2) = 'ACTIVE' then
       begin
         if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
         begin
           try
           if EchoServer[StrToInt(Buffer3)].Active = True then
           resultbuf := '1'
           else
           resultbuf := '0';
           except
           end;
         end;
       end;
  end
  else
  if UpperCase(Buffer1) = 'UDP' then
  begin
      if UpperCase(Buffer2) = 'MESSAGE' then
      begin
        if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
        begin
          try
          resultbuf := UdpClientStr[StrToInt(Buffer3)];
          except
          end;
        end;
      end
       else
       if UpperCase(Buffer2) = 'TRANSFERBYTES' then
       begin
         if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
         begin
           try
           resultbuf := IntToStr(UdpClientCurrBytes[StrToInt(Buffer3)]);
           except
           end;
         end;
       end
       else
       if UpperCase(Buffer2) = 'TOTAL-BYTES' then
       begin
         if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
         begin
           try
           resultbuf := IntToStr(UdpClientTotalBytes[StrToInt(Buffer3)]);
           except
           end;
         end;
       end;
  end
  else
  if UpperCase(Buffer1) = 'UDP-SERVER' then
  begin
       if UpperCase(Buffer2) = 'ACTIVE' then
       begin
         if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
         begin
           try
           if UdpServer[StrToInt(Buffer3)].Active = True then
           resultbuf := '1'
           else
           resultbuf := '0';
           except
           end;
         end;
       end
       else
       if UpperCase(Buffer2) = 'USERIP' then
       begin
         if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
         begin
           try
           resultbuf := UdpServerCurrUsrIp[StrToInt(Buffer3)];
           except
           end;
         end;
       end
       else
       if UpperCase(Buffer2) = 'USERPORT' then
       begin
         if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
         begin
           try
           resultbuf := UdpServerCurrUsrPort[StrToInt(Buffer3)];
           except
           end;
         end;
       end
       else
       if UpperCase(Buffer2) = 'MESSAGE' then
       begin
         if (not(Buffer3 = '')) AND (StrToInt(Buffer3) > 0) then
         begin
           try
           resultbuf := UdpServerCurrUserMsg[StrToInt(Buffer3)];
           except
           end;
         end;
       end;
  end
  else
  Errorcode := 7;
  StrCopy(resbuf,PChar(resultbuf));
  { end user-defined code }
  Result := resbuf;
end;

function StatProc: Integer;
{ this function requires no modification }
begin
  Result := errorcode;
end;

{HTTP CLIENT EVENTS}

procedure TVDSHttpGetThread.Execute;
var
ThreadNo: Integer;
begin
  try
  ThreadNo := HttpGetThreadNo;
  HttpText[ThreadNo] := HttpClient[ThreadNo].Get(HttpGetThreadUrl[ThreadNo]);
  exteventproc(eventproc)(PChar('HTTP'+IntToStr(ThreadNo)+'ONGETDONE'));
  HttpGetThread[ThreadNo].Terminate;
  except
  end;
end;

procedure TVDSHttpGetHeaderThread.Execute;
var
ThreadNo: Integer;
begin
  try
  ThreadNo := HttpGetHeaderThreadNo;
  try
  HttpClient[ThreadNo].Head(HttpGetHeaderThreadUrl[ThreadNo]);
  except
  end;
  exteventproc(eventproc)(PChar('HTTP'+IntToStr(ThreadNo)+'ONGETHEADERDONE'));
  HttpGetHeaderThread[ThreadNo].Terminate;
  except
  end;
end;

procedure TVDSHttpPostThread.Execute;
var
ThreadNo: Integer;
StringStream: array[1..99] of TStringStream;
MemStream: array[1..99] of TMemoryStream;
StringList: array[1..99] of TStringList;
begin
  try
  ThreadNo := HttpPostThreadNo;

  StringStream[ThreadNo] := TStringStream.Create('');
  if FileExists(HttpPostThreadFile[ThreadNo]) then
  begin
    MemStream[ThreadNo] := TMemoryStream.Create;
    MemStream[ThreadNo].LoadFromFile(HttpPostThreadFile[ThreadNo]);
    HttpClient[ThreadNo].Post(HttpPostThreadUrl[ThreadNo], MemStream[ThreadNo], StringStream[ThreadNo]);
    MemStream[ThreadNo].Free;
  end
  else
  begin
    StringList[ThreadNo] := TStringList.Create;
    StringList[ThreadNo].Text := HttpPostThreadFile[ThreadNo];
    HttpClient[ThreadNo].Post(HttpPostThreadUrl[ThreadNo], StringList[ThreadNo], StringStream[ThreadNo]);
    StringList[ThreadNo].Free;
  end;
  HttpText[ThreadNo] := StringStream[ThreadNo].DataString;
  StringStream[ThreadNo].Free;
  HttpClient[ThreadNo].ProtocolVersion := HttpProtocolVersion[ThreadNo];

  exteventproc(eventproc)(PChar('HTTP'+IntToStr(ThreadNo)+'ONPOSTDONE'));
  HttpPostThread[ThreadNo].Terminate;
  except
  end;
end;

procedure TVDSHttpDownloadThread.Execute;
var
ThreadNo: Integer;
FileStream : array[1..99] of TFileStream;
begin
  try
  ThreadNo := HttpDownloadThreadNo;
  FileStream[ThreadNo] := TFileStream.Create(HttpDownloadThreadFile[ThreadNo], fmCreate or fmOpenWrite and fmShareDenyNone);
  HttpClient[ThreadNo].Get(HttpDownloadThreadUrl[ThreadNo],FileStream[ThreadNo]);
  FileStream[ThreadNo].Free;
  exteventproc(eventproc)(PChar('HTTP'+IntToStr(ThreadNo)+'ONDOWNLOADDONE'));
  HttpDownloadThread[ThreadNo].Terminate;
  except
  end;
end;

procedure TVDSHttpClient.HTTPWorkBegin(Sender: TObject; AWorkMode: TWorkMode; const AWorkCountMax: Integer);
begin
  HttpTotalBytes[StrToInt(Copy(Name,5,2))] := 0;
  HttpCurrBytes[StrToInt(Copy(Name,5,2))] := 0;
  HttpTotalBytes[StrToInt(Copy(Name,5,2))] := AWorkcountMax;
end;

procedure TVDSHttpClient.HTTPWork(Sender: TObject; AWorkMode: TWorkMode; const AWorkCount: Integer);
begin
  HttpCurrBytes[StrToInt(Copy(Name,5,2))] := AWorkCount;
end;

{HTTP CLIENT EVENTS}

{FTP CLIENT EVENTS}

procedure TVDSFtpLog.FtpLogDebugLogItem(ASender: TComponent; var AText: String);
begin
  try
  FtpLogList[StrToInt(Copy(Name,4,2))].Add(AText);
  except
  end;
end;

procedure TVDSFtpConnectThread.Execute;
var
ThreadNo: Integer;
begin
  try
  ThreadNo := FtpConnectThreadNo;

  if FtpClient[ThreadNo].Connected then
  try
  FtpClient[ThreadNo].Abort;
  FtpClient[ThreadNo].Quit;
  except
  end;
  FtpClient[ThreadNo].Host := FtpConnectThreadHost[ThreadNo];
  if not(FtpConnectThreadPort[ThreadNo] = '') then
  begin
    if StrToInt(FtpConnectThreadPort[ThreadNo]) >= 0 then
    FtpClient[ThreadNo].Port := StrToInt(FtpConnectThreadPort[ThreadNo])
    else
    FtpClient[ThreadNo].Port := 21;
  end
  else
  FtpClient[ThreadNo].Port := 21;

  FtpClient[ThreadNo].Connect;
  if FtpClient[ThreadNo].Connected = True then
  begin
    //FtpClient[ThreadNo].List(FtpFileList[ThreadNo]);
    exteventproc(eventproc)(PChar('FTP'+IntToStr(ThreadNo)+'ONCONNECT'));
  end;
  FtpConnectThread[ThreadNo].Terminate;
  except
  end;
end;

procedure TVDSFtpDisconnectThread.Execute;
var
ThreadNo: Integer;
begin
  try
  ThreadNo := FtpDisconnectThreadNo;
  FtpClient[ThreadNo].Disconnect;
  FtpDisconnectThread[ThreadNo].Terminate;
  except
  end;
end;

procedure TVDSFtpClient.FtpDisconnected(Sender: TObject);
begin
  if FtpUseThread[StrToInt(Copy(Name,4,2))] = True then
  exteventproc(eventproc)(PChar('FTP'+Copy(Name,4,2)+'ONDISCONNECT'));
end;

procedure TVDSFtpRefreshThread.Execute;
var
ThreadNo: Integer;
begin
  try
  ThreadNo := FtpRefreshThreadNo;
  FtpClient[ThreadNo].List(FtpFileList[ThreadNo]);
  exteventproc(eventproc)(PChar('FTP'+IntToStr(ThreadNo)+'ONREFRESHDONE'));

  FtpRefreshThread[ThreadNo].Terminate;
  except
  end;
end;

procedure TVDSFtpGetFileThread.Execute;
var
ThreadNo: Integer;
begin
  try
  ThreadNo := FtpGetFileThreadNo;

  if not(FtpGetFileThreadLocalFile[ThreadNo] = '') AND not(FtpGetFileThreadNetWorkFile[ThreadNo] = '') then
  begin
    FtpClient[ThreadNo].Get(FtpGetFileThreadLocalFile[ThreadNo], FtpGetFileThreadNetworkFile[ThreadNo], True);
    exteventproc(eventproc)(PChar('FTP'+IntToStr(ThreadNo)+'ONGETFILEDONE'));
  end;
  FtpGetFileThread[ThreadNo].Terminate;
  except
  end;
end;

procedure TVDSFtpPutFileThread.Execute;
var
ThreadNo: Integer;
begin
  try
  ThreadNo := FtpPutFileThreadNo;
  if not(FtpPutFileThreadLocalFile[ThreadNo] = '') AND not(FtpPutFileThreadNetworkFile[ThreadNo] = '') then
  begin
    FtpClient[ThreadNo].Put(FtpPutFileThreadLocalFile[ThreadNo], FtpPutFileThreadNetworkFile[ThreadNo], False);
    exteventproc(eventproc)(PChar('FTP'+IntToStr(ThreadNo)+'ONPUTFILEDONE'));
  end;
  FtpPutFileThread[ThreadNo].Terminate;
  except
  end;
end;

procedure TVDSFtpClient.FTPWorkBegin(Sender: TObject; AWorkMode: TWorkMode; const AWorkCountMax: Integer);
begin
  FtpTotalBytes[StrToInt(Copy(Name,4,2))] := 0;
  FtpCurrBytes[StrToInt(Copy(Name,4,2))] := 0;
  FtpTotalBytes[StrToInt(Copy(Name,4,2))] := AWorkcountMax;
end;

procedure TVDSFtpClient.FTPWork(Sender: TObject; AWorkMode: TWorkMode; const AWorkCount: Integer);
begin
  FtpCurrBytes[StrToInt(Copy(Name,4,2))] := AWorkCount;
end;

{FTP CLIENT EVENTS}

{POP3 CLIENT EVENTS}

procedure TVDSPop3ConnectThread.Execute;
var
ThreadNo: Integer;
begin
  try
  ThreadNo := Pop3ConnectThreadNo;

  if Pop3Client[ThreadNo].Connected then
  try
  Pop3Client[ThreadNo].Disconnect;
  except
  end;
  Pop3Client[ThreadNo].Host := Pop3ConnectThreadHost[ThreadNo];
  if not(Pop3ConnectThreadPort[ThreadNo] = '') then
  begin
    if StrToInt(Pop3ConnectThreadPort[ThreadNo]) >= 0 then
    Pop3Client[ThreadNo].Port := StrToInt(Pop3ConnectThreadPort[ThreadNo])
  else
    Pop3Client[ThreadNo].Port := 110;
  end
  else
  Pop3Client[ThreadNo].Port := 110;

  Pop3Client[ThreadNo].Connect;

  if Pop3Client[ThreadNo].Connected = True then
  begin
    exteventproc(eventproc)(PChar('POP3'+IntToStr(ThreadNo)+'ONCONNECT'));
  end;
  Pop3ConnectThread[ThreadNo].Terminate;
  except
  end;
end;

procedure TVDSPop3DisconnectThread.Execute;
var
ThreadNo: Integer;
begin
  try
  ThreadNo := Pop3DisconnectThreadNo;
  Pop3Client[ThreadNo].Disconnect;
  Pop3DisconnectThread[ThreadNo].Terminate;
  except
  end;
end;

procedure TVDSPop3Client.Pop3Disconnected(Sender: TObject);
begin
  try
  if Pop3UseThread[StrToInt(Copy(Name,5,2))] = True then
  exteventproc(eventproc)(PChar('POP3'+Copy(Name,5,2)+'ONDISCONNECT'));
  except
  end;
end;

procedure TVDSPop3GetHeaderThread.Execute;
var
ThreadNo: Integer;
begin
  try
  ThreadNo := Pop3GetHeaderThreadNo;
  if (not(Pop3GetHeaderThreadMessage[ThreadNo] = '')) AND (StrToInt(Pop3GetHeaderThreadMessage[ThreadNo]) >= 0) then
  begin
    Pop3Message[ThreadNo].Clear;
    Pop3Attachment[ThreadNo].Clear;
    Pop3Body[ThreadNo].Clear;
    Pop3Client[ThreadNo].RetrieveHeader(StrToInt(Pop3GetHeaderThreadMessage[ThreadNo]),Pop3Message[ThreadNo]);
    exteventproc(eventproc)(PChar('POP3'+IntToStr(ThreadNo)+'ONGETHEADERDONE'));
  end;
  except
  end;
end;

procedure TVDSPop3GetMailThread.Execute;
var
ThreadNo: Integer;
IntBuffer1: Integer;
begin
  try
  ThreadNo := Pop3GetMailThreadNo;

  if (not(Pop3GetMailThreadMessage[ThreadNo] = '')) AND (StrToInt(Pop3GetMailThreadMessage[ThreadNo]) >= 0) then
  begin
    Pop3Message[ThreadNo].Clear;
    Pop3Attachment[ThreadNo].Clear;
    Pop3Body[ThreadNo].Clear;
    Pop3Client[ThreadNo].Retrieve(StrToInt(Pop3GetMailThreadMessage[ThreadNo]),Pop3Message[ThreadNo]);

    for IntBuffer1 := 0 to Pred(Pop3Message[ThreadNo].MessageParts.Count) do
    begin
      if (Pop3Message[ThreadNo].MessageParts.Items[IntBuffer1] is TIdAttachment) then
      begin //general attachment
        Pop3Attachment[ThreadNo].Add(IntToStr(IntBuffer1)+'|'+TIdAttachment(Pop3Message[ThreadNo].MessageParts.Items[IntBuffer1]).Filename+'|'+Pop3Message[ThreadNo].MessageParts[IntBuffer1].Headers.Values['Content-ID']+'|'+Pop3Message[ThreadNo].MessageParts[IntBuffer1].ContentType);
      end
      else
      begin //body text
        if Pop3Message[ThreadNo].MessageParts.Items[IntBuffer1] is TIdText then
        begin
          Pop3Body[ThreadNo].Clear;
          Pop3Body[ThreadNo].AddStrings(TIdText(Pop3Message[ThreadNo].MessageParts.Items[IntBuffer1]).Body);
        end
      end;
    end;
  exteventproc(eventproc)(PChar('POP3'+IntToStr(ThreadNo)+'ONGETMAILDONE'));
  end;
  except
  end;
end;

procedure TVDSPop3Client.Pop3WorkBegin(Sender: TObject; AWorkMode: TWorkMode; const AWorkCountMax: Integer);
begin
  Pop3TotalBytes[StrToInt(Copy(Name,5,2))] := 0;
  Pop3CurrBytes[StrToInt(Copy(Name,5,2))] := 0;
  Pop3TotalBytes[StrToInt(Copy(Name,5,2))] := AWorkcountMax;
end;

procedure TVDSPop3Client.Pop3Work(Sender: TObject; AWorkMode: TWorkMode; const AWorkCount: Integer);
begin
  Pop3CurrBytes[StrToInt(Copy(Name,5,2))] := AWorkCount;
end;

{POP3 CLIENT EVENTS}

{SMTP CLIENT EVENTS}

procedure TVDSSmtpConnectThread.Execute;
var
ThreadNo: Integer;
begin
  try
  ThreadNo := SmtpConnectThreadNo;
  if SmtpClient[ThreadNo].Connected then
  try
  SmtpClient[ThreadNo].Disconnect;
  except
  end;
  SmtpClient[ThreadNo].Host := SmtpConnectThreadHost[ThreadNo];
  if not(SmtpConnectThreadPort[ThreadNo] = '') then
  begin
    if StrToInt(SmtpConnectThreadPort[ThreadNo]) >= 0 then
    SmtpClient[ThreadNo].Port := StrToInt(SmtpConnectThreadPort[ThreadNo])
    else
    SmtpClient[ThreadNo].Port := 25;
  end
  else
  SmtpClient[ThreadNo].Port := 25;

  SmtpClient[ThreadNo].Connect;
  if SmtpClient[ThreadNo].Connected = True then
  begin
    exteventproc(eventproc)(PChar('SMTP'+IntToStr(ThreadNo)+'ONCONNECT'));
  end;
  SmtpConnectThread[ThreadNo].Terminate;
  except
  end;
end;

procedure TVDSSmtpDisconnectThread.Execute;
var
ThreadNo: Integer;
begin
  try
  ThreadNo := SmtpDisconnectThreadNo;
  SmtpClient[ThreadNo].Disconnect;
  SmtpDisconnectThread[ThreadNo].Terminate;
  except
  end;
end;

procedure TVDSSmtpClient.SmtpDisconnected(Sender: TObject);
begin
  try
  if SmtpUseThread[StrToInt(Copy(Name,5,2))] = True then
  exteventproc(eventproc)(PChar('SMTP'+Copy(Name,5,2)+'ONDISCONNECT'));
  except
  end;
end;

procedure TVDSSmtpSendThread.Execute;
var
ThreadNo: Integer;
begin
  try
  ThreadNo := SmtpSendThreadNo;
  SmtpClient[ThreadNo].Send(SmtpMessage[ThreadNo]);
  SmtpSendThread[ThreadNo].Terminate;

  exteventproc(eventproc)(PChar('SMTP'+IntToStr(ThreadNo)+'ONSENDDONE'));
  except
  end;
end;

procedure TVDSSmtpClient.SmtpWorkBegin(Sender: TObject; AWorkMode: TWorkMode; const AWorkCountMax: Integer);
begin
  SmtpTotalBytes[StrToInt(Copy(Name,5,2))] := 0;
  SmtpCurrBytes[StrToInt(Copy(Name,5,2))] := 0;
  SmtpTotalBytes[StrToInt(Copy(Name,5,2))] := AWorkcountMax;
end;

procedure TVDSSmtpClient.SmtpWork(Sender: TObject; AWorkMode: TWorkMode; const AWorkCount: Integer);
begin
  SmtpCurrBytes[StrToInt(Copy(Name,5,2))] := AWorkCount;
end;

{SMTP CLIENT EVENTS}

{TCP CLIENT EVENTS}

procedure TVDSTCPConnectThread.Execute;
var
ThreadNo: Integer;
begin
  try
  ThreadNo := TcpClientConnectThreadNo;
  if TcpClient[ThreadNo].Connected then
  try
  TcpClient[ThreadNo].Disconnect;
  except
  end;
  TcpClient[ThreadNo].Host := TcpClientConnectThreadHost[ThreadNo];
  if not(TcpClientConnectThreadPort[ThreadNo] = '') then
  begin
    if StrToInt(TcpClientConnectThreadPort[ThreadNo]) >= 0 then
    TcpClient[ThreadNo].Port := StrToInt(TcpClientConnectThreadPort[ThreadNo])
    else
    TcpClient[ThreadNo].Port := 2;
  end
  else
  TcpClient[ThreadNo].Port := 2;

  TcpClient[ThreadNo].Connect;
  
  if TcpClient[ThreadNo].Connected = True then
  begin
    exteventproc(eventproc)(PChar('TCP'+IntToStr(ThreadNo)+'ONCONNECT'));
  end;
  TcpClientConnectThread[ThreadNo].Terminate;
  except
  end;
end;

procedure TVDSTcpClientTimer.TimerEvent(Sender: TObject);
var
TCPClientInteger: Integer;
begin
TCPClientInteger := 1;
repeat
  try
  if TcpClient[TCPClientInteger].Connected = False then
    exit;
  TcpClientStr[TCPClientInteger] := TcpClient[TCPClientInteger].ReadLn('', 5);
  if not(TcpClientStr[TCPClientInteger] = '') then
  begin
    if TcpClientUseThread[TCPClientInteger] = True then
    exteventproc(eventproc)(PChar('TCP'+IntToStr(TCPClientInteger)+'ONMESSAGE'));
  end
  except
  end;
TCPClientInteger := TCPClientInteger + 1;
until TCPClientInteger = 100;
end;

procedure TVDSTCPDisconnectThread.Execute;
var
ThreadNo: Integer;
begin
  try
  ThreadNo := TcpClientDisconnectThreadNo;
  TcpClient[ThreadNo].Disconnect;
  TcpClientDisconnectThread[ThreadNo].Terminate;
  except
  end;
end;

procedure TVDSTCPClient.TcpClientDisconnect(Sender: TObject);
begin
  try
  if TcpClientUseThread[StrToInt(Copy(Name,4,2))] = True then
  exteventproc(eventproc)(PChar('TCP'+Copy(Name,4,2)+'ONDISCONNECT'));
  except
  end;
end;

procedure TVDSTcpSendThread.Execute;
var
ThreadNo: Integer;
begin
  ThreadNo := TcpClientSendThreadNo;
  if not(TcpClientSendThreadMsg[ThreadNo] = '') then
  TcpClient[ThreadNo].WriteLn(TcpClientSendThreadMsg[ThreadNo]);
  TcpClientSendThread[ThreadNo].Terminate;

  exteventproc(eventproc)(PChar('TCP'+IntToStr(ThreadNo)+'ONSENDDONE'));
end;

procedure TVDSTcpClient.TcpWorkBegin(Sender: TObject; AWorkMode: TWorkMode; const AWorkCountMax: Integer);
begin
  TcpClientTotalBytes[StrToInt(Copy(Name,4,2))] := 0;
  TcpClientCurrBytes[StrToInt(Copy(Name,4,2))] := 0;
  TcpClientTotalBytes[StrToInt(Copy(Name,4,2))] := AWorkcountMax;
end;

procedure TVDSTcpClient.TcpWork(Sender: TObject; AWorkMode: TWorkMode; const AWorkCount: Integer);
begin
  TcpClientCurrBytes[StrToInt(Copy(Name,4,2))] := AWorkCount;
end;

{TCP CLIENT EVENTS}

{TCP SERVER EVENTS}

procedure TVDSTCPServer.TcpServerConnect(AThread: TIdPeerThread);
var
TcpServerSimpleClient: array[1..99] of TSimpleClient;
begin
  try
  TcpServerSimpleClient[StrToInt(Copy(Name,11,2))] := TSimpleClient.Create;
  TcpServerSimpleClient[StrToInt(Copy(Name,11,2))].Index := TcpServerClientInc[StrToInt(Copy(Name,11,2))];
  TcpServerClientInc[StrToInt(Copy(Name,11,2))] := TcpServerClientInc[StrToInt(Copy(Name,11,2))] + 1;
  TcpServerSimpleClient[StrToInt(Copy(Name,11,2))].IP :=  AThread.Connection.Binding.PeerIP;
  TcpServerSimpleClient[StrToInt(Copy(Name,11,2))].Thread := AThread;
  TcpServerClients[StrToInt(Copy(Name,11,2))].Add(IntToStr(TcpServerSimpleClient[StrToInt(Copy(Name,11,2))].Index));

  TcpServerCurrUsrId[StrToInt(Copy(Name,11,2))] := TcpServerSimpleClient[StrToInt(Copy(Name,11,2))].Index;
  TcpServerCurrUsrIp[StrToInt(Copy(Name,11,2))] := TcpServerSimpleClient[StrToInt(Copy(Name,11,2))].IP;
  TcpServerCurrUsrMsg[StrToInt(Copy(Name,11,2))] := '';

  AThread.Data := TcpServerSimpleClient[StrToInt(Copy(Name,11,2))];
  TcpServerClientList[StrToInt(Copy(Name,11,2))].Add(TcpServerSimpleClient[StrToInt(Copy(Name,11,2))]);
  exteventproc(eventproc)(PChar('TCP-SERVER'+Copy(Name,11,2)+'ONCONNECT'));
  except
  end;
end;

procedure TVDSTCPServer.TcpServerDisconnect(AThread: TIdPeerThread);
var
TcpServerSimpleClient: array[1..99] of TSimpleClient;
begin
  try
  TcpServerSimpleClient[StrToInt(Copy(Name,11,2))] := Pointer(AThread.Data);
  TcpServerClientList[StrToInt(Copy(Name,11,2))].Delete(TcpServerClients[StrToInt(Copy(Name,11,2))].IndexOf(IntToStr(TcpServerSimpleClient[StrToInt(Copy(Name,11,2))].Index)));

  TcpServerCurrUsrId[StrToInt(Copy(Name,11,2))] := TcpServerSimpleClient[StrToInt(Copy(Name,11,2))].Index;
  TcpServerCurrUsrIp[StrToInt(Copy(Name,11,2))] := TcpServerSimpleClient[StrToInt(Copy(Name,11,2))].IP;
  TcpServerCurrUsrMsg[StrToInt(Copy(Name,11,2))] := '';

  TcpServerClients[StrToInt(Copy(Name,11,2))].Delete(TcpServerClients[StrToInt(Copy(Name,11,2))].IndexOf(IntToStr(TcpServerSimpleClient[StrToInt(Copy(Name,11,2))].Index)));
  TcpServerSimpleClient[StrToInt(Copy(Name,11,2))].Free;
  AThread.Data := nil;
  exteventproc(eventproc)(PChar('TCP-SERVER'+Copy(Name,11,2)+'ONDISCONNECT'));
  except
  end;
end;

procedure TVDSTCPServer.TcpServerExecute(AThread: TIdPeerThread);
var
  TcpServerSimpleClient: array[1..99] of TSimpleClient;
  Msg: String;
begin
  try
{ Get the text sent from the client }
  Msg := AThread.Connection.ReadLn('', 5);
  TcpServerSimpleClient[StrToInt(Copy(Name,11,2))] := Pointer(AThread.Data);
  if not(Trim(Msg) = '') then
  begin
    TcpServerCurrUsrId[StrToInt(Copy(Name,11,2))] := TcpServerSimpleClient[StrToInt(Copy(Name,11,2))].Index;
    TcpServerCurrUsrIp[StrToInt(Copy(Name,11,2))] := TcpServerSimpleClient[StrToInt(Copy(Name,11,2))].IP;
    TcpServerCurrUsrMsg[StrToInt(Copy(Name,11,2))] := Msg;

    exteventproc(eventproc)(PChar('TCP-SERVER'+Copy(Name,11,2)+'ONMESSAGE'));
  end;
  except
  end;
end;

procedure BroadcastMessage(Name: String; Input: String);
var
  TcpServerSimpleClient: array[1..99] of TSimpleClient;
  Msg    : String;
  Count  : Integer;
  //List   : TList;
begin
  Msg := Input;
  //List := TcpServer.Threads.LockList;
  TcpServer[StrToInt(Name)].Threads.LockList;
  try
    for Count := 0 to TcpServerClients[StrToInt(Name)].Count -1 do
    try
    TcpServerSimpleClient[StrToInt(Name)] := TcpServerClientList[StrToInt(Name)].Items[Count];
    TIdPeerThread(TcpServerSimpleClient[StrToInt(Name)].Thread).Connection.WriteLn(Msg);
    except
    TIdPeerThread(TcpServerClientList[StrToInt(Name)].Items[Count]).Stop;
    end;
  finally
    TcpServer[StrToInt(Name)].Threads.UnlockList;
  end;
end;

{TCP SERVER EVENTS}

{ICMP CLIENT EVENTS}

procedure TVDSIcmpClient.ReplyMessage(ASender: TComponent; const ReplyStatus: TReplyStatus);
begin
  try
  IcmpClientReplyStr[StrToInt(Copy(Name,5,2))] := Format('Reply from %s: bytes=%d time=%dms TTL=%d',
   [ReplyStatus.FromIpAddress, ReplyStatus.BytesReceived, ReplyStatus.MsRoundTripTime, ReplyStatus.TimeToLive]);
  except
  end;
end;

procedure TVDSIcmpPingThread.Execute;
var
ThreadNo: Integer;
begin
  try
  ThreadNo := IcmpClientPingThreadNo;

  IcmpClient[ThreadNo].Host := IcmpClientPingThreadHost[ThreadNo];
  if not(IcmpClientPingThreadPort[ThreadNo] = '') then
  begin
    if StrToInt(IcmpClientPingThreadPort[ThreadNo]) >= 0 then
    IcmpClient[ThreadNo].Port := StrToInt(IcmpClientPingThreadPort[ThreadNo])
    else
    IcmpClient[ThreadNo].Port := 0;
  end
  else
  IcmpClient[ThreadNo].Port := 0;

  IcmpClient[ThreadNo].Ping;

  exteventproc(eventproc)(PChar('ICMP'+IntToStr(ThreadNo)+'ONPINGDONE'));
  IcmpClientPingThread[ThreadNo].Terminate;
  except
  end;
end;

procedure TVDSIcmpClient.IcmpWorkBegin(Sender: TObject; AWorkMode: TWorkMode; const AWorkCountMax: Integer);
begin
  IcmpClientTotalBytes[StrToInt(Copy(Name,5,2))] := 0;
  IcmpClientCurrBytes[StrToInt(Copy(Name,5,2))] := 0;
  IcmpClientTotalBytes[StrToInt(Copy(Name,5,2))] := AWorkcountMax;
end;

procedure TVDSIcmpClient.IcmpWork(Sender: TObject; AWorkMode: TWorkMode; const AWorkCount: Integer);
begin
  IcmpClientCurrBytes[StrToInt(Copy(Name,5,2))] := AWorkCount;
end;

{ICMP CLIENT EVENTS}

{NTP CLIENT EVENTS}

procedure TVDSNtpGettimeThread.Execute;
var
ThreadNo: Integer;
begin
  try
  ThreadNo := NtpClientGettimeThreadNo;

  NtpClient[ThreadNo].Host := NtpClientGettimeThreadHost[ThreadNo];

  if not(NtpclientGettimeThreadPort[ThreadNo] = '') then
  begin
    if StrToInt(NtpclientGettimeThreadPort[ThreadNo]) >= 0 then
    NtpClient[ThreadNo].Port := StrToInt(NtpclientGettimeThreadPort[ThreadNo])
    else
    NtpClient[ThreadNo].Port := 37;
  end
  else
  NtpClient[ThreadNo].Port := 37;
  NtpClient[ThreadNo].Host := NtpClientGettimeThreadHost[ThreadNo];
  NtpClientDateTimeStr[ThreadNo] := DateTimeToStr(NtpClient[ThreadNo].DateTime);
  str(StrToDateTime(NtpClientDateTimeStr[ThreadNo]):1:10,NtpClientDateTimeEnc[ThreadNo]);

  exteventproc(eventproc)(PChar('NTP'+IntToStr(ThreadNo)+'ONGETTIMEDONE'));
  NtpClientGettimeThread[ThreadNo].Terminate;
  except
  NtpClientDateTimeStr[ThreadNo] := '';
  NtpClientDateTimeEnc[ThreadNo] := '';
  end;
end;

procedure TVDSNtpClient.NtpWorkBegin(Sender: TObject; AWorkMode: TWorkMode; const AWorkCountMax: Integer);
begin
  NtpClientTotalBytes[StrToInt(Copy(Name,4,2))] := 0;
  NtpClientCurrBytes[StrToInt(Copy(Name,4,2))] := 0;
  NtpClientTotalBytes[StrToInt(Copy(Name,4,2))] := AWorkcountMax;
end;

procedure TVDSNtpClient.NtpWork(Sender: TObject; AWorkMode: TWorkMode; const AWorkCount: Integer);
begin
  NtpClientCurrBytes[StrToInt(Copy(Name,4,2))] := AWorkCount;
end;

{NTP CLIENT EVENTS}

procedure TVDSNtpServer.NtpServerRequest(AThread: TIdPeerThread);
begin
  try
  exteventproc(eventproc)(PChar('NTP-SERVER'+Copy(Name,11,2)+'ONREQUEST'));
  except
  end;
end;

{WHOISCLIENT EVENTS}

procedure TVDSWhoisQueryThread.Execute;
var
ThreadNo: Integer;
begin
  try
  ThreadNo := WhoisClientQueryThreadNo;

  if not(WhoisClientQueryThreadStr[ThreadNo] = '') then
  WhoisClientStr[ThreadNo] := WhoisClient[ThreadNo].WhoIs(WhoisClientQueryThreadStr[ThreadNo]);

  exteventproc(eventproc)(PChar('WHOIS'+IntToStr(ThreadNo)+'ONQUERYDONE'));
  WhoisClientQueryThread[ThreadNo].Terminate;
  except
  end;
end;

procedure TVDSWhoisClient.WhoisWorkBegin(Sender: TObject; AWorkMode: TWorkMode; const AWorkCountMax: Integer);
begin
  WhoisClientTotalBytes[StrToInt(Copy(Name,6,2))] := 0;
  WhoisClientCurrBytes[StrToInt(Copy(Name,6,2))] := 0;
  WhoisClientTotalBytes[StrToInt(Copy(Name,6,2))] := AWorkcountMax;
end;

procedure TVDSWhoisClient.WhoisWork(Sender: TObject; AWorkMode: TWorkMode; const AWorkCount: Integer);
begin
  WhoisClientCurrBytes[StrToInt(Copy(Name,6,2))] := AWorkCount;
end;

{WHOISCLIENT EVENTS}

procedure TVDSWhoisServer.WhoisServerCommandLookup(AThread: TIdPeerThread; ALookup: String);
begin
  try
  WhoisServerStr[StrToInt(Copy(Name,13,2))] := ALookUp;
  WhoisServerSimpleClient[StrToInt(Copy(Name,13,2))] := AThread;

  exteventproc(eventproc) (PChar('WHOIS-SERVER'+Copy(Name,13,2)+'ONREQUEST'));
  except
  end;
end;

{ECHOCLIENT EVENTS}

procedure TVDSEchoConnectThread.Execute;
var
ThreadNo: Integer;
begin
  try
  ThreadNo := EchoClientConnectThreadNo;
  if EchoClient[ThreadNo].Connected then
  try
  EchoClient[ThreadNo].Disconnect;
  except
  end;
  EchoClient[ThreadNo].Host := EchoClientConnectThreadHost[ThreadNo];
  if not(EchoClientConnectThreadPort[ThreadNo] = '') then
  begin
    if StrToInt(EchoClientConnectThreadPort[ThreadNo]) >= 0 then
    EchoClient[ThreadNo].Port := StrToInt(EchoClientConnectThreadPort[ThreadNo])
    else
    EchoClient[ThreadNo].Port := 7;
  end
  else
  EchoClient[ThreadNo].Port := 7 ;

  EchoClient[ThreadNo].Connect;
  if EchoClient[ThreadNo].Connected = True then
  begin
    exteventproc(eventproc)(PChar('ECHO'+IntToStr(ThreadNo)+'ONCONNECT'));
  end;
  EchoClientConnectThread[ThreadNo].Terminate;
  except
  end;
end;

procedure TVDSEchoDisconnectThread.Execute;
var
ThreadNo: Integer;
begin
  try
  ThreadNo := EchoClientDisconnectThreadNo;
  EchoClient[ThreadNo].Disconnect;
  EchoClientDisconnectThread[ThreadNo].Terminate;
  except
  end;
end;

procedure TVDSEchoClient.EchoDisconnected(Sender: TObject);
begin
  try
  if EchoClientUseThread[StrToInt(Copy(Name,5,2))] = True then
  exteventproc(eventproc)(PChar('ECHO'+Copy(Name,5,2)+'ONDISCONNECT'));
  except
  end;
end;

procedure TVDSEchoRequestThread.Execute;
var
ThreadNo: Integer;
begin
  try
  ThreadNo := EchoClientRequestThreadNo;
  EchoClientStr[ThreadNo] := EchoClient[ThreadNo].Echo(EchoClientRequestThreadStr[ThreadNo]);
  EchoClientTime[ThreadNo] := IntToStr(EchoClient[ThreadNo].EchoTime);
  EchoClientRequestThread[ThreadNo].Terminate;

  exteventproc(eventproc)(PChar('ECHO'+IntToStr(ThreadNo)+'ONECHOREQUESTDONE'));
  except
  end;
end;

procedure TVDSEchoClient.EchoWorkBegin(Sender: TObject; AWorkMode: TWorkMode; const AWorkCountMax: Integer);
begin
  EchoClientTotalBytes[StrToInt(Copy(Name,5,2))] := 0;
  EchoClientCurrBytes[StrToInt(Copy(Name,5,2))] := 0;
  EchoClientTotalBytes[StrToInt(Copy(Name,5,2))] := AWorkcountMax;
end;

procedure TVDSEchoClient.EchoWork(Sender: TObject; AWorkMode: TWorkMode; const AWorkCount: Integer);
begin
  EchoClientCurrBytes[StrToInt(Copy(Name,5,2))] := AWorkCount;
end;

{ECHOCLIENT EVENTS}


procedure TVDSEchoServer.EchoServerConnect(AThread: TIdPeerThread);
begin
  exteventproc(eventproc) (PChar('ECHO-SERVER'+Copy(Name,12,2)+'ONCONNECT'));
end;

procedure TVDSEchoServer.EchoServerDisconnect(AThread: TIdPeerThread);
begin
  exteventproc(eventproc) (PChar('ECHO-SERVER'+Copy(Name,12,2)+'ONDISCONNECT'));
end;

{UDPCLIENT EVENTS}

procedure TVDSUdpSendThread.Execute;
var
ThreadNo: Integer;
begin
  try
  ThreadNo := UdpClientSendThreadNo;

  if not(UdpClientSendThreadStr[ThreadNo] = '') then
  UdpClient[ThreadNo].Send(UdpClientSendThreadStr[ThreadNo]);

  //exteventproc(eventproc)(PChar('UDP'+IntToStr(ThreadNo)+'ONSENDDONE'));
  UdpClientSendThread[ThreadNo].Terminate;
  except
  end;
end;

procedure TVDSUdpClient.UdpWorkBegin(Sender: TObject; AWorkMode: TWorkMode; const AWorkCountMax: Integer);
begin
  UdpClientTotalBytes[StrToInt(Copy(Name,4,2))] := 0;
  UdpClientCurrBytes[StrToInt(Copy(Name,4,2))] := 0;
  UdpClientTotalBytes[StrToInt(Copy(Name,4,2))] := AWorkcountMax;
end;

procedure TVDSUdpClient.UdpWork(Sender: TObject; AWorkMode: TWorkMode; const AWorkCount: Integer);
begin
  UdpClientCurrBytes[StrToInt(Copy(Name,4,2))] := AWorkCount;
end;

procedure TVDSUdpClientTimer.TimerEvent(Sender: TObject);
var
UDPClientInteger: Integer;
begin
UDPClientInteger := 1;
repeat
  try
  if UdpClient[UDPClientInteger].Active = False then
    exit;
  UdpClientStr[UDPClientInteger] := UdpClient[UDPClientInteger].ReceiveString(5);
  if not(UdpClientStr[UDPClientInteger] = '') then
  begin
    if UdpClientUseThread[UdpClientInteger] = True then
    exteventproc(eventproc)(PChar('UDP'+IntToStr(UDPClientInteger)+'ONMESSAGE'));
  end;
  except
  end;
UDPClientInteger := UDPClientInteger + 1;
until UDPClientInteger = 100;
end;

{UDPCLIENT EVENTS}


procedure TVDSUdpServer.UDPServerMessage(Sender: TObject; AData: TStream; ABinding: TIdSocketHandle);
var
  DataStringStream: TStringStream;
begin
  DataStringStream := TStringStream.Create('');
  try
    DataStringStream.CopyFrom(AData, AData.Size);
    UdpServerCurrUsr[StrToInt(Copy(Name,11,2))] := ABinding;
    UdpServerCurrUsrIp[StrToInt(Copy(Name,11,2))] := ABinding.PeerIP;
    UdpServerCurrUsrPort[StrToInt(Copy(Name,11,2))] := IntToStr(ABinding.PeerPort);
    UdpServerCurrUserMsg[StrToInt(Copy(Name,11,2))] := DataStringStream.DataString;
  finally
    DataStringStream.Free;
  end;
    exteventproc(eventproc) (PChar('UDP-SERVER'+Copy(Name,11,2)+'ONMESSAGE'));
end;

initialization
finalization
try
  TcpClientTimer.Enabled := False;
  TcpClientTimer.Free;
  UdpClientTimer.Enabled := False;
  UdpClientTimer.Free;
  Form1.Free;
except
end;
end.
