unit VDSMEMDLL;

interface
uses
  WinTypes, SysUtils, Forms, Classes, PBShareMap;

type
  exteventproc = procedure(eventtype: PChar);
  cdecl;
  type TPBEvent = class(TPBShareMap)
  private
  procedure OnChange(Sender: TObject);
  end;
    TForm1 = class(TForm)
    PBShareMap1: TPBShareMap;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

const
  max_par = 25;        { maximum number of params/args (user-definable) }
  buf_size = 256;     { parameter buffer size (user-definable) }

var
  Form1: TForm1;
  AHandle: THandle;   { application handle }
  eventproc: exteventproc;
  p, errorcode: Integer;
  PBEvent1: TPBEvent;
  PBShareMap1: TPBShareMap;
  parambuf: Array[0..buf_size-1] of Char; { use GetMem/FreeMem for large buffers }
  { start user-defined variables }
  DefaultDir: String;
  DefaultDoc: String;
  DefaultPort: String;
  rstat: Boolean;
  { end user-defined variables }

function Init(Handle: THandle; Addr: exteventproc; KeyString: PChar; var maxpar,bufsize: Integer): PChar; export;
cdecl;
function CommandProc(Params: PChar): Integer; export;
cdecl;
function FuncProc(Args: PChar): PChar; export;
cdecl;
function StatProc: Integer; export;
cdecl;

implementation

{$R *.DFM}

function NextParam: PChar; {get next command parameter}
begin
  Result := Addr(parambuf[p]);
  while parambuf[p]<>#0 do
  begin
    inc(p);
  end;
  inc(p);
end;


{ begin exported functions }

function Init(Handle: THandle; addr: exteventproc; KeyString: PChar; var maxpar,bufsize: Integer): PChar;
 begin
 AHandle := Handle;
 eventproc := addr;
 maxpar := max_par;
 bufsize := buf_size;
 Form1 := TForm1.Create(nil);
 PBShareMap1 := TPBShareMap.Create(Form1);
 Result := 'MEMORYMAP';
 PBShareMap1.OnChange := PBEvent1.OnChange;
 {return the command/function name }
 end;

function CommandProc(Params: PChar): Integer;
var
  Buffer1: String;
  Buffer2: String;
  Buffer3: String;

begin
  errorcode := 0;                         {initialise errorcode}
  for p := 0 to pred(buf_size) do
    parambuf[p] := Params[p];             {copy parameter string into buffer}
  p := 0;                                 {set pointer for NextParam}
  { start user-defined code }
  Buffer1 := UpperCase(NextParam);

  if (Buffer1 = 'OPEN') then
    begin
    try
    Buffer2 := NextParam;
    Buffer3 := NextParam;
    if not(Buffer2 = '') then
    begin
    PBShareMap1.MapName := Buffer2;
    if not(Buffer3 = '') and (StrToInt(Buffer3) > 0) then
    begin
    PBShareMap1.MaxSize := cardinal(Buffer3);
    end
    else
    begin
    PBShareMap1.MaxSize := 4096;
    end;
    PBShareMap1.AutoOpen := True;
    PBShareMap1.AutoSynchronize := True;
    PBShareMap1.OpenMap;
    end
    except
    end;
    end
  else
  if (Buffer1 = 'CLOSE') then
    begin
    try
    PBShareMap1.CloseMap;
    except
    end;
    end
  else
  if (Buffer1 = 'SET') then
  begin
     Buffer2 := NextParam;
     Buffer3 := NextParam;
     if not(Buffer2 = '') then
     begin
     try
     PBShareMap1[Buffer2]:= Buffer3;
     except
     end;
     end
     else
     begin
     end;
  end;
  { end user-defined code }
  Result := errorcode;
end;

function FuncProc(Args: PChar): PChar;
var
  buffer1: string;
  buffer2: string;
  resultbuf: string;
  resbuf: Array[0..255] of Char;
begin
  { don't zeroise errorcode in case it is set by previous function }
  for p := 0 to pred(buf_size) do
    parambuf[p] := Args[p];             {copy parameter string into buffer}
  p := 0;                                 {set pointer for NextParam}
  { start user-defined code }

  Buffer1 := UpperCase(NextParam);

  if (Buffer1 = 'GET') then
  begin
  Buffer2 := NextParam;
  resultbuf := PBShareMap1[Buffer2];
  end
  else
  if (Buffer1 = 'GETALL') then
  begin
  resultbuf := PBShareMap1.MapStrings.GetText;
  end;


  { end user-defined code }
  StrCopy(resbuf,PChar(resultbuf));
  Result := resbuf;
end;

function StatProc: Integer;
{ this function requires no modification }
begin
  Result := errorcode;
end;

procedure TPBEvent.OnChange(Sender: TObject);
begin
exteventproc(eventproc) ('MEMORYMAPCHANGED');
end;

initialization
finalization
  try
  Form1.Free;
  except on Exception do
  end;

end.


