unit ScreenSaver;

interface

uses
  WinTypes, SysUtils, Graphics, Registry, Classes, Forms;

type
  exteventproc = procedure(eventtype: PChar);
  cdecl;

const
  max_par = 4;
  buf_size = 256;

var
  AHandle: THandle;
  eventproc: exteventproc;
  p, errorcode: Integer;
  Dummy: Boolean;
  hTaskBar: HWnd;
  parambuf: Array[0..buf_size-1] of Char;

function Init(Handle: THandle; Addr: exteventproc; KeyString: PChar; var maxpar,bufsize: Integer): PChar; export;
{$IFNDEF VER80}
cdecl;
{$ENDIF}

function CommandProc(Params: PChar): Integer; export;
{$IFNDEF VER80}
cdecl;
{$ENDIF}

function FuncProc(Args: PChar): PChar; export;
{$IFNDEF VER80}
cdecl;
{$ENDIF}

function StatProc: Integer; export;
{$IFNDEF VER80}
cdecl;
{$ENDIF}

function GetPassword: Boolean;

implementation

function NextParam: PChar;
begin
  Result := Addr(parambuf[p]);
  while parambuf[p] <> #0 do
  begin
    inc(p);
  end;
  inc(p);
end;

function Init(Handle: THandle; addr: exteventproc; KeyString: PChar; var maxpar,bufsize: Integer): PChar;
 begin
 AHandle := Handle;
 eventproc := addr;
 maxpar := max_par;
 bufsize := buf_size;
 Result := 'SCREENSAVER';
 end;

function CommandProc(Params: PChar): Integer;
var
  Buffer: string;
  Buffer2: string;
  Buffer3: string;
  respos: integer;
  resfilename: string;
  res: integer;
  resource: TFileStream;
  ScrWidth: Integer;
  ScrHeight: Integer;
  Window: HWnd;
  MyRect: TRect;
  MyCanvas: TCanvas;
  Picture: TPicture;
  SysDir: string;
  NewLen: Integer;
  MyMod: THandle;
  PwdFunc: function(a: PChar; ParentHandle: THandle; b,c: Integer): Integer; stdcall;
  DeskTopDC: HDc;
  DeskTopCanvas: TCanvas;
  DeskTopRect: TRect;
  Bitmap: TBitmap;
begin
  errorcode := 0;
  for p := 0 to pred(buf_size) do
    parambuf[p] := Params[p];
  p := 0;

  Buffer := UpperCase(NextParam);
  if Buffer = 'PREVIEW' then
  begin
  try
    Buffer2 := NextParam;
    if not(Buffer2 = '') then
    begin
    Window := StrToInt(Buffer2);
    while not(IsWindowVisible(Window)) do
    Application.ProcessMessages;
    GetWindowRect(Window,MyRect);
    ScrWidth := MyRect.Right - MyRect.Left + 1;
    ScrHeight := MyRect.Bottom - MyRect.Top + 1;
    MyRect := Rect(0,0,ScrWidth - 1,ScrHeight - 1);
    MyCanvas := TCanvas.Create;
    MyCanvas.Handle := GetDC(Window);
    Picture := TPicture.Create;
      Buffer3 := NextParam;
      if not(Buffer3 = '') then
      begin
      respos := Pos('|',Buffer3);
      if respos = 0 then
      begin
      resfilename := Buffer3;
      res := 0;
      end
      else
      begin
      resfilename := Copy(Buffer3,1,pred(respos));
      try
      res := StrToInt(Copy(Buffer3,succ(respos),999));
      except
      res := 0;
      end;
      end;
      if FileExists(resfilename) then
      begin
      try
      resource := TFileStream.Create(resfilename,fmOpenRead);
      except on EFOpenError do
      end;
    try
      if res > 0 then resource.Seek(res,0);
      Picture.Bitmap := nil;
      try
      Picture.Bitmap.LoadFromStream(resource)
      except
      end;
    finally
    resource.Destroy;
    end;
    end;
    while IsWindowVisible(Window) do
    begin
      MyCanvas.StretchDraw(MyRect,Picture.Graphic);
      Application.ProcessMessages;
      Sleep(10);
    end;
    Picture.Free;
    MyCanvas.Free;
    end;
    end;
  except
  end;
  end
  else if Buffer = 'PASSWORD' then
  begin
    SetLength(SysDir,MAX_PATH);
    NewLen := GetSystemDirectory(PChar(SysDir),MAX_PATH);
    SetLength(SysDir,NewLen);
    if (Length(SysDir) > 0) and (SysDir[Length(SysDir)] <> '\') then
      SysDir := SysDir + '\';
    MyMod := LoadLibrary(PChar(SysDir + 'MPR.DLL'));
    if MyMod <> 0 then
    begin
      PwdFunc := GetProcAddress(MyMod,'PwdChangePasswordA');
      if Assigned(PwdFunc) then
      Buffer2 := NextParam;
      if not(Buffer2 = '') then
      begin
        PwdFunc('SCRSAVE',StrToInt(Buffer2),0,0);
      end;
      FreeLibrary(MyMod);
    end;
  end
  else if Buffer = 'SHOWCURSOR' then
    ShowCursor(True)
  else if Buffer = 'HIDECURSOR' then
    ShowCursor(False)
  else if Buffer = 'ENABLEKEYS' then
    SystemParametersInfo(SPI_SCREENSAVERRUNNING,0,@Dummy,0)
  else if Buffer = 'DISABLEKEYS' then
    SystemParametersInfo(SPI_SCREENSAVERRUNNING,1,@Dummy,0)
  else if Buffer = 'SHOWTASKBAR' then
  begin
    hTaskBar := FindWindow('Shell_TrayWnd',nil);
    ShowWindow(hTaskBar,SW_SHOW);
  end
  else if Buffer = 'HIDETASKBAR' then
  begin
    hTaskBar := FindWindow('Shell_TrayWnd',nil);
    ShowWindow(hTaskBar,SW_HIDE);
  end
  else if Buffer = 'CAPTURE' then
  begin
    DeskTopDC := GetWindowDC(GetDeskTopWindow);
    DeskTopCanvas := TCanvas.Create;
    DeskTopCanvas.Handle := DeskTopDC;
    DeskTopRect := Rect(0,0,GetSystemMetrics(SM_CXSCREEN),GetSystemMetrics(SM_CYSCREEN));
    Bitmap := TBitmap.Create;
    Bitmap.Width := GetSystemMetrics(SM_CXSCREEN);
    Bitmap.Height := GetSystemMetrics(SM_CYSCREEN);
    Bitmap.PixelFormat := pfDevice;
    Bitmap.Canvas.CopyRect(DeskTopRect,DeskTopCanvas,DeskTopRect);
    Buffer2 := NextParam;
    if not(Buffer2 = '') then
    begin
    Bitmap.SaveToFile(Buffer2);
    end;
    Bitmap.Free;
    DesktopCanvas.Free;
    ReleaseDC(GetDeskTopWindow,DeskTopDC);
  end
  else
    Errorcode := 14;
  Result := errorcode;
end;

function FuncProc(Args: PChar): PChar;
var
  Buffer: string;
  Resbuf: string;
  ResultBuf: Array[0..255] of Char;
  i: integer;
begin
  for p := 0 to pred(buf_size) do
    parambuf[p] := Args[p];
  p := 0;
  Buffer := UpperCase(NextParam);
  if Buffer = 'PASSWORD' then
    if GetPassword then
      Resbuf := '1'
    else
      Resbuf := '0'
  else if Buffer = 'KEYDOWN' then
  begin
    Resbuf := '0';
    for i := 0 to 253 do
    if (GetASyncKeyState(i) = -32767) or (GetASyncKeyState(i) = -32768) then
    begin
      Resbuf := '1';
      Break;
    end;
  end;
  StrCopy(ResultBuf,PChar(Resbuf));
  Result := ResultBuf;
end;

function StatProc: Integer;
begin
  Result := errorcode;
end;

function GetPassword: Boolean;
var
  PwdFunc: function(Parent: THandle): Boolean; stdcall;
  BufferNew : PChar;
  MyReg: TRegistry;
  SysDir: String;
  NewLen: Integer;
  MyMod: THandle;
begin
  Result := False;
  MyReg := TRegistry.Create;
  MyReg.RootKey := HKEY_CURRENT_USER;
  if MyReg.OpenKey('Control Panel\Desktop',False) then
  begin
    try
      if MyReg.ReadInteger('ScreenSaveUsePassword') <> 0 then
      begin
        SetLength(SysDir,MAX_PATH);
        NewLen := GetSystemDirectory(PChar(SysDir),MAX_PATH);
        SetLength(SysDir,NewLen);
        if (Length(SysDir) > 0) and (SysDir[Length(SysDir)] <> '\') then
          SysDir := SysDir+'\';
        MyMod := LoadLibrary(PChar(SysDir + 'PASSWORD.CPL'));
        if MyMod = 0 then
          Result := True
        else
        begin
          PwdFunc := GetProcAddress(MyMod,'VerifyScreenSavePwd');
          BufferNew := NextParam;
          if (BufferNew = '') then
          begin
          BufferNew := '';
          end;
          if PwdFunc(FindWindow(nil,BufferNew)) then
            Result := True;
          FreeLibrary(MyMod);
        end;
      end
      else
        Result := True;
    except
      Result := True;
    end;
  end
  else
    Result := True;
  MyReg.Free;
end;

initialization
finalization
    ShowCursor(True);
    SystemParametersInfo(SPI_SCREENSAVERRUNNING,0,@Dummy,0);
    ShowWindow(hTaskBar,SW_SHOW);
end.
