unit VDSVOLDLL;

interface

uses
  WinTypes, WinProcs, SysUtils, MMSystem;

type
  exteventproc = procedure(eventtype: PChar);
  {$IFNDEF VER80}
  cdecl;
  {$ENDIF}

const
  max_par = 2;        { maximum number of params/args (user-definable) }
  buf_size = 256;     { parameter buffer size (user-definable) }

var
  AHandle: THandle;   { application handle }
  eventproc: exteventproc;
  p, errorcode: Integer;
  parambuf: Array[0..buf_size-1] of Char; { use GetMem/FreeMem for large buffers }

  { start user-defined variables }
  rstat: Boolean;
  { end user-defined variables }

function Init(Handle: THandle; Addr: exteventproc; KeyString: PChar; var maxpar,bufsize: Integer): PChar; export;
{$IFNDEF VER80}
cdecl;
{$ENDIF}

function CommandProc(Params: PChar): Integer; export;
{$IFNDEF VER80}
cdecl;
{$ENDIF}

function FuncProc(Args: PChar): PChar; export;
{$IFNDEF VER80}
cdecl;
{$ENDIF}

function StatProc: Integer; export;
{$IFNDEF VER80}
cdecl;
{$ENDIF}

implementation

function GetWaveVolume(var LVol:DWord; var RVol:DWord): Boolean;
var
  WaveOutCaps : TWAVEOUTCAPS;
  Volume : DWord;
begin
  Result := false;
  if WaveOutGetDevCaps(WAVE_MAPPER, @WaveOutCaps, SizeOf(WaveOutCaps)) = MMSYSERR_NOERROR then
    if WaveOutCaps.dwSupport and WAVECAPS_VOLUME = WAVECAPS_VOLUME then
    begin
     Result := WaveOutGetVolume(WAVE_MAPPER, @Volume) = MMSYSERR_NOERROR;
     LVol := LoWord(Volume);
     RVol := HiWord(Volume);
    end;
end;

function SetWaveVolume(const AVolume: DWord) : boolean;
var
  WaveOutCaps : TWAVEOUTCAPS;
begin
  Result := False;
  if WaveOutGetDevCaps(WAVE_MAPPER, @WaveOutCaps, sizeof(WaveOutCaps)) = MMSYSERR_NOERROR then
    if WaveOutCaps.dwSupport and WAVECAPS_VOLUME = WAVECAPS_VOLUME then
      Result := WaveOutSetVolume(WAVE_MAPPER, AVolume) = MMSYSERR_NOERROR;
end;

{ begin utility functions (not exported) }
function NextParam: PChar; {get next command parameter}
begin
  Result := Addr(parambuf[p]);
  while parambuf[p]<>#0 do
  begin
    inc(p);
  end;
  inc(p);
end;

{ end utility functions }

{ begin exported functions }

function Init(Handle: THandle; addr: exteventproc; KeyString: PChar; var maxpar,bufsize: Integer): PChar;
begin
  AHandle := Handle;
  eventproc := addr;
  maxpar := max_par;
  bufsize := buf_size;
  { start user-defined code }
  Result := 'VOLUME';                    {return the command/function name  }
  rstat := true;
  { end user-defined code }
end;

function CommandProc(Params: PChar): Integer;
var
  buffer1: string;
  buffer2: string;
  LVol: Word;
  RVol: Word;
begin
  Errorcode := 0;
  for p := 0 to pred(buf_size) do
    parambuf[p] := Params[p];
  p := 0;
  { start user-defined code }
  Buffer1 := NextParam;
  Buffer2 := NextParam;
  if not(Buffer1 = '') AND not(Buffer2 = '') then
    begin
      try
        if StrToInt(Buffer1) >= 0 then
          LVol := StrToInt(Buffer1);
        if StrToInt(Buffer2) >= 0 then
          RVol := StrToInt(Buffer2);
        SetWaveVolume(MakeLong(LVol, RVol));
      except
      end;
    end
    else
      errorcode := 2;
  { end user-defined code }
  Result := errorcode;
end;

function FuncProc(Args: PChar): PChar;
var
  buffer1: string;
  LVol: DWord;
  RVol: DWord;
  resultbuf: string;
  resbuf: Array[0..255] of Char;
begin
  { don't zeroise errorcode in case it is set by previous function }
  for p := 0 to pred(buf_size) do
    parambuf[p] := Args[p];             {copy parameter string into buffer}
  p := 0;                                 {set pointer for NextParam}
  { start user-defined code }
    Buffer1 := NextParam;
    if UpperCase(Buffer1) = 'R' then
      begin
        if GetWaveVolume(LVol, RVol) then
        resultbuf := IntToStr(RVol);
      end
    else
      if UpperCase(Buffer1) = 'L' then
        begin
          GetWaveVolume(LVol, RVol);
          resultbuf := IntToStr(LVol);
        end
      else
      Errorcode := 7;
  { end user-defined code }
  StrCopy(resbuf,PChar(resultbuf));
  Result := resbuf;
end;

function StatProc: Integer;
{ this function requires no modification }
begin
  Result := errorcode;
end;

end.
