unit VDSWINVERDLL;

interface

uses
  WinTypes, WinProcs, SysUtils, Registry;

type
  exteventproc = procedure(eventtype: PChar);
  {$IFNDEF VER80}
  cdecl;
  {$ENDIF}

const
  max_par = 1;        { maximum number of params/args (user-definable) }
  buf_size = 256;     { parameter buffer size (user-definable) }
 TPlatformID: array[VER_PLATFORM_WIN32s..VER_PLATFORM_WIN32_NT] of string = ('0', '1', '2');
  VER_NT_WORKSTATION = 1;
  VER_NT_DOMAIN_CONTROLLER = 2;
  VER_NT_SERVER = 3;
  TProductType: array[VER_NT_WORKSTATION..VER_NT_SERVER] of string = ('1', '2', '3');
  VER_SUITE_SMALLBUSINESS = 1;
  VER_SUITE_ENTERPRISE = 2;
  VER_SUITE_BACKOFFICE = 4;
  VER_SUITE_COMMUNICATIONS = 8;
  VER_SUITE_TERMINAL = 10;
  VER_SUITE_SMALLBUSINESS_RESTRICTED = 20;
  VER_SUITE_EMBEDDEDNT = 40;
  VER_SUITE_DATACENTER = 80;
  VER_SUITE_SINGLEUSERTS = 100;
  VER_SUITE_PERSONAL = 200;
  VER_SUITE_SERVERAPPLIANCE = 400;

var
  AHandle: THandle;   { application handle }
  eventproc: exteventproc;
  p, errorcode: Integer;
  parambuf: Array[0..buf_size-1] of Char; { use GetMem/FreeMem for large buffers }

  { start user-defined variables }
  rstat: Boolean;
  { end user-defined variables }

function Init(Handle: THandle; Addr: exteventproc; KeyString: PChar; var maxpar,bufsize: Integer): PChar; export;
{$IFNDEF VER80}
cdecl;
{$ENDIF}

function CommandProc(Params: PChar): Integer; export;
{$IFNDEF VER80}
cdecl;
{$ENDIF}

function FuncProc(Args: PChar): PChar; export;
{$IFNDEF VER80}
cdecl;
{$ENDIF}

function StatProc: Integer; export;
{$IFNDEF VER80}
cdecl;
{$ENDIF}

function WindowsVersion(Input: String): String;

implementation

{ begin utility functions (not exported) }
function NextParam: PChar; {get next command parameter}
begin
  Result := Addr(parambuf[p]);
  while parambuf[p]<>#0 do
  begin
    inc(p);
  end;
  inc(p);
end;

{ end utility functions }

{ begin exported functions }

function Init(Handle: THandle; addr: exteventproc; KeyString: PChar; var maxpar,bufsize: Integer): PChar;
begin
  AHandle := Handle;
  eventproc := addr;
  maxpar := max_par;
  bufsize := buf_size;
  { start user-defined code }
  Result := 'WINVER';                    {return the command/function name  }
  rstat := true;
  { end user-defined code }
end;

function CommandProc(Params: PChar): Integer;
begin
  Errorcode := 0;
  for p := 0 to pred(buf_size) do
    parambuf[p] := Params[p];
  p := 0;
  { start user-defined code }
  errorcode := 1;
  { end user-defined code }
  Result := errorcode;
end;

function FuncProc(Args: PChar): PChar;
var
  buffer1: string;
  resultbuf: string;
  resbuf: Array[0..255] of Char;
begin
  { don't zeroise errorcode in case it is set by previous function }
  for p := 0 to pred(buf_size) do
    parambuf[p] := Args[p];             {copy parameter string into buffer}
  p := 0;                                 {set pointer for NextParam}
  { start user-defined code }
    buffer1 := NextParam;
    resultbuf := WindowsVersion(buffer1);
  { end user-defined code }
  StrCopy(resbuf,PChar(resultbuf));
  Result := resbuf;
end;

function StatProc: Integer;
{ this function requires no modification }
begin
  Result := errorcode;
end;

function WindowsVersion(Input: String): String;
type
OSVERSIONINFOEX = packed record
dwOSVersionInfoSize: DWORD;
dwMajorVersion: DWORD;
dwMinorVersion: DWORD;
dwBuildNumber: DWORD;
dwPlatformId: DWORD;
szCSDVersion: Array [0..127 ] of Char;
wServicePackMajor: WORD;
wServicePackMinor: WORD;
wSuiteMask: WORD;
wProductType: BYTE;
wReserved: BYTE;
end;
TOSVersionInfoEx = OSVERSIONINFOEX;
POSVersionInfoEx = ^TOSVersionInfoEx;
var
  OSVersion: TOSVersionInfoEx;
  OSVersionOld: TOSVersionInfo;
  pVer : POSVersionInfo; // old version!
  BOSVersionInfoEx: Boolean;
  RegistryRead: TRegistry;
  SuiteVar: String;
  BuildNo: String;
Begin
  BOSVersionInfoEX := True;

  FillChar( OSVersion, sizeof(OSVersion), 0 );
  OSVersion.dwOSVersionInfoSize := sizeof( OSVersion );
  pVer := @OSVersion;

  if not BOSVersionInfoEX = GetVersionEx( pVer^ ) Then
  begin
    FillChar( OSVersion,sizeof(OSVersionOld), 0);
    OSVersion.dwOSVersionInfoSize := sizeOf( OSVersionOld );
    GetVersionEx( OSVersionOld );
    BOSVersionInfoEX := False;
  end;

  if BOSversionInfoEx then
  begin
    if OSVersion.wProductType = VER_NT_WORKSTATION then
    begin
      if OSVersion.wSuiteMask = VER_SUITE_PERSONAL then
      SuiteVar := 'Personal'
      else
      SuiteVar := 'Professional';
    end
    else
    if OSVersion.wProductType = VER_NT_SERVER then
    begin
      if OSVersion.wSuiteMask = VER_SUITE_DATACENTER then
      SuiteVar := 'Datacenter Server'
      else
      if OSVersion.wSuiteMask = VER_SUITE_ENTERPRISE then
      SuiteVar := 'Advanced Server'
      else
      SuiteVar :=  'Server';
    end;
  end
  else
  begin
    RegistryRead := TRegistry.Create;
    RegistryRead.RootKey := HKEY_LOCAL_MACHINE;
    RegistryRead.OpenKey('System\CurrentControlSet\Control\ProductOptions', False);

    if UpperCase(RegistryRead.ReadString('ProductType')) = 'WINNT' then
    SuiteVar := 'Workstation'
    else
    if UpperCase(RegistryRead.ReadString('ProductType')) = 'SERVERNT' then
    SuiteVar := 'Server';

    RegistryRead.CloseKey;
    RegistryRead.Free;
  end;
  if Uppercase(Input) = 'PLATFORM' then
  result := IntToStr(OSVersion.dwPlatformId)
  else
  if Uppercase(Input) = 'MAJOR' then
  result := IntToStr(OSVersion.dwMajorVersion)
  else
  if Uppercase(Input) = 'MINOR' then
  result := IntToStr(OSVersion.dwMinorVersion)
  else
  if Uppercase(Input) = 'BUILD' then
  result := IntToStr(OSVersion.dwBuildNumber and $FFFF)
  else
  if Uppercase(Input) = 'SUBBUILD' then
  result := Trim(OSVersion.szCSDVersion)
  else
  if Uppercase(Input) = 'SUITE' then
  result := SuiteVar
  else
  if Uppercase(Input) = 'SERVICEPACK' then
  result := IntToStr(OSVersion.wServicePackMajor and $FFFF)+'.'+IntToStr(OSVersion.wServicePackMinor and $FFFF);
end;


end.
